/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.healthbar;

import com.gmail.filoghost.healthbar.Configuration;
import com.gmail.filoghost.healthbar.Main;
import com.gmail.filoghost.healthbar.api.BarHideEvent;
import com.gmail.filoghost.healthbar.utils.PlayerBarUtils;
import com.gmail.filoghost.healthbar.utils.Utils;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class PlayerBar {
    private static final Plugin instance = Main.plugin;
    private static Scoreboard sb = instance.getServer().getScoreboardManager().getMainScoreboard();
    private static boolean playerEnabled;
    private static boolean textMode;
    private static boolean useBelow;
    private static boolean belowUseProportion;
    private static int belowNameProportion;
    private static boolean belowUseRawAmountOfHearts;
    private static Objective belowObj;
    private static boolean useCustomBar;

    private PlayerBar() {
    }

    public static void setupBelow() {
        PlayerBar.removeBelowObj();
        if (playerEnabled && useBelow) {
            belowObj = sb.registerNewObjective("healthbarbelow", "dummy");
            belowObj.setDisplayName(Utils.replaceSymbols(instance.getConfig().getString(Configuration.Nodes.PLAYERS_BELOW_TEXT.getNode())));
            belowObj.setDisplaySlot(DisplaySlot.BELOW_NAME);
        }
    }

    public static void removeBelowObj() {
        if (sb.getObjective(DisplaySlot.BELOW_NAME) != null) {
            sb.getObjective(DisplaySlot.BELOW_NAME).unregister();
        }
        if (sb.getObjective("healthbarbelow") != null) {
            sb.getObjective("healthbarbelow").unregister();
        }
    }

    public static boolean hasHealthDisplayed(Player player) {
        Team team = sb.getPlayerTeam((OfflinePlayer)player);
        if (team == null) {
            return false;
        }
        return sb.getPlayerTeam((OfflinePlayer)player).getName().contains("hbr");
    }

    public static void hideHealthBar(Player player) {
        Team team = sb.getTeam("hbr0");
        if (team == null) {
            team = sb.registerNewTeam("hbr0");
            team.setCanSeeFriendlyInvisibles(false);
        }
        Player offPlayer = player;
        team.addPlayer((OfflinePlayer)offPlayer);
        instance.getServer().getPluginManager().callEvent((Event)new BarHideEvent((OfflinePlayer)offPlayer));
    }

    public static void updateHealthBelow(Player player) {
        if (useBelow && playerEnabled) {
            int score = 0;
            score = belowUseRawAmountOfHearts ? PlayerBar.getRawAmountOfHearts(player) : (belowUseProportion ? Utils.roundUpPositive(player.getHealth() * (double)belowNameProportion / player.getMaxHealth()) : Utils.roundUpPositive(player.getHealth()));
            belowObj.getScore((OfflinePlayer)player).setScore(score);
        }
    }

    public static void setHealthSuffix(Player player, double health, double max) {
        Player op = player;
        if (useCustomBar || !textMode) {
            int healthOn10 = Utils.roundUpPositiveWithMax(health * 10.0 / max, 10);
            sb.getTeam("hbr" + Integer.toString(healthOn10)).addPlayer((OfflinePlayer)op);
            return;
        }
        int intHealth = Utils.roundUpPositive(health);
        int intMax = Utils.roundUpPositive(max);
        String color = PlayerBar.getColor(health, max);
        Team team = sb.getTeam("hbr" + intHealth + "-" + intMax);
        if (team == null) {
            team = sb.registerNewTeam("hbr" + intHealth + "-" + intMax);
            team.setSuffix(" - " + color + intHealth + "\u00a77/\u00a7a" + intMax);
            team.setCanSeeFriendlyInvisibles(false);
        }
        team.addPlayer((OfflinePlayer)op);
    }

    public static String getColor(double health, double max) {
        double ratio = health / max;
        if (ratio > 0.5) {
            return "\u00a7a";
        }
        if (ratio > 0.25) {
            return "\u00a7e";
        }
        return "\u00a7c";
    }

    public static void loadConfiguration() {
        sb = instance.getServer().getScoreboardManager().getMainScoreboard();
        PlayerBarUtils.removeAllHealthbarTeams(sb);
        FileConfiguration config = instance.getConfig();
        playerEnabled = config.getBoolean(Configuration.Nodes.PLAYERS_ENABLE.getNode());
        textMode = config.getBoolean(Configuration.Nodes.PLAYERS_AFTER_TEXT_MODE.getNode());
        useCustomBar = config.getBoolean(Configuration.Nodes.PLAYERS_AFTER_USE_CUSTOM.getNode());
        useBelow = config.getBoolean(Configuration.Nodes.PLAYERS_BELOW_ENABLE.getNode());
        belowUseProportion = config.getBoolean(Configuration.Nodes.PLAYERS_BELOW_USE_PROPORTION.getNode());
        belowNameProportion = config.getInt(Configuration.Nodes.PLAYERS_BELOW_PROPORTIONAL_TO.getNode());
        belowUseRawAmountOfHearts = config.getBoolean(Configuration.Nodes.PLAYERS_BELOW_DISPLAY_RAW_HEARTS.getNode());
        PlayerBar.setupBelow();
        if (useCustomBar) {
            PlayerBarUtils.create10CustomTeams(sb, Utils.loadFile("custom-player-bar.yml", instance));
        } else if (!textMode) {
            PlayerBarUtils.create10DefaultTeams(sb, config.getInt(Configuration.Nodes.PLAYERS_AFTER_STYLE.getNode()));
        }
        PlayerBarUtils.setAllTeamsInvisibility(sb);
    }

    public static int getRawAmountOfHearts(Player player) {
        if (player.isHealthScaled()) {
            return Utils.round(player.getHealth() * 10.0 / player.getMaxHealth());
        }
        return Utils.round(player.getHealth() / 2.0);
    }
}

