/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.healthbar.utils;

import com.gmail.filoghost.healthbar.Main;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;

public class Utils {
    private Utils() {
    }

    public static String colorize(String input) {
        if (input == null) {
            return "";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)input);
    }

    public static String replaceSymbols(String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)input).replace("<3", "\u2764").replace("[x]", "\u2588").replace("[/]", "\u2588").replace("[*]", "\u2605").replace("[p]", "\u25cf").replace("[+]", "\u25c6").replace("[++]", "\u2726");
    }

    public static FileConfiguration loadFile(String path, Plugin plugin) {
        File file;
        if (!path.endsWith(".yml")) {
            path = String.valueOf(path) + ".yml";
        }
        if (!(file = new File(plugin.getDataFolder(), path)).exists()) {
            try {
                plugin.saveResource(path, false);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("-------------------------------------------------");
                System.out.println("[HealthBar] Cannot save " + path + " to disk!");
                System.out.println("-------------------------------------------------");
                return null;
            }
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        return config;
    }

    public static Map<String, String> getTranslationMap(Plugin plugin) {
        FileConfiguration config = Utils.loadFile("locale.yml", plugin);
        HashMap<String, String> localeMap = new HashMap<String, String>();
        EntityType[] entityTypeArray = EntityType.values();
        int n = entityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntityType entityType = entityTypeArray[n2];
            if (entityType.isAlive() && !entityType.equals((Object)EntityType.PLAYER)) {
                String name = entityType.toString();
                if (config.isSet(name)) {
                    localeMap.put(name, config.getString(name));
                } else {
                    config.set(name, (Object)WordUtils.capitalizeFully((String)name.replace("_", " ")));
                    localeMap.put(name, WordUtils.capitalizeFully((String)name.replace("_", " ")));
                }
            }
            ++n2;
        }
        try {
            config.save(new File(plugin.getDataFolder(), "locale.yml"));
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("-------------------------------------------------");
            System.out.println("[HealthBar] Cannot save locale.yml to disk!");
            System.out.println("-------------------------------------------------");
        }
        return localeMap;
    }

    public static List<EntityType> getTypesFromString(String input) {
        String[] split;
        ArrayList<EntityType> list = new ArrayList<EntityType>();
        if (input == null || input.length() == 0) {
            return list;
        }
        String[] stringArray = split = input.split(",");
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            EntityType type = Utils.getTypeFromString(s);
            if (type == null) {
                Main.logger.warning("Cannot find entity type: '" + s + "'. Valid types are listed in locale.yml (The uppercase names, with the underscore)");
            } else {
                list.add(type);
            }
            ++n2;
        }
        return list;
    }

    public static int round(double d) {
        double remainder = d - (double)((int)d);
        if (remainder <= 0.5) {
            return (int)d;
        }
        return (int)d + 1;
    }

    public static int roundUpPositive(double d) {
        int i = (int)d;
        double remainder = d - (double)i;
        if (remainder > 0.0) {
            ++i;
        }
        if (i < 0) {
            return 0;
        }
        return i;
    }

    public static int roundUpPositiveWithMax(double d, int max) {
        int result = Utils.roundUpPositive(d);
        if (d > (double)max) {
            return max;
        }
        return result;
    }

    public static EntityType getTypeFromString(String s) {
        EntityType[] entityTypeArray = EntityType.values();
        int n = entityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntityType type = entityTypeArray[n2];
            if (s.replace(" ", "").replace("_", "").equalsIgnoreCase(type.toString().replace("_", ""))) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public static String getBukkitBuild() {
        String version = Bukkit.getVersion();
        Pattern pattern = Pattern.compile("(b)([0-9]+)(jnks)");
        Matcher matcher = pattern.matcher(version);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return null;
    }
}

