/*
 * Decompiled with CFR 0.152.
 */
package com.rocknatalino.plugin;

import com.rocknatalino.plugin.Commands;
import com.rocknatalino.plugin.TabComplete;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;

public class Main
extends JavaPlugin
implements Listener {
    Scoreboard board;
    Objective objective;

    public void onEnable() {
        this.saveDefaultConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("HealthBar").setExecutor((CommandExecutor)new Commands(this));
        this.getCommand("HealthBar").setTabCompleter((TabCompleter)new TabComplete());
        this.createHealthBar();
        Bukkit.getConsoleSender().sendMessage("\u00a7a[HealthBar] Enabled");
    }

    public void onDisable() {
        this.saveConfig();
        this.objective.unregister();
        Bukkit.getConsoleSender().sendMessage("\u00a7e[HealthBar] Configuration file saved.");
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        if (this.getConfig().getBoolean("require-permission")) {
            if (e.getPlayer().hasPermission("healthbar.see")) {
                e.getPlayer().setScoreboard(this.board);
            }
        } else {
            e.getPlayer().setScoreboard(this.board);
        }
    }

    public void createHealthBar() {
        this.reloadConfig();
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        assert (manager != null);
        this.board = manager.getNewScoreboard();
        String displayName = this.getConfig().getString("displayName").replaceAll("&", "\u00a7");
        this.objective = this.board.registerNewObjective("HealthBar", "health");
        this.objective.setDisplayName(displayName);
        if (this.getConfig().getBoolean("players")) {
            this.objective.setDisplaySlot(DisplaySlot.BELOW_NAME);
        } else {
            this.board.clearSlot(DisplaySlot.BELOW_NAME);
            Bukkit.getConsoleSender().sendMessage("\u00a7eHealthBar is disabled in config.yml");
        }
        Bukkit.getOnlinePlayers().forEach(player -> {
            if (this.getConfig().getBoolean("require-permission")) {
                if (player.hasPermission("healthbar.see")) {
                    player.setScoreboard(this.board);
                }
            } else {
                player.setScoreboard(this.board);
            }
        });
    }
}

