/*
 * Decompiled with CFR 0.152.
 */
package snownee.companion;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import snownee.companion.CompanionCommonConfig;
import snownee.companion.mixin.EntityAccessor;
import snownee.companion.mixin.ItemTagsAccessor;

public class Hooks {
    public static boolean traveling;
    public static final Tag.Named<Item> RANGED_WEAPON;
    public static final Tag.Named<Item> CHARGED_RANGED_WEAPON;

    public static void changeDimension(ServerPlayer player, ServerLevel to, ServerLevel from, boolean returnFromEnd) {
        if (player.m_5833_() || player.m_21224_()) {
            return;
        }
        if (returnFromEnd ? player.f_19853_ != from : player.f_19853_ != to) {
            return;
        }
        boolean nether = from.m_46472_() == Level.f_46429_ || to.m_46472_() == Level.f_46429_;
        BlockPos portalPos = null;
        if (nether && (portalPos = ((EntityAccessor)player).getPortalEntrancePos()) == null) {
            return;
        }
        for (LivingEntity entity : Hooks.getAllPets(from, player)) {
            if (nether) {
                ((EntityAccessor)entity).setPortalCooldown(0);
                ((EntityAccessor)entity).callHandleInsidePortal(portalPos);
            }
            entity.m_20091_();
            entity = (LivingEntity)entity.m_5489_(to);
        }
    }

    public static List<LivingEntity> getAllPets(ServerLevel level, ServerPlayer player) {
        int max = CompanionCommonConfig.portalMaxTeleportedPets;
        if (max == -1) {
            max = level.m_46469_().m_46215_(GameRules.f_46149_);
        }
        traveling = true;
        ArrayList entities = Lists.newArrayList();
        for (Entity entity : level.m_8583_()) {
            TamableAnimal tamable;
            Mob mob;
            if (entities.size() >= max) break;
            if (entity.m_20159_() || !entity.m_6072_()) continue;
            if (entity instanceof Mob && (mob = (Mob)entity).m_21523_()) {
                if (mob.m_21524_() != player) continue;
                entities.add(mob);
                continue;
            }
            if (!(entity instanceof TamableAnimal) || (tamable = (TamableAnimal)entity).m_21827_() || !Objects.equals(player.m_142081_(), tamable.m_142504_())) continue;
            entities.add(tamable);
        }
        traveling = false;
        return entities;
    }

    public static boolean teleportWithRandomOffset(LivingEntity entity, BlockPos blockPos) {
        Random random = entity.m_21187_();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 10; ++i) {
            int j = Hooks.randomIntInclusive(random, -2, 2);
            int k = Hooks.randomIntInclusive(random, -1, 1);
            int l = Hooks.randomIntInclusive(random, -2, 2);
            pos.m_122178_(blockPos.m_123341_() + j, blockPos.m_123342_() + k, blockPos.m_123343_() + l);
            if (!Hooks.canTeleportTo((Entity)entity, (BlockPos)pos)) continue;
            entity.m_6021_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            return true;
        }
        return false;
    }

    private static int randomIntInclusive(Random random, int i, int j) {
        return random.nextInt(j - i + 1) + i;
    }

    private static boolean canTeleportTo(Entity entity, BlockPos blockPos) {
        BlockPathTypes blockPathTypes = WalkNodeEvaluator.m_77604_((BlockGetter)entity.f_19853_, (BlockPos.MutableBlockPos)blockPos.m_122032_());
        if (blockPathTypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockPos blockPos2 = blockPos.m_141950_((Vec3i)entity.m_142538_());
        return entity.f_19853_.m_45756_(entity, entity.m_142469_().m_82338_(blockPos2));
    }

    public static boolean wantsToAttack(TamableAnimal pet, LivingEntity enemy, LivingEntity owner) {
        return Hooks.wantsToAttack0(pet, enemy) && pet.m_7757_(enemy, owner);
    }

    public static boolean wantsToAttack0(TamableAnimal pet, LivingEntity enemy) {
        if (CompanionCommonConfig.petWontAttackWhenInjured && Hooks.isInjured((LivingEntity)pet)) {
            return !(enemy instanceof Enemy) && !(enemy instanceof IronGolem);
        }
        return true;
    }

    public static boolean isInjured(LivingEntity entity) {
        return entity.m_21223_() / entity.m_21233_() <= CompanionCommonConfig.petInjuredStatusHealthRatio;
    }

    public static void handleChunkPreUnload(List<EntityAccess> entities) {
        for (EntityAccess entity : entities) {
            BlockPos pos;
            TamableAnimal pet;
            if (!(entity instanceof TamableAnimal) || !Hooks.shouldFollowOwner(pet = (TamableAnimal)entity) || Hooks.teleportWithRandomOffset((LivingEntity)pet, pos = pet.m_142480_().m_142538_())) continue;
            pet.m_20984_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), false);
        }
    }

    public static boolean shouldFollowOwner(TamableAnimal pet) {
        if (pet.m_21523_() || pet.m_21827_() || pet.m_20159_()) {
            return false;
        }
        LivingEntity owner = pet.m_142480_();
        return owner != null && !owner.m_21224_() && !owner.m_5833_();
    }

    public static boolean isHoldingRangedWeapon(ServerPlayer player) {
        ItemStack stack;
        UseAnim anim;
        if (player.m_21093_($ -> $.m_150922_(RANGED_WEAPON))) {
            ItemStack stack2;
            ItemStack main = player.m_21205_();
            ItemStack off = player.m_21206_();
            ItemStack itemStack = stack2 = main.m_150922_(RANGED_WEAPON) ? main : off;
            if (stack2.m_41720_() instanceof CrossbowItem) {
                if (CrossbowItem.m_40932_((ItemStack)stack2)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return player.m_6117_() && player.m_21212_() > 0 && player.m_21093_($ -> $.m_150922_(CHARGED_RANGED_WEAPON)) && ((anim = (stack = player.m_21211_()).m_41780_()) == UseAnim.BOW || anim == UseAnim.CROSSBOW || anim == UseAnim.SPEAR);
    }

    static {
        RANGED_WEAPON = ItemTagsAccessor.callBind("companion:ranged_weapon");
        CHARGED_RANGED_WEAPON = ItemTagsAccessor.callBind("companion:charged_ranged_weapon");
    }
}

