/*
 * Decompiled with CFR 0.152.
 */
package snownee.companion.mixin;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.companion.CompanionCommonConfig;
import snownee.companion.CompanionPlayer;
import snownee.companion.Hooks;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Inject(at={@At(value="HEAD")}, method={"checkFallDamage"})
    private void companion_checkFallDamage(double d, boolean bl, BlockState blockState, BlockPos blockPos, CallbackInfo ci) {
        Entity entity = (Entity)this;
        if (bl && !entity.f_19853_.f_46443_ && entity.f_19789_ > 0.0f && entity instanceof Player) {
            CompanionPlayer player = (CompanionPlayer)((Object)this);
            Vec3 past = player.getJumpPos();
            if (past == null) {
                return;
            }
            Vec3 now = entity.m_20182_();
            player.setJumpPos(null);
            if (Mth.m_14082_((double)past.f_82479_, (double)now.f_82479_) && Mth.m_14082_((double)past.f_82480_, (double)now.f_82480_) && Mth.m_14082_((double)past.f_82481_, (double)now.f_82481_)) {
                player.removeShoulderEntities();
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canChangeDimensions"}, cancellable=true)
    private void companion_canChangeDimensions(CallbackInfoReturnable<Boolean> ci) {
        UUID ownerUUID;
        if (Hooks.traveling) {
            return;
        }
        float r = CompanionCommonConfig.petWontChangeDimensionUnlessOwnerIsNearbyRadius;
        if (r < 0.0f) {
            return;
        }
        Entity entity = (Entity)this;
        if (entity instanceof OwnableEntity) {
            ownerUUID = ((OwnableEntity)entity).m_142504_();
        } else if (entity instanceof AbstractHorse) {
            ownerUUID = ((AbstractHorse)entity).m_30615_();
        } else {
            return;
        }
        if (ownerUUID == null) {
            return;
        }
        Player owner = entity.f_19853_.m_46003_(ownerUUID);
        if (owner == null || owner.m_20280_(entity) > (double)(r * r)) {
            ci.setReturnValue((Object)false);
        }
    }
}

