/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.client.model;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.BlockModelConfiguration;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.StringUtils;
import snownee.kiwi.block.def.BlockDefinition;
import snownee.kiwi.block.entity.RetextureBlockEntity;
import snownee.kiwi.util.NBTHelper;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class RetextureModel
implements IDynamicBakedModel {
    public static ModelProperty<Map<String, BlockDefinition>> TEXTURES = new ModelProperty();
    private final ModelBakery modelLoader;
    private final ModelState variant;
    private final ResourceLocation loaderId;
    private ItemOverrides overrideList;
    private final Cache<String, BakedModel> baked = CacheBuilder.newBuilder().expireAfterAccess(500L, TimeUnit.SECONDS).build();
    private final BlockModelConfiguration baseConfiguration;
    private final String particleKey;

    public RetextureModel(ModelBakery modelLoader, ModelState variant, ResourceLocation loaderId, BlockModelConfiguration baseConfiguration, String particleKey, boolean inventory) {
        this.modelLoader = modelLoader;
        this.variant = variant;
        this.loaderId = loaderId;
        this.baseConfiguration = baseConfiguration;
        this.overrideList = inventory ? new Overrides(this) : ItemOverrides.f_111734_;
        this.particleKey = particleKey;
    }

    public boolean m_7541_() {
        return this.baseConfiguration.useSmoothLighting();
    }

    public boolean m_7539_() {
        return this.baseConfiguration.isShadedInGui();
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon(IModelData data) {
        BlockDefinition supplier;
        if (data.getData(TEXTURES) != null && (supplier = (BlockDefinition)((Map)data.getData(TEXTURES)).get(this.particleKey)) != null) {
            Material material = supplier.renderMaterial(null);
            TextureAtlasSprite particle = (TextureAtlasSprite)ForgeModelBakery.defaultTextureGetter().apply(material);
            if (particle.getClass() != MissingTextureAtlasSprite.class) {
                return particle;
            }
        }
        return this.m_6160_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.modelLoader.getSpriteMap().m_117971_(this.baseConfiguration.resolveTexture("particle"));
    }

    public ItemOverrides m_7343_() {
        return this.overrideList;
    }

    public ItemTransforms m_7442_() {
        return this.baseConfiguration.getCameraTransforms();
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData extraData) {
        Map overrides = (Map)extraData.getData(TEXTURES);
        if (overrides == null) {
            overrides = Collections.EMPTY_MAP;
        }
        RenderType layer = MinecraftForgeClient.getRenderType();
        boolean noSupplier = true;
        if (layer != null) {
            for (BlockDefinition supplier : overrides.values()) {
                if (supplier == null) continue;
                noSupplier = false;
                if (!supplier.canRenderInLayer(layer)) continue;
                BakedModel model = this.getModel(overrides);
                return model.getQuads(state, side, rand, extraData);
            }
        }
        if (layer == null || noSupplier && layer == RenderType.m_110451_()) {
            BakedModel model = this.getModel(overrides);
            return model.getQuads(state, side, rand, extraData);
        }
        return Collections.EMPTY_LIST;
    }

    public BakedModel getModel(Map<String, BlockDefinition> overrides) {
        String key = RetextureModel.generateKey(overrides);
        try {
            return (BakedModel)this.baked.get((Object)key, () -> {
                ModelConfiguration configuration = new ModelConfiguration((IModelConfiguration)this.baseConfiguration, overrides);
                return this.baseConfiguration.getCustomGeometry().bake((IModelConfiguration)configuration, this.modelLoader, ForgeModelBakery.defaultTextureGetter(), this.variant, this.overrideList, this.loaderId);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return Minecraft.m_91087_().m_91304_().m_119409_();
        }
    }

    private static String generateKey(Map<String, BlockDefinition> overrides) {
        if (overrides == null) {
            return "";
        }
        return StringUtils.join(overrides.entrySet(), (char)',');
    }

    public boolean m_7547_() {
        return this.baseConfiguration.isSideLit();
    }

    public static int getColor(Map<String, BlockDefinition> textures, BlockState state, BlockAndTintGetter level, BlockPos pos, int index) {
        BlockDefinition supplier = textures.get(Integer.toString(index));
        if (supplier != null) {
            return supplier.getColor(state, level, pos, index);
        }
        return -1;
    }

    public static class Overrides
    extends ItemOverrides {
        private final RetextureModel baked;
        private final Cache<ItemStack, BakedModel> cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(300L, TimeUnit.SECONDS).weakKeys().build();

        public Overrides(RetextureModel model) {
            this.baked = model;
        }

        public BakedModel m_173464_(BakedModel model, ItemStack stack, ClientLevel worldIn, LivingEntity entityIn, int seed) {
            if (model instanceof RetextureModel) {
                try {
                    model = (BakedModel)this.cache.get((Object)stack, () -> this.baked.getModel(Overrides.overridesFromItem(stack)));
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            return model;
        }

        public static Map<String, BlockDefinition> overridesFromItem(ItemStack stack) {
            CompoundTag data = NBTHelper.of(stack).getTag("BlockEntityTag.Overrides");
            if (data == null) {
                data = new CompoundTag();
            }
            Set keySet = data.m_128431_();
            HashMap overrides = Maps.newHashMapWithExpectedSize((int)keySet.size());
            keySet.forEach(k -> overrides.put(k, null));
            RetextureBlockEntity.readTextures(overrides, data, (Predicate<BlockDefinition>)Predicates.alwaysTrue());
            return overrides;
        }

        public ImmutableList<ItemOverrides.BakedOverride> getOverrides() {
            return ImmutableList.of();
        }
    }

    public static class ModelConfiguration
    implements IModelConfiguration {
        private final IModelConfiguration baseConfiguration;
        private final Map<String, BlockDefinition> overrides;

        public ModelConfiguration(IModelConfiguration baseConfiguration, Map<String, BlockDefinition> overrides) {
            this.baseConfiguration = baseConfiguration;
            this.overrides = overrides;
        }

        public UnbakedModel getOwnerModel() {
            return this.baseConfiguration.getOwnerModel();
        }

        public String getModelName() {
            return this.baseConfiguration.getModelName();
        }

        public boolean isTexturePresent(String name) {
            return this.baseConfiguration.isTexturePresent(name);
        }

        public Material resolveTexture(String name) {
            if (name.charAt(0) == '#') {
                String ref0;
                BlockDefinition supplier;
                String ref = name.substring(1);
                int i = ref.lastIndexOf(95);
                if (i != -1 && (supplier = this.overrides.get(ref0 = ref.substring(0, i))) != null) {
                    Direction direction = Direction.m_122402_((String)ref.substring(i + 1));
                    return supplier.renderMaterial(direction);
                }
                BlockDefinition supplier2 = this.overrides.get(ref);
                if (supplier2 != null) {
                    return supplier2.renderMaterial(null);
                }
            }
            return this.baseConfiguration.resolveTexture(name);
        }

        public boolean isShadedInGui() {
            return this.baseConfiguration.isShadedInGui();
        }

        public boolean isSideLit() {
            return this.baseConfiguration.isSideLit();
        }

        public boolean useSmoothLighting() {
            return this.baseConfiguration.useSmoothLighting();
        }

        public ItemTransforms getCameraTransforms() {
            return this.baseConfiguration.getCameraTransforms();
        }

        public ModelState getCombinedTransform() {
            return this.baseConfiguration.getCombinedTransform();
        }
    }

    public static class Loader
    implements IModelLoader<Geometry> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public void m_6213_(ResourceManager resourceManager) {
        }

        public Geometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            ResourceLocation loaderId = new ResourceLocation(GsonHelper.m_13851_((JsonObject)modelContents, (String)"base_loader", (String)"elements"));
            Lazy blockModel = Lazy.of(() -> (BlockModel)ForgeModelBakery.instance().m_119341_(new ResourceLocation(GsonHelper.m_13906_((JsonObject)modelContents, (String)"base"))));
            return new Geometry((Lazy<BlockModel>)blockModel, loaderId, GsonHelper.m_13851_((JsonObject)modelContents, (String)"particle", (String)"0"), GsonHelper.m_13855_((JsonObject)modelContents, (String)"inventory", (boolean)true));
        }
    }

    public static class Geometry
    implements IModelGeometry<Geometry> {
        private final ResourceLocation loaderId;
        private final Lazy<BlockModel> blockModel;
        private final String particle;
        private final boolean inventory;

        public Geometry(Lazy<BlockModel> blockModel, ResourceLocation loaderId, String particle, boolean inventory) {
            this.blockModel = blockModel;
            this.loaderId = loaderId;
            this.particle = particle;
            this.inventory = inventory;
        }

        public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            return new RetextureModel(bakery, modelTransform, this.loaderId, ((BlockModel)this.blockModel.get()).customData, this.particle, this.inventory);
        }

        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return ((BlockModel)this.blockModel.get()).m_5500_(modelGetter, missingTextureErrors);
        }
    }
}

