/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import snownee.kiwi.Kiwi;
import snownee.kiwi.config.ConfigHandler;
import snownee.kiwi.config.KiwiConfig;

public class KiwiConfigManager {
    private static final List<ConfigHandler> allConfigs = Lists.newLinkedList();
    private static final Map<Class<?>, ConfigHandler> clazz2Configs = Maps.newHashMap();
    public static final Map<ResourceLocation, ForgeConfigSpec.BooleanValue> modules = Maps.newHashMap();

    public static synchronized void register(ConfigHandler configHandler) {
        allConfigs.add(configHandler);
        if (configHandler.getClass() != null) {
            clazz2Configs.put(configHandler.getClazz(), configHandler);
        }
    }

    public static void init() {
        Collections.sort(allConfigs, (a, b) -> a.getFileName().compareTo(b.getFileName()));
        HashSet settledMods = Sets.newHashSet();
        for (ConfigHandler config : allConfigs) {
            if (!config.isMaster()) continue;
            settledMods.add(config.getModId());
        }
        for (ConfigHandler config : allConfigs) {
            if (!config.isMaster() && config.getType() == KiwiConfig.ConfigType.COMMON && !settledMods.contains(config.getModId())) {
                settledMods.add(config.getModId());
                config.setMaster(true);
            }
            config.init();
        }
        for (ResourceLocation rl : Kiwi.defaultOptions.keySet()) {
            if (settledMods.contains(rl.m_135827_())) continue;
            settledMods.add(rl.m_135827_());
            ConfigHandler configHandler = new ConfigHandler(rl.m_135827_(), rl.m_135827_() + "-modules", KiwiConfig.ConfigType.COMMON, null, true);
            configHandler.init();
        }
    }

    public static void preload() throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        for (ConfigHandler configHandler : allConfigs) {
            if (!configHandler.isMaster()) continue;
            configHandler.forceLoad();
        }
    }

    public static void defineModules(String modId, ForgeConfigSpec.Builder builder) {
        builder.push("modules");
        for (Map.Entry<ResourceLocation, Boolean> entry : Kiwi.defaultOptions.entrySet()) {
            ResourceLocation rl = entry.getKey();
            if (!rl.m_135827_().equals(modId)) continue;
            modules.put(rl, builder.worldRestart().define(rl.m_135815_(), entry.getValue().booleanValue()));
        }
        builder.pop();
    }

    public static void refresh() {
        allConfigs.forEach(ConfigHandler::refresh);
    }

    public static ConfigHandler getHandler(Class<?> clazz) {
        return clazz2Configs.get(clazz);
    }
}

