/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.network;

import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;
import snownee.kiwi.network.IPacketHandler;
import snownee.kiwi.network.KiwiPacket;
import snownee.kiwi.network.Networking;

public abstract class PacketHandler
implements IPacketHandler {
    public ResourceLocation id;
    private KiwiPacket.Direction direction;

    void setModId(String modId) {
        KiwiPacket annotation = this.getClass().getDeclaredAnnotation(KiwiPacket.class);
        String v = annotation.value();
        this.id = v.contains(":") ? new ResourceLocation(v) : new ResourceLocation(modId, v);
        this.direction = annotation.dir();
    }

    @Override
    public KiwiPacket.Direction getDirection() {
        return this.direction;
    }

    public void send(PacketDistributor.PacketTarget target, Consumer<FriendlyByteBuf> buf) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer()).m_130085_(this.id);
        buf.accept(buffer);
        Networking.send(target, buffer);
    }

    public void send(ServerPlayer player, Consumer<FriendlyByteBuf> buf) {
        this.send(PacketDistributor.PLAYER.with(() -> player), buf);
    }

    public void sendAllExcept(ServerPlayer player, Consumer<FriendlyByteBuf> buf) {
        this.send(Networking.ALL_EXCEPT.with(() -> player), buf);
    }

    public void sendToServer(Consumer<FriendlyByteBuf> buf) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer()).m_130085_(this.id);
        buf.accept(buffer);
        Networking.sendToServer(buffer);
    }
}

