/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.recipe.crafting;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import snownee.kiwi.block.def.BlockDefinition;
import snownee.kiwi.block.entity.RetextureBlockEntity;
import snownee.kiwi.data.DataModule;
import snownee.kiwi.recipe.FullBlockIngredient;
import snownee.kiwi.recipe.crafting.DynamicShapedRecipe;

public class RetextureRecipe
extends DynamicShapedRecipe {
    private Char2ObjectMap<String[]> textureKeys;

    public RetextureRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    @Override
    public boolean matches(CraftingContainer inv, int x, int y, int rx, int ry) {
        ItemStack stack = inv.m_8020_(x + y * inv.m_39347_());
        return (this.getEmpty().test(stack) || FullBlockIngredient.isTextureBlock(stack)) && super.matches(inv, x, y, rx, ry);
    }

    @Override
    public ItemStack assemble(CraftingContainer inv) {
        int[] pos = this.search(inv);
        if (pos == null) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = this.recipeOutput.m_41777_();
        HashMap map = Maps.newHashMap();
        for (Char2ObjectMap.Entry e : this.textureKeys.char2ObjectEntrySet()) {
            ItemStack item = this.item(e.getCharKey(), inv, pos);
            BlockDefinition def = BlockDefinition.fromItem(item, null);
            for (String k : (String[])e.getValue()) {
                map.put(k, def);
            }
        }
        RetextureBlockEntity.writeTextures(map, stack.m_41698_("BlockEntityTag"));
        return stack;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return DataModule.RETEXTURE;
    }

    public static class Serializer
    extends DynamicShapedRecipe.Serializer<RetextureRecipe> {
        public RetextureRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            RetextureRecipe recipe = new RetextureRecipe(pRecipeId);
            Serializer.fromJson(recipe, pSerializedRecipe);
            JsonObject o = pSerializedRecipe.getAsJsonObject("texture");
            recipe.textureKeys = new Char2ObjectArrayMap(o.size());
            for (Map.Entry e : o.entrySet()) {
                JsonArray jsonArray = ((JsonElement)e.getValue()).getAsJsonArray();
                String[] keys = new String[jsonArray.size()];
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = jsonArray.get(i).getAsString();
                }
                recipe.textureKeys.put(((String)e.getKey()).charAt(0), (Object)keys);
            }
            return recipe;
        }

        public RetextureRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            RetextureRecipe recipe = new RetextureRecipe(pRecipeId);
            Serializer.fromNetwork(recipe, pBuffer);
            int size = pBuffer.m_130242_();
            recipe.textureKeys = new Char2ObjectArrayMap(size);
            for (int i = 0; i < size; ++i) {
                char ch = pBuffer.readChar();
                int size2 = pBuffer.m_130242_();
                String[] arr = new String[size2];
                for (int j = 0; j < size2; ++j) {
                    arr[j] = pBuffer.m_130136_(16);
                }
                recipe.textureKeys.put(ch, (Object)arr);
            }
            return recipe;
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer, RetextureRecipe recipe) {
            super.toNetwork(buffer, recipe);
            buffer.m_130130_(recipe.textureKeys.size());
            for (Char2ObjectMap.Entry e : recipe.textureKeys.char2ObjectEntrySet()) {
                buffer.writeChar((int)e.getCharKey());
                buffer.m_130130_(((String[])e.getValue()).length);
                for (String s : (String[])e.getValue()) {
                    buffer.m_130072_(s, 16);
                }
            }
        }
    }
}

