/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public final class PlayerUtil {
    private PlayerUtil() {
    }

    @Nullable
    public static BlockPos tryPlace(Level world, BlockPos pos, Direction side, @Nullable Player player, InteractionHand hand, BlockState state, @Nullable ItemStack stack, boolean playSound, boolean skipCollisionCheck) {
        CollisionContext iselectioncontext;
        BlockState worldState = world.m_8055_(pos);
        if (!(worldState.m_60734_() == Blocks.f_50125_ && worldState.m_61138_((Property)SnowLayerBlock.f_56581_) && (Integer)worldState.m_61143_((Property)SnowLayerBlock.f_56581_) < 8 || state.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(world, pos, side.m_122424_(), stack == null ? ItemStack.f_41583_ : stack, side.m_122424_())))) {
            pos = pos.m_142300_(side);
        }
        if (skipCollisionCheck) {
            return PlayerUtil.tryPlace(world, pos, side.m_122424_(), player, hand, state, stack, playSound) ? pos : null;
        }
        CollisionContext collisionContext = iselectioncontext = player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player);
        if (world.m_45752_(state, pos, iselectioncontext)) {
            return PlayerUtil.tryPlace(world, pos, side.m_122424_(), player, hand, state, stack, playSound) ? pos : null;
        }
        return null;
    }

    public static boolean tryPlace(Level world, BlockPos pos, Direction direction, @Nullable Player player, InteractionHand hand, BlockState state, @Nullable ItemStack stack, boolean playSound) {
        if (!world.m_7966_(player, pos)) {
            return false;
        }
        if (player != null && !player.m_36204_(pos, direction, stack)) {
            return false;
        }
        BlockSnapshot blocksnapshot = BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)pos);
        if (!world.m_46597_(pos, state)) {
            return false;
        }
        if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blocksnapshot, (Direction)direction)) {
            blocksnapshot.restore(true, false);
            return false;
        }
        world.m_7731_(pos, state, 11);
        BlockState actualState = world.m_8055_(pos);
        if (stack != null) {
            BlockItem.m_40582_((Level)world, (Player)player, (BlockPos)pos, (ItemStack)stack);
            if (player != null) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, pos, stack);
                }
                actualState.m_60734_().m_6402_(world, pos, state, (LivingEntity)player, stack);
            }
            if (player == null || !player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
        }
        if (playSound) {
            SoundType soundtype = actualState.m_60734_().getSoundType(actualState, (LevelReader)world, pos, (Entity)player);
            world.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        }
        return true;
    }
}

