/*
 * Decompiled with CFR 0.152.
 */
package snownee.companion;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_14;
import net.minecraft.class_1439;
import net.minecraft.class_1496;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3494;
import net.minecraft.class_5568;
import net.minecraft.class_6025;
import net.minecraft.class_7;
import snownee.companion.CompanionCommonConfig;
import snownee.companion.mixin.EntityAccessor;
import snownee.companion.mixin.ItemTagsAccessor;

public class Hooks {
    public static boolean traveling;
    public static final class_3494.class_5123<class_1792> RANGED_WEAPON;
    public static final class_3494.class_5123<class_1792> CHARGED_RANGED_WEAPON;

    public static void changeDimension(class_3222 player, class_3218 to, class_3218 from, boolean returnFromEnd) {
        if (player.method_7325() || player.method_29504()) {
            return;
        }
        if (returnFromEnd ? player.field_6002 != from : player.field_6002 != to) {
            return;
        }
        boolean nether = from.method_27983() == class_1937.field_25180 || to.method_27983() == class_1937.field_25180;
        class_2338 portalPos = null;
        if (nether && (portalPos = ((EntityAccessor)player).getPortalEntrancePos()) == null) {
            return;
        }
        for (class_1309 entity : Hooks.getAllPets(from, player)) {
            if (nether) {
                ((EntityAccessor)entity).setPortalCooldown(0);
                ((EntityAccessor)entity).callHandleInsidePortal(portalPos);
            }
            entity.method_30229();
            entity = (class_1309)entity.method_5731(to);
        }
    }

    public static List<class_1309> getAllPets(class_3218 level, class_3222 player) {
        int max = CompanionCommonConfig.portalMaxTeleportedPets;
        if (max == -1) {
            max = level.method_8450().method_8356(class_1928.field_19405);
        }
        traveling = true;
        ArrayList entities = Lists.newArrayList();
        for (class_1297 entity : level.method_27909()) {
            class_1321 tamable;
            class_1308 mob;
            if (entities.size() >= max) break;
            if (entity.method_5765() || !entity.method_5822()) continue;
            if (entity instanceof class_1308 && (mob = (class_1308)entity).method_5934()) {
                if (mob.method_5933() != player) continue;
                entities.add(mob);
                continue;
            }
            if (!(entity instanceof class_1321) || (tamable = (class_1321)entity).method_24345() || !Objects.equals(player.method_5667(), tamable.method_6139())) continue;
            entities.add(tamable);
        }
        traveling = false;
        return entities;
    }

    public static boolean teleportWithRandomOffset(class_1309 entity, class_2338 blockPos) {
        Random random = entity.method_6051();
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int i = 0; i < 10; ++i) {
            int j = Hooks.randomIntInclusive(random, -2, 2);
            int k = Hooks.randomIntInclusive(random, -1, 1);
            int l = Hooks.randomIntInclusive(random, -2, 2);
            pos.method_10103(blockPos.method_10263() + j, blockPos.method_10264() + k, blockPos.method_10260() + l);
            if (!Hooks.canTeleportTo((class_1297)entity, (class_2338)pos)) continue;
            entity.method_5859((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5);
            return true;
        }
        return false;
    }

    private static int randomIntInclusive(Random random, int i, int j) {
        return random.nextInt(j - i + 1) + i;
    }

    private static boolean canTeleportTo(class_1297 entity, class_2338 blockPos) {
        class_7 blockPathTypes = class_14.method_23476((class_1922)entity.field_6002, (class_2338.class_2339)blockPos.method_25503());
        if (blockPathTypes != class_7.field_12) {
            return false;
        }
        class_2338 blockPos2 = blockPos.method_10059((class_2382)entity.method_24515());
        return entity.field_6002.method_8587(entity, entity.method_5829().method_996(blockPos2));
    }

    public static boolean wantsToAttack(class_1321 pet, class_1309 enemy, class_1309 owner) {
        return Hooks.wantsToAttack0(pet, enemy) && pet.method_6178(enemy, owner);
    }

    public static boolean wantsToAttack0(class_1321 pet, class_1309 enemy) {
        if (CompanionCommonConfig.petWontAttackWhenInjured && Hooks.isInjured((class_1309)pet)) {
            return !(enemy instanceof class_1569) && !(enemy instanceof class_1439);
        }
        return true;
    }

    public static boolean isInjured(class_1309 entity) {
        return entity.method_6032() / entity.method_6063() <= CompanionCommonConfig.petInjuredStatusHealthRatio;
    }

    public static void handleChunkPreUnload(List<class_5568> entities) {
        for (class_5568 entity : entities) {
            class_2338 pos;
            class_1321 pet;
            if (!(entity instanceof class_1321) || !Hooks.shouldFollowOwner(pet = (class_1321)entity) || Hooks.teleportWithRandomOffset((class_1309)pet, pos = pet.method_6177().method_24515())) continue;
            pet.method_6082((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), false);
        }
    }

    public static boolean shouldFollowOwner(class_1321 pet) {
        if (pet.method_5934() || pet.method_24345() || pet.method_5765()) {
            return false;
        }
        class_1309 owner = pet.method_6177();
        return owner != null && !owner.method_29504() && !owner.method_7325();
    }

    public static boolean isHoldingRangedWeapon(class_3222 player) {
        class_1799 stack;
        class_1839 anim;
        if (player.method_24520($ -> $.method_31573(RANGED_WEAPON))) {
            class_1799 stack2;
            class_1799 main = player.method_6047();
            class_1799 off = player.method_6079();
            class_1799 class_17992 = stack2 = main.method_31573(RANGED_WEAPON) ? main : off;
            if (stack2.method_7909() instanceof class_1764) {
                if (class_1764.method_7781((class_1799)stack2)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return player.method_6115() && player.method_6014() > 0 && player.method_24520($ -> $.method_31573(CHARGED_RANGED_WEAPON)) && ((anim = (stack = player.method_6030()).method_7976()) == class_1839.field_8953 || anim == class_1839.field_8947 || anim == class_1839.field_8951);
    }

    public static class_1657 getEntityOwner(class_1297 entity) {
        UUID ownerUUID = null;
        if (entity instanceof class_6025) {
            ownerUUID = ((class_6025)entity).method_6139();
        } else if (entity instanceof class_1496) {
            ownerUUID = ((class_1496)entity).method_6768();
        }
        if (ownerUUID == null) {
            return null;
        }
        return entity.field_6002.method_18470(ownerUUID);
    }

    public static boolean hasOwner(class_1297 entity) {
        if (entity instanceof class_6025) {
            return ((class_6025)entity).method_6139() != null;
        }
        if (entity instanceof class_1496) {
            return ((class_1496)entity).method_6768() != null;
        }
        return false;
    }

    static {
        RANGED_WEAPON = ItemTagsAccessor.callBind("companion:ranged_weapon");
        CHARGED_RANGED_WEAPON = ItemTagsAccessor.callBind("companion:charged_ranged_weapon");
    }
}

