/*
 * Decompiled with CFR 0.152.
 */
package multiteam.gardenarsenal.forge;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import multiteam.gardenarsenal.forge.ForgeRecipeSerializer;
import multiteam.gardenarsenal.forge.GardenArsenalForge;
import multiteam.gardenarsenal.registries.GardenArsenalTrades;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.fml.loading.FMLPaths;

public class GardenArsenalExpectPlatformImpl {
    public static File getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get().toFile();
    }

    public static VillagerProfession createProfession(String nameIn, PointOfInterestType pointOfInterestIn, ImmutableSet<Item> specificItemsIn, ImmutableSet<Block> relatedWorldBlocksIn, SoundEvent soundIn) {
        return new VillagerProfession(nameIn, pointOfInterestIn, specificItemsIn, relatedWorldBlocksIn, soundIn);
    }

    public static PointOfInterestType createPoi(String string, Set<BlockState> set, int i, int j) {
        try {
            Constructor constructor = PointOfInterestType.class.getDeclaredConstructor(String.class, Set.class, Integer.TYPE, Integer.TYPE);
            return (PointOfInterestType)constructor.newInstance(string, set, i, i);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void registerItemProperty(Item item, String name, IItemPropertyGetter itemPropertyFunction) {
        ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)new ResourceLocation("gardenarsenal", name), (IItemPropertyGetter)itemPropertyFunction);
    }

    public static IRecipeSerializer<?> createRecipeSerializer(IRecipeSerializer<?> recipeSerializer) {
        return new ForgeRecipeSerializer(recipeSerializer);
    }

    public static void registerTrades(GardenArsenalTrades.TradeListBuilder tradeListBuilder) {
        GardenArsenalForge.tradeListBuilders.add(tradeListBuilder);
    }
}

