/*
 * Decompiled with CFR 0.152.
 */
package multiteam.gardenarsenal.items;

import java.util.List;
import multiteam.gardenarsenal.entities.WeaponProjectile;
import multiteam.gardenarsenal.items.WeaponItem;
import multiteam.gardenarsenal.registries.GardenArsenalItems;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CocoaShotgun
extends WeaponItem {
    public CocoaShotgun(Item.Properties settings) {
        super(settings);
    }

    @Override
    protected int getCooldown() {
        return 50;
    }

    @Override
    public SoundEvent getSoundEvent() {
        return SoundEvents.f_11931_;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        super.m_7373_(stack, world, tooltip, context);
        tooltip.add((Component)new TranslatableComponent("tooltip.gardenarsenal.cocoa_bean_shotgun_desc").m_6881_().m_130940_(ChatFormatting.BLUE));
        CompoundTag compoundTag = stack.m_41784_();
        if (!compoundTag.m_128441_("skinType")) {
            compoundTag.m_128359_("skinType", "Default");
            stack.m_41751_(compoundTag);
        }
        tooltip.add((Component)new TranslatableComponent("tooltip.gardenarsenal.skin." + compoundTag.m_128461_("skinType")).m_6881_().m_130948_(Style.f_131099_.m_131148_(this.getTextColor(compoundTag))));
    }

    @Override
    public void createProjectileEntities(Level world, Player playerEntity) {
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                WeaponProjectile projectile = new WeaponProjectile(world, (LivingEntity)playerEntity);
                projectile.bulletDamage = 6;
                projectile.m_37446_(new ItemStack((ItemLike)this.getRenderedItem()));
                projectile.m_37251_((Entity)playerEntity, playerEntity.m_146909_() + (float)(x * 4), playerEntity.m_146908_() + (float)(y * 4), 0.0f, 2.0f, 1.0f);
                world.m_7967_((Entity)projectile);
            }
        }
    }

    @Override
    public Item getAmmoItem() {
        return (Item)GardenArsenalItems.COCOA_BEANS_SHELL.get();
    }

    @Override
    public Item getRenderedItem() {
        return Items.f_42533_;
    }
}

