/*
 * Decompiled with CFR 0.152.
 */
package multiteam.gardenarsenal.items;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import multiteam.gardenarsenal.entities.WeaponProjectile;
import multiteam.gardenarsenal.items.WeaponItem;
import multiteam.gardenarsenal.registries.GardenArsenalItems;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GlimmeringRevolver
extends WeaponItem {
    public GlimmeringRevolver(Item.Properties settings) {
        super(settings);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        super.m_7373_(stack, world, tooltip, context);
        tooltip.add((Component)new TranslatableComponent("tooltip.gardenarsenal.glimmering_revolver_desc").m_6881_().m_130940_(ChatFormatting.GOLD));
        CompoundTag compoundTag = stack.m_41784_();
        if (!compoundTag.m_128441_("skinType")) {
            compoundTag.m_128359_("skinType", "Default");
        }
        if (!compoundTag.m_128441_("shellLoad")) {
            compoundTag.m_128405_("shellLoad", 0);
        }
        stack.m_41751_(compoundTag);
        tooltip.add((Component)new TranslatableComponent("tooltip.gardenarsenal.skin." + compoundTag.m_128461_("skinType")).m_6881_().m_130948_(Style.f_131099_.m_131148_(this.getTextColor(compoundTag))));
    }

    @Override
    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            Player playerEntity = (Player)user;
            CompoundTag nbt = stack.m_41783_();
            if (nbt != null) {
                ItemStack ammoStack = this.getAmmoInInventory(playerEntity);
                int bulets = nbt.m_128451_("shellLoad");
                if (bulets == 0) {
                    if (!ammoStack.m_41619_()) {
                        bulets = 6;
                        nbt.m_128405_("shellLoad", bulets);
                    }
                } else if (bulets >= 1) {
                    boolean bl;
                    boolean bl2 = bl = playerEntity.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
                    if (bulets == 1) {
                        playerEntity.m_36335_().m_41524_((Item)this, this.getCooldown());
                    }
                    if (!ammoStack.m_41619_() && this.m_6437_().test(ammoStack) || bl) {
                        boolean bl22;
                        if (ammoStack.m_41619_()) {
                            ammoStack = new ItemStack((ItemLike)this.getAmmoItem());
                        }
                        int i = this.getMaxUseTime(stack) - remainingUseTicks;
                        float f = GlimmeringRevolver.getPullProgress(i);
                        boolean bl3 = bl22 = bl && ammoStack.m_41720_() == this.getAmmoItem();
                        if (!world.f_46443_) {
                            this.createProjectileEntities(world, playerEntity);
                            stack.m_41622_(1, (LivingEntity)playerEntity, p -> p.m_21190_(playerEntity.m_7655_()));
                        }
                        nbt.m_128405_("shellLoad", --bulets);
                        world.m_6263_(null, playerEntity.m_20185_(), playerEntity.m_20186_(), playerEntity.m_20189_(), this.getSoundEvent(), SoundSource.PLAYERS, 1.0f, 1.0f / (ThreadLocalRandom.current().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                        if (!bl22 && !playerEntity.m_150110_().f_35937_) {
                            ammoStack.m_41774_(1);
                            if (ammoStack.m_41619_()) {
                                playerEntity.m_150109_().m_36057_(ammoStack);
                            }
                        }
                        playerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    }
                }
            }
        }
    }

    @Override
    protected int getCooldown() {
        return 30;
    }

    @Override
    public SoundEvent getSoundEvent() {
        return SoundEvents.f_11928_;
    }

    @Override
    public void createProjectileEntities(Level world, Player playerEntity) {
        WeaponProjectile weaponProjectile = new WeaponProjectile(world, (LivingEntity)playerEntity);
        weaponProjectile.bulletDamage = 2;
        weaponProjectile.m_37446_(new ItemStack((ItemLike)this.getRenderedItem()));
        weaponProjectile.m_37251_((Entity)playerEntity, playerEntity.m_146909_(), playerEntity.m_146908_(), 0.0f, 2.0f, 1.0f);
        world.m_7967_((Entity)weaponProjectile);
    }

    @Override
    public Item getAmmoItem() {
        return (Item)GardenArsenalItems.GLIMMERING_MELON_SEEDS.get();
    }
}

