/*
 * Decompiled with CFR 0.152.
 */
package multiteam.gardenarsenal.items;

import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import multiteam.gardenarsenal.utils.Skins;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class WeaponItem
extends BowItem {
    public WeaponItem(Item.Properties settings) {
        super(settings);
    }

    public ItemStack getAmmoInInventory(Player playerEntity) {
        Item predicate = this.getAmmoItem();
        Inventory playerInventory = playerEntity.m_150109_();
        for (int i = 0; i < playerInventory.m_6643_(); ++i) {
            ItemStack stack = playerInventory.m_8020_(i);
            if (predicate != stack.m_41720_()) continue;
            return stack;
        }
        return playerEntity.m_150110_().f_35937_ ? new ItemStack((ItemLike)predicate) : ItemStack.f_41583_;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        boolean bl;
        ItemStack itemStack = player.m_21120_(interactionHand);
        boolean bl2 = bl = !this.getAmmoInInventory(player).m_41619_();
        if (!player.m_150110_().f_35937_ && !bl) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        player.m_6672_(interactionHand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public int m_6615_() {
        return 15;
    }

    public Predicate<ItemStack> m_6437_() {
        return stack -> stack.m_41720_() == this.getAmmoItem();
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            Player playerEntity = (Player)user;
            boolean bl = playerEntity.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
            ItemStack itemStack = this.getAmmoInInventory(playerEntity);
            playerEntity.m_36335_().m_41524_((Item)this, this.getCooldown());
            if (!itemStack.m_41619_() && this.m_6437_().test(itemStack) || bl) {
                int i;
                float f;
                if (itemStack.m_41619_()) {
                    itemStack = new ItemStack((ItemLike)this.getAmmoItem());
                }
                if (!((double)(f = WeaponItem.getPullProgress(i = this.getMaxUseTime(stack) - remainingUseTicks)) < 0.1)) {
                    boolean bl2;
                    boolean bl3 = bl2 = bl && itemStack.m_41720_() == this.getAmmoItem();
                    if (!world.f_46443_) {
                        this.createProjectileEntities(world, playerEntity);
                        stack.m_41622_(1, (LivingEntity)playerEntity, p -> p.m_21190_(playerEntity.m_7655_()));
                    }
                    world.m_6263_(null, playerEntity.m_20185_(), playerEntity.m_20186_(), playerEntity.m_20189_(), this.getSoundEvent(), SoundSource.PLAYERS, 1.0f, 1.0f / (ThreadLocalRandom.current().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    if (!bl2 && !playerEntity.m_150110_().f_35937_) {
                        itemStack.m_41774_(1);
                        if (itemStack.m_41619_()) {
                            playerEntity.m_150109_().m_36057_(itemStack);
                        }
                    }
                    playerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                }
            }
        }
    }

    public ItemStack m_7968_() {
        ItemStack stack = super.m_7968_();
        if (this.hasSkin()) {
            stack.m_41784_().m_128359_("skinType", "Default");
        }
        return stack;
    }

    protected boolean hasSkin() {
        return true;
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.BOW;
    }

    protected abstract int getCooldown();

    public int getMaxUseTime(ItemStack stack) {
        return 72000;
    }

    public abstract SoundEvent getSoundEvent();

    public abstract void createProjectileEntities(Level var1, Player var2);

    public abstract Item getAmmoItem();

    public Item getRenderedItem() {
        return this.getAmmoItem();
    }

    public static float getPullProgress(int useTicks) {
        float f = (float)useTicks / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public Component m_7626_(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null) {
            return new TranslatableComponent(this.m_5671_(itemStack)).m_130948_(Style.f_131099_.m_131148_(this.getTextColor(tag)));
        }
        return new TranslatableComponent(this.m_5671_(itemStack));
    }

    public TextColor getTextColor(CompoundTag tag) {
        if (tag != null) {
            try {
                Skins skin = Skins.valueOf(tag.m_128461_("skinType"));
                return skin.getRarity().getTextColor();
            }
            catch (IllegalArgumentException e) {
                return TextColor.m_131266_((int)0);
            }
        }
        return TextColor.m_131266_((int)0);
    }

    public int m_6473_() {
        return 0;
    }
}

