/*
 * Decompiled with CFR 0.152.
 */
package multiteam.gardenarsenal.forge;

import dev.architectury.platform.Platform;
import dev.architectury.platform.forge.EventBuses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import multiteam.gardenarsenal.GardenArsenal;
import multiteam.gardenarsenal.GardenArsenalClient;
import multiteam.gardenarsenal.registries.GardenArsenalBlocks;
import multiteam.gardenarsenal.registries.GardenArsenalTrades;
import multiteam.gardenarsenal.utils.RandomTradeBuilder;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="gardenarsenal")
public class GardenArsenalForge {
    private static final Map<String, String> ID_FIXES = new HashMap<String, String>();
    protected static List<GardenArsenalTrades.TradeListBuilder> tradeListBuilders = new ArrayList<GardenArsenalTrades.TradeListBuilder>();

    public GardenArsenalForge() {
        ID_FIXES.put("potato_granade", "potato_grenade");
        ID_FIXES.put("skin_card_metalic_gold", "skin_card_metallic_gold");
        ID_FIXES.put("skin_card_metalic_iron", "skin_card_metallic_iron");
        ID_FIXES.put("skin_card_metalic_netherite", "skin_card_metallic_netherite");
        EventBuses.onRegistered((String)"gardenarsenal", iEventBus -> {
            iEventBus.addListener(this::doClientStuff);
            iEventBus.addGenericListener(Item.class, GardenArsenalForge::fixOldIds);
        });
        EventBuses.registerModEventBus((String)"gardenarsenal", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.addListener((Consumer)new Consumer<VillagerTradesEvent>(){

            @Override
            public void accept(VillagerTradesEvent event) {
                GardenArsenalForge.registerTrades(event);
            }
        });
        GardenArsenal.init();
        if (Platform.getEnv() == Dist.CLIENT) {
            GardenArsenalClient.init();
        }
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GardenArsenalBlocks.AMMO_CRATE.get()), (RenderType)RenderType.m_110463_());
    }

    public static void fixOldIds(RegistryEvent.MissingMappings<Item> event) {
        for (Map.Entry<String, String> fixEntry : ID_FIXES.entrySet()) {
            ResourceLocation old = new ResourceLocation("gardenarsenal", fixEntry.getKey());
            ResourceLocation newId = new ResourceLocation("gardenarsenal", fixEntry.getValue());
            for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
                if (!entry.key.equals((Object)old)) continue;
                entry.remap((IForgeRegistryEntry)((Item)ForgeRegistries.ITEMS.getValue(newId)));
            }
        }
    }

    public static void registerTrades(VillagerTradesEvent event) {
        for (GardenArsenalTrades.TradeListBuilder tradeListBuilder : tradeListBuilders) {
            if (event.getType() != tradeListBuilder.getProfession().get()) continue;
            for (int i = 0; i < tradeListBuilder.size(); ++i) {
                List list = (List)tradeListBuilder.get(i);
                int level = i + 1;
                for (RandomTradeBuilder randomTradeBuilder : list) {
                    ((List)event.getTrades().get(level)).add(randomTradeBuilder.build());
                }
            }
        }
    }
}

