/*
 * Decompiled with CFR 0.152.
 */
package multiteam.gardenarsenal.recipes;

import com.google.gson.JsonObject;
import dev.architectury.registry.registries.Registries;
import multiteam.gardenarsenal.GardenArsenalExpectPlatform;
import multiteam.gardenarsenal.items.SkinCardItem;
import multiteam.gardenarsenal.utils.Skins;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SkinUpgradeRecipe
extends UpgradeRecipe {
    public static RecipeSerializer<?> DYNAMIC_SERIALIZER;
    public static final RecipeSerializer<?> SERIALIZER;
    private final Item weapon;

    public SkinUpgradeRecipe(ResourceLocation resourceLocation, Item ingredient) {
        super(resourceLocation, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}), new ItemStack((ItemLike)ingredient));
        this.weapon = ingredient;
    }

    public boolean m_5818_(Container container, Level level) {
        SkinCardItem skinCardItem;
        Item item;
        return this.weapon == container.m_8020_(0).m_41720_() && (item = container.m_8020_(1).m_41720_()) instanceof SkinCardItem && (skinCardItem = (SkinCardItem)item).getSkin().canApplySkin(this.weapon);
    }

    public boolean m_44535_(ItemStack itemStack) {
        SkinCardItem skinCardItem;
        Item item = itemStack.m_41720_();
        return item instanceof SkinCardItem && (skinCardItem = (SkinCardItem)item).getSkin().canApplySkin(this.weapon);
    }

    public static RecipeSerializer<?> createSerializer() {
        DYNAMIC_SERIALIZER = GardenArsenalExpectPlatform.createRecipeSerializer(new Serializer());
        return DYNAMIC_SERIALIZER;
    }

    public ItemStack m_5874_(Container container) {
        ItemStack itemStack = new ItemStack((ItemLike)this.weapon);
        CompoundTag compoundTag = container.m_8020_(0).m_41783_();
        if (compoundTag != null) {
            itemStack.m_41751_(compoundTag.m_6426_());
        }
        SkinCardItem skinCardItem = (SkinCardItem)container.m_8020_(1).m_41720_();
        Skins skin = skinCardItem.getSkin();
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128359_("skinType", skin.name());
        return itemStack;
    }

    public RecipeSerializer<?> m_7707_() {
        return DYNAMIC_SERIALIZER;
    }

    static {
        SERIALIZER = new Serializer();
    }

    public static class Serializer
    implements RecipeSerializer<SkinUpgradeRecipe> {
        public SkinUpgradeRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            Item ingredient = (Item)Registries.get((String)"gardenarsenal").get(Registry.f_122904_).get(new ResourceLocation(jsonObject.get("weapon").getAsString()));
            return new SkinUpgradeRecipe(resourceLocation, ingredient);
        }

        public SkinUpgradeRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            ItemStack ingredient = friendlyByteBuf.m_130267_();
            return new SkinUpgradeRecipe(resourceLocation, ingredient.m_41720_());
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, SkinUpgradeRecipe recipe) {
            friendlyByteBuf.m_130055_(new ItemStack((ItemLike)recipe.weapon));
        }
    }
}

