/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.inventory.CommandContainer;
import com.talhanation.recruits.network.MessageCommandScreen;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.NetworkHooks;

public class CommandEvents {
    private static int recruitsInCommand;
    private static int currentGroup;

    public static void onRKeyPressed(UUID player_uuid, AbstractRecruitEntity recruit, int r_state, int group, boolean fromGui) {
        if (recruit.func_70909_n() && (recruit.getListen() || fromGui) && Objects.equals(recruit.func_184753_b(), player_uuid) && (recruit.getGroup() == group || group == 0)) {
            int state = recruit.getFollowState();
            switch (r_state) {
                case 0: {
                    if (state == 0) break;
                    recruit.setFollowState(0);
                    break;
                }
                case 1: {
                    if (state == 1) break;
                    recruit.setFollowState(1);
                    break;
                }
                case 2: {
                    if (state == 2) break;
                    recruit.setFollowState(2);
                }
            }
        }
    }

    public static void onXKeyPressed(UUID player_uuid, AbstractRecruitEntity recruit, int x_state, int group, boolean fromGui) {
        if (recruit.func_70909_n() && (recruit.getListen() || fromGui) && Objects.equals(recruit.func_184753_b(), player_uuid) && (recruit.getGroup() == group || group == 0)) {
            int state = recruit.getState();
            switch (x_state) {
                case 0: {
                    if (state == 0) break;
                    recruit.setState(0);
                    break;
                }
                case 1: {
                    if (state == 1) break;
                    recruit.setState(1);
                    break;
                }
                case 2: {
                    if (state == 2) break;
                    recruit.setState(2);
                }
            }
        }
    }

    public static void onCKeyPressed(UUID player_uuid, AbstractRecruitEntity recruit, int group) {
    }

    public static void openCommandScreen(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return new StringTextComponent("command_screen"){};
                }

                @Nullable
                public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                    return new CommandContainer(i, playerEntity);
                }
            }, packetBuffer -> packetBuffer.func_179252_a(player.func_110124_au()));
        } else {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageCommandScreen(player));
        }
    }

    public static void sendFollowCommandInChat(int state, LivingEntity owner) {
        switch (state) {
            case 0: {
                owner.func_145747_a((ITextComponent)new StringTextComponent("Release!"), owner.func_110124_au());
                break;
            }
            case 1: {
                owner.func_145747_a((ITextComponent)new StringTextComponent("Follow me!"), owner.func_110124_au());
                break;
            }
            case 2: {
                owner.func_145747_a((ITextComponent)new StringTextComponent("Hold your Position!"), owner.func_110124_au());
            }
        }
    }

    public static void sendAggroCommandInChat(int state, LivingEntity owner) {
        switch (state) {
            case 0: {
                owner.func_145747_a((ITextComponent)new StringTextComponent("Stay Neutral!"), owner.func_110124_au());
                break;
            }
            case 1: {
                owner.func_145747_a((ITextComponent)new StringTextComponent("Stay Aggressive!"), owner.func_110124_au());
                break;
            }
            case 2: {
                owner.func_145747_a((ITextComponent)new StringTextComponent("Raid!"), owner.func_110124_au());
            }
        }
    }

    public static void setRecruitsInCommand(int count) {
        recruitsInCommand = count;
    }

    public static int getRecruitsInCommand() {
        return recruitsInCommand;
    }

    public static void setCurrentGroup(int group) {
        currentGroup = group;
    }

    public static int getCurrentGroup() {
        return currentGroup;
    }
}

