/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits;

import com.google.common.collect.ImmutableSet;
import com.talhanation.recruits.CommandEvents;
import com.talhanation.recruits.PillagerEvents;
import com.talhanation.recruits.RecruitEvents;
import com.talhanation.recruits.VillagerEvents;
import com.talhanation.recruits.client.events.KeyEvents;
import com.talhanation.recruits.client.events.PlayerEvents;
import com.talhanation.recruits.client.gui.CommandScreen;
import com.talhanation.recruits.client.gui.RecruitInventoryScreen;
import com.talhanation.recruits.config.RecruitsModConfig;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.BowmanEntity;
import com.talhanation.recruits.entities.NomadEntity;
import com.talhanation.recruits.entities.RecruitEntity;
import com.talhanation.recruits.entities.RecruitShieldmanEntity;
import com.talhanation.recruits.init.ModBlocks;
import com.talhanation.recruits.init.ModEntityTypes;
import com.talhanation.recruits.init.ModItems;
import com.talhanation.recruits.inventory.CommandContainer;
import com.talhanation.recruits.inventory.RecruitInventoryContainer;
import com.talhanation.recruits.network.MessageAggro;
import com.talhanation.recruits.network.MessageAggroGui;
import com.talhanation.recruits.network.MessageAttackEntity;
import com.talhanation.recruits.network.MessageClearTarget;
import com.talhanation.recruits.network.MessageCommandScreen;
import com.talhanation.recruits.network.MessageDisband;
import com.talhanation.recruits.network.MessageFollow;
import com.talhanation.recruits.network.MessageFollowGui;
import com.talhanation.recruits.network.MessageGroup;
import com.talhanation.recruits.network.MessageListen;
import com.talhanation.recruits.network.MessageMove;
import com.talhanation.recruits.network.MessageRecruitGui;
import com.talhanation.recruits.network.MessageRecruitsInCommand;
import de.maxhenkel.recruits.corelib.ClientRegistry;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="recruits")
public class Main {
    public static final String MOD_ID = "recruits";
    public static SimpleChannel SIMPLE_CHANNEL;
    public static VillagerProfession RECRUIT;
    public static VillagerProfession BOWMAN;
    public static VillagerProfession RECRUIT_SHIELDMAN;
    public static VillagerProfession SCOUT;
    public static VillagerProfession NOMAD;
    public static PointOfInterestType POI_RECRUIT;
    public static PointOfInterestType POI_BOWMAN;
    public static PointOfInterestType POI_RECRUIT_SHIELDMAN;
    public static PointOfInterestType POI_SCOUT;
    public static PointOfInterestType POI_NOMAD;
    public static KeyBinding R_KEY;
    public static ContainerType<RecruitInventoryContainer> RECRUIT_CONTAINER_TYPE;
    public static ContainerType<CommandContainer> COMMAND_CONTAINER_TYPE;

    public Main() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RecruitsModConfig.CONFIG);
        RecruitsModConfig.loadConfig(RecruitsModConfig.CONFIG, FMLPaths.CONFIGDIR.get().resolve("recruits-common.toml"));
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        modEventBus.addGenericListener(PointOfInterestType.class, this::registerPointsOfInterest);
        modEventBus.addGenericListener(VillagerProfession.class, this::registerVillagerProfessions);
        modEventBus.addGenericListener(ContainerType.class, this::registerContainers);
        ModBlocks.BLOCKS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModEntityTypes.ENTITY_TYPES.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup));
    }

    private void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new RecruitEvents());
        MinecraftForge.EVENT_BUS.register((Object)new VillagerEvents());
        MinecraftForge.EVENT_BUS.register((Object)new PillagerEvents());
        MinecraftForge.EVENT_BUS.register((Object)new CommandEvents());
        MinecraftForge.EVENT_BUS.register((Object)this);
        SIMPLE_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MOD_ID, "default"), () -> "1.0.0", s -> true, s -> true);
        SIMPLE_CHANNEL.registerMessage(1, MessageFollow.class, MessageFollow::toBytes, buf -> new MessageFollow().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(2, MessageAggro.class, MessageAggro::toBytes, buf -> new MessageAggro().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(3, MessageMove.class, MessageMove::toBytes, buf -> new MessageMove().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(4, MessageClearTarget.class, MessageClearTarget::toBytes, buf -> new MessageClearTarget().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(5, MessageListen.class, MessageListen::toBytes, buf -> new MessageListen().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(6, MessageRecruitGui.class, MessageRecruitGui::toBytes, buf -> new MessageRecruitGui().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(7, MessageCommandScreen.class, MessageCommandScreen::toBytes, buf -> new MessageCommandScreen().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(8, MessageGroup.class, MessageGroup::toBytes, buf -> new MessageGroup().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(9, MessageFollowGui.class, MessageFollowGui::toBytes, buf -> new MessageFollowGui().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(10, MessageAggroGui.class, MessageAggroGui::toBytes, buf -> new MessageAggroGui().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(11, MessageAttackEntity.class, MessageAttackEntity::toBytes, buf -> new MessageAttackEntity().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(12, MessageRecruitsInCommand.class, MessageRecruitsInCommand::toBytes, buf -> new MessageRecruitsInCommand().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(13, MessageDisband.class, MessageDisband::toBytes, buf -> new MessageDisband().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        DeferredWorkQueue.runLater(() -> {
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntityTypes.RECRUIT.get()), (AttributeModifierMap)RecruitEntity.setAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntityTypes.RECRUIT_SHIELDMAN.get()), (AttributeModifierMap)RecruitShieldmanEntity.setAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntityTypes.BOWMAN.get()), (AttributeModifierMap)BowmanEntity.setAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntityTypes.CROSSBOWMAN.get()), (AttributeModifierMap)BowmanEntity.setAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntityTypes.NOMAD.get()), (AttributeModifierMap)NomadEntity.setAttributes().func_233813_a_());
        });
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new KeyEvents());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEvents());
        R_KEY = ClientRegistry.registerKeyBinding("key.r_key", "category.recruits", 82);
        ClientRegistry.registerScreen(RECRUIT_CONTAINER_TYPE, RecruitInventoryScreen::new);
        ClientRegistry.registerScreen(COMMAND_CONTAINER_TYPE, CommandScreen::new);
    }

    @SubscribeEvent
    public void registerPointsOfInterest(RegistryEvent.Register<PointOfInterestType> event) {
        POI_RECRUIT = new PointOfInterestType("poi_recruit", PointOfInterestType.func_221042_a((Block)((Block)ModBlocks.RECRUIT_BLOCK.get())), 1, 1);
        POI_RECRUIT.setRegistryName(MOD_ID, "poi_recruit");
        POI_BOWMAN = new PointOfInterestType("poi_bowman", PointOfInterestType.func_221042_a((Block)((Block)ModBlocks.BOWMAN_BLOCK.get())), 1, 1);
        POI_BOWMAN.setRegistryName(MOD_ID, "poi_bowman");
        POI_RECRUIT_SHIELDMAN = new PointOfInterestType("poi_recruit_shieldman", PointOfInterestType.func_221042_a((Block)((Block)ModBlocks.RECRUIT_SHIELD_BLOCK.get())), 1, 1);
        POI_RECRUIT_SHIELDMAN.setRegistryName(MOD_ID, "poi_recruit_shieldman");
        event.getRegistry().register((IForgeRegistryEntry)POI_RECRUIT);
        event.getRegistry().register((IForgeRegistryEntry)POI_BOWMAN);
        event.getRegistry().register((IForgeRegistryEntry)POI_RECRUIT_SHIELDMAN);
    }

    @SubscribeEvent
    public void registerVillagerProfessions(RegistryEvent.Register<VillagerProfession> event) {
        RECRUIT = new VillagerProfession("recruit", POI_RECRUIT, ImmutableSet.of(), ImmutableSet.of(), SoundEvents.field_219721_mv);
        RECRUIT.setRegistryName(MOD_ID, "recruit");
        BOWMAN = new VillagerProfession("bowman", POI_BOWMAN, ImmutableSet.of(), ImmutableSet.of(), SoundEvents.field_219721_mv);
        BOWMAN.setRegistryName(MOD_ID, "bowman");
        RECRUIT_SHIELDMAN = new VillagerProfession("recruit_shieldman", POI_RECRUIT_SHIELDMAN, ImmutableSet.of(), ImmutableSet.of(), SoundEvents.field_219721_mv);
        RECRUIT_SHIELDMAN.setRegistryName(MOD_ID, "recruit_shieldman");
        event.getRegistry().register((IForgeRegistryEntry)RECRUIT);
        event.getRegistry().register((IForgeRegistryEntry)RECRUIT_SHIELDMAN);
        event.getRegistry().register((IForgeRegistryEntry)BOWMAN);
    }

    @SubscribeEvent
    public void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        RECRUIT_CONTAINER_TYPE = new ContainerType((ContainerType.IFactory)((IContainerFactory)(windowId, inv, data) -> {
            AbstractRecruitEntity rec = Main.getRecruitByUUID(inv.field_70458_d, data.func_179253_g());
            if (rec == null) {
                return null;
            }
            return new RecruitInventoryContainer(windowId, rec, inv);
        }));
        RECRUIT_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MOD_ID, "recruit_container"));
        event.getRegistry().register(RECRUIT_CONTAINER_TYPE);
        COMMAND_CONTAINER_TYPE = new ContainerType((ContainerType.IFactory)((IContainerFactory)(windowId, inv, data) -> {
            PlayerEntity playerEntity = inv.field_70458_d;
            return new CommandContainer(windowId, playerEntity);
        }));
        COMMAND_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MOD_ID, "command_container"));
        event.getRegistry().register(COMMAND_CONTAINER_TYPE);
    }

    @Nullable
    public static AbstractRecruitEntity getRecruitByUUID(PlayerEntity player, UUID uuid) {
        double distance = 10.0;
        return player.field_70170_p.func_175647_a(AbstractRecruitEntity.class, new AxisAlignedBB(player.func_226277_ct_() - distance, player.func_226278_cu_() - distance, player.func_226281_cx_() - distance, player.func_226277_ct_() + distance, player.func_226278_cu_() + distance, player.func_226281_cx_() + distance), entity -> entity.func_110124_au().equals(uuid)).stream().findAny().orElse(null);
    }
}

