/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits;

import com.talhanation.recruits.config.RecruitsModConfig;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.ai.pillager.PillagerMeleeAttackGoal;
import com.talhanation.recruits.entities.ai.pillager.PillagerUseShield;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PillagerEvents {
    protected final Random random = new Random();

    @SubscribeEvent
    public void attackRecruit(EntityJoinWorldEvent event) {
        int i;
        MonsterEntity monster;
        PillagerEntity pillager;
        Entity entity = event.getEntity();
        if (entity instanceof PillagerEntity) {
            pillager = (PillagerEntity)entity;
            pillager.field_70714_bg.func_75776_a(0, (Goal)new PillagerMeleeAttackGoal(pillager, 1.15, true));
        }
        if (entity instanceof AbstractIllagerEntity) {
            AbstractIllagerEntity illager = (AbstractIllagerEntity)entity;
            illager.field_70714_bg.func_75776_a(0, (Goal)new PillagerUseShield(illager));
            illager.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)illager, AbstractRecruitEntity.class, true));
            if (((Boolean)RecruitsModConfig.PillagerAttackMonsters.get()).booleanValue()) {
                illager.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)illager, ZombieEntity.class, true));
                illager.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)illager, AbstractSkeletonEntity.class, true));
                illager.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)illager, SpiderEntity.class, true));
            }
            if (((Boolean)RecruitsModConfig.ShouldPillagersRaidNaturally.get()).booleanValue()) {
                illager.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)illager, AnimalEntity.class, true));
            }
        }
        if (entity instanceof MonsterEntity) {
            monster = (MonsterEntity)entity;
            monster.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)monster, AbstractRecruitEntity.class, true));
        }
        if (entity instanceof ZombieEntity && ((Boolean)RecruitsModConfig.MonstersAttackPillagers.get()).booleanValue()) {
            monster = (ZombieEntity)entity;
            monster.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)monster, AbstractIllagerEntity.class, true));
        }
        if (entity instanceof AbstractSkeletonEntity && ((Boolean)RecruitsModConfig.MonstersAttackPillagers.get()).booleanValue()) {
            monster = (AbstractSkeletonEntity)entity;
            monster.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)monster, AbstractIllagerEntity.class, true));
        }
        if (entity instanceof SpiderEntity && ((Boolean)RecruitsModConfig.MonstersAttackPillagers.get()).booleanValue()) {
            monster = (SpiderEntity)entity;
            monster.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)monster, AbstractIllagerEntity.class, true));
        }
        if (entity instanceof VindicatorEntity) {
            VindicatorEntity vindicator = (VindicatorEntity)entity;
            vindicator.func_110163_bv();
            vindicator.func_98053_h(true);
            vindicator.func_213644_t(true);
            i = this.random.nextInt(3);
            if (i == 2) {
                vindicator.func_184611_a(Hand.MAIN_HAND, Items.field_151036_c.func_190903_i());
            } else {
                vindicator.func_184611_a(Hand.MAIN_HAND, Items.field_151040_l.func_190903_i());
                vindicator.func_184611_a(Hand.OFF_HAND, Items.field_185159_cQ.func_190903_i());
            }
        }
        if (entity instanceof PillagerEntity) {
            pillager = (PillagerEntity)entity;
            pillager.func_110163_bv();
            pillager.func_98053_h(true);
            pillager.func_213644_t(true);
            i = this.random.nextInt(6);
            if (i == 2) {
                pillager.func_184611_a(Hand.MAIN_HAND, Items.field_151036_c.func_190903_i());
            } else if (i == 1) {
                pillager.func_184611_a(Hand.MAIN_HAND, Items.field_222114_py.func_190903_i());
            } else if (i == 3 || i == 4) {
                pillager.func_184611_a(Hand.MAIN_HAND, Items.field_222114_py.func_190903_i());
            } else {
                pillager.func_184611_a(Hand.MAIN_HAND, Items.field_151040_l.func_190903_i());
                pillager.func_184611_a(Hand.OFF_HAND, Items.field_185159_cQ.func_190903_i());
            }
        }
    }

    @SubscribeEvent
    public void onBiomeLoadingPillager(BiomeLoadingEvent event) {
        Biome.Category category = event.getCategory();
        if (category == Biome.Category.NETHER || category == Biome.Category.THEEND || category == Biome.Category.NONE || category == Biome.Category.OCEAN || category != Biome.Category.RIVER) {
            // empty if block
        }
    }

    private void createPillager(LivingEntity entity) {
        PillagerEntity pillager = (PillagerEntity)EntityType.field_220350_aJ.func_200721_a(entity.field_70170_p);
        pillager.func_82149_j((Entity)entity);
        entity.field_70170_p.func_217376_c((Entity)pillager);
    }
}

