/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits;

import com.talhanation.recruits.entities.AbstractRecruitEntity;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RecruitEvents {
    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent event) {
        Entity entity = event.getEntity();
        RayTraceResult rayTrace = event.getRayTraceResult();
        if (entity instanceof ProjectileEntity) {
            ProjectileEntity projectile = (ProjectileEntity)entity;
            Entity owner = projectile.func_234616_v_();
            if (rayTrace.func_216346_c() == RayTraceResult.Type.ENTITY && ((EntityRayTraceResult)rayTrace).func_216348_a() instanceof LivingEntity) {
                AbstractIllagerEntity illager;
                LivingEntity impactEntity = (LivingEntity)((EntityRayTraceResult)rayTrace).func_216348_a();
                if (owner instanceof AbstractRecruitEntity) {
                    AbstractRecruitEntity recruit = (AbstractRecruitEntity)owner;
                    if (!AbstractRecruitEntity.canDamageTarget(recruit, impactEntity)) {
                        event.setCanceled(true);
                    }
                    if (recruit.func_70902_q() == impactEntity) {
                        event.setCanceled(true);
                    }
                }
                if (owner instanceof AbstractIllagerEntity && (illager = (AbstractIllagerEntity)owner).func_184191_r((Entity)impactEntity)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    public static void onAttackButton(AbstractRecruitEntity recruit, LivingEntity owner, UUID target, int group) {
        if (recruit.getGroup() == group || group == 0) {
            List list = recruit.field_70170_p.func_217357_a(LivingEntity.class, recruit.func_174813_aQ().func_186662_g(64.0));
            for (LivingEntity potTargets : list) {
                recruit.func_70902_q().func_145747_a((ITextComponent)new StringTextComponent("FOR"), recruit.func_70902_q().func_110124_au());
                if (potTargets.func_110124_au() != target) continue;
                if (recruit.func_70902_q() == owner && recruit.func_142018_a(potTargets, owner)) {
                    recruit.func_70902_q().func_145747_a((ITextComponent)new StringTextComponent("TARGET"), recruit.func_70902_q().func_110124_au());
                }
                recruit.func_70624_b(potTargets);
            }
        }
    }

    public static void onStopButton(AbstractRecruitEntity recruit, UUID owner, int group) {
        if (recruit.func_70909_n() && recruit.getListen() && Objects.equals(recruit.func_184753_b(), owner) && (recruit.getGroup() == group || group == 0)) {
            recruit.func_70624_b(null);
        }
    }
}

