/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.config.RecruitsModConfig;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.BowmanEntity;
import com.talhanation.recruits.entities.CrossBowmanEntity;
import com.talhanation.recruits.entities.NomadEntity;
import com.talhanation.recruits.entities.RecruitEntity;
import com.talhanation.recruits.entities.RecruitShieldmanEntity;
import com.talhanation.recruits.init.ModBlocks;
import com.talhanation.recruits.init.ModEntityTypes;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class VillagerEvents {
    protected final Random random = new Random();

    @SubscribeEvent
    public void onVillagerLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        IronGolemEntity ironGolemEntity;
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof VillagerEntity) {
            VillagerEntity villager = (VillagerEntity)entity;
            VillagerProfession profession = villager.func_213700_eh().func_221130_b();
            if (profession == Main.RECRUIT) {
                VillagerEvents.createRecruit((LivingEntity)villager);
            }
            if (profession == Main.BOWMAN) {
                VillagerEvents.createBowman((LivingEntity)villager);
            }
            if (profession == Main.NOMAD) {
                VillagerEvents.createNomad((LivingEntity)villager);
            }
            if (profession == Main.RECRUIT_SHIELDMAN) {
                VillagerEvents.createRecruitShieldman((LivingEntity)villager);
            }
        }
        if (entity instanceof IronGolemEntity && !(ironGolemEntity = (IronGolemEntity)entity).func_70850_q() && ((Boolean)RecruitsModConfig.OverrideIronGolemSpawn.get()).booleanValue()) {
            List list1 = entity.field_70170_p.func_217357_a(AbstractRecruitEntity.class, ironGolemEntity.func_174813_aQ().func_186662_g(32.0));
            if (list1.size() > 1) {
                ironGolemEntity.func_70106_y();
            } else {
                int i = this.random.nextInt(5);
                if (i == 1) {
                    VillagerEvents.createBowmanIronGolem((LivingEntity)ironGolemEntity);
                } else if (i == 0) {
                    this.createRecruitShieldmanIronGolem((LivingEntity)ironGolemEntity);
                } else {
                    VillagerEvents.createRecruitIronGolem((LivingEntity)ironGolemEntity);
                }
            }
        }
    }

    private static void createRecruit(LivingEntity entity) {
        RecruitEntity recruit = (RecruitEntity)((EntityType)ModEntityTypes.RECRUIT.get()).func_200721_a(entity.field_70170_p);
        VillagerEntity villager = (VillagerEntity)entity;
        recruit.func_82149_j((Entity)villager);
        recruit.setEquipment();
        recruit.setDropEquipment();
        recruit.setRandomSpawnBonus();
        recruit.func_110163_bv();
        recruit.func_98053_h(true);
        recruit.setGroup(1);
        villager.func_70106_y();
        villager.field_70170_p.func_217376_c((Entity)recruit);
    }

    private static void createRecruitShieldman(LivingEntity entity) {
        RecruitShieldmanEntity recruitShieldman = (RecruitShieldmanEntity)((EntityType)ModEntityTypes.RECRUIT_SHIELDMAN.get()).func_200721_a(entity.field_70170_p);
        VillagerEntity villager = (VillagerEntity)entity;
        recruitShieldman.func_82149_j((Entity)villager);
        recruitShieldman.setEquipment();
        recruitShieldman.setDropEquipment();
        recruitShieldman.setRandomSpawnBonus();
        recruitShieldman.func_110163_bv();
        recruitShieldman.func_98053_h(true);
        recruitShieldman.setGroup(1);
        villager.func_70106_y();
        villager.field_70170_p.func_217376_c((Entity)recruitShieldman);
    }

    private static void createBowman(LivingEntity entity) {
        BowmanEntity bowman = (BowmanEntity)((EntityType)ModEntityTypes.BOWMAN.get()).func_200721_a(entity.field_70170_p);
        VillagerEntity villager = (VillagerEntity)entity;
        bowman.func_82149_j((Entity)villager);
        bowman.setEquipment();
        bowman.setDropEquipment();
        bowman.setRandomSpawnBonus();
        bowman.func_110163_bv();
        bowman.func_98053_h(true);
        bowman.reassessWeaponGoal();
        bowman.setGroup(2);
        villager.func_70106_y();
        villager.field_70170_p.func_217376_c((Entity)bowman);
    }

    private static void createCrossBowman(LivingEntity entity) {
        CrossBowmanEntity crossBowman = (CrossBowmanEntity)((EntityType)ModEntityTypes.CROSSBOWMAN.get()).func_200721_a(entity.field_70170_p);
        VillagerEntity villager = (VillagerEntity)entity;
        crossBowman.func_82149_j((Entity)villager);
        crossBowman.setEquipment();
        crossBowman.setDropEquipment();
        crossBowman.setRandomSpawnBonus();
        crossBowman.func_110163_bv();
        crossBowman.func_98053_h(true);
        crossBowman.setGroup(2);
        villager.func_70106_y();
        villager.field_70170_p.func_217376_c((Entity)crossBowman);
    }

    private static void createNomad(LivingEntity entity) {
        NomadEntity nomad = (NomadEntity)((EntityType)ModEntityTypes.NOMAD.get()).func_200721_a(entity.field_70170_p);
        VillagerEntity villager = (VillagerEntity)entity;
        nomad.func_82149_j((Entity)villager);
        nomad.setEquipment();
        nomad.setDropEquipment();
        nomad.setRandomSpawnBonus();
        nomad.func_110163_bv();
        nomad.func_98053_h(true);
        nomad.reassessWeaponGoal();
        nomad.setGroup(2);
        villager.func_70106_y();
        villager.field_70170_p.func_217376_c((Entity)nomad);
    }

    @SubscribeEvent
    public void villagerTrades(VillagerTradesEvent event) {
        List list;
        Trade block_trade;
        if (event.getType() == VillagerProfession.field_221152_b) {
            block_trade = new Trade((IItemProvider)Items.field_151166_bC, 10, (IItemProvider)ModBlocks.RECRUIT_SHIELD_BLOCK.get(), 1, 4, 10);
            list = (List)event.getTrades().get(2);
            list.add(block_trade);
            event.getTrades().put(2, (Object)list);
        }
        if (event.getType() == VillagerProfession.field_221165_o) {
            block_trade = new Trade((IItemProvider)Items.field_151166_bC, 3, (IItemProvider)ModBlocks.RECRUIT_BLOCK.get(), 1, 4, 10);
            list = (List)event.getTrades().get(2);
            list.add(block_trade);
            event.getTrades().put(2, (Object)list);
        }
        if (event.getType() == VillagerProfession.field_221158_h) {
            block_trade = new Trade((IItemProvider)Items.field_151166_bC, 4, (IItemProvider)ModBlocks.BOWMAN_BLOCK.get(), 1, 4, 10);
            list = (List)event.getTrades().get(2);
            list.add(block_trade);
            event.getTrades().put(2, (Object)list);
        }
    }

    private static void createRecruitIronGolem(LivingEntity entity) {
        RecruitEntity recruit = (RecruitEntity)((EntityType)ModEntityTypes.RECRUIT.get()).func_200721_a(entity.field_70170_p);
        IronGolemEntity villager = (IronGolemEntity)entity;
        recruit.func_82149_j((Entity)villager);
        recruit.setEquipment();
        recruit.setDropEquipment();
        recruit.setRandomSpawnBonus();
        recruit.func_110163_bv();
        recruit.func_98053_h(true);
        recruit.setGroup(1);
        recruit.getInventory().func_70299_a(5, Items.field_151025_P.func_190903_i());
        villager.func_70106_y();
        villager.field_70170_p.func_217376_c((Entity)recruit);
    }

    private void createRecruitShieldmanIronGolem(LivingEntity entity) {
        RecruitShieldmanEntity recruitShieldman = (RecruitShieldmanEntity)((EntityType)ModEntityTypes.RECRUIT_SHIELDMAN.get()).func_200721_a(entity.field_70170_p);
        IronGolemEntity villager = (IronGolemEntity)entity;
        recruitShieldman.func_82149_j((Entity)villager);
        recruitShieldman.setEquipment();
        recruitShieldman.setDropEquipment();
        recruitShieldman.setRandomSpawnBonus();
        recruitShieldman.func_110163_bv();
        recruitShieldman.func_98053_h(true);
        recruitShieldman.setGroup(1);
        recruitShieldman.getInventory().func_70299_a(5, Items.field_151025_P.func_190903_i());
        villager.func_70106_y();
        villager.field_70170_p.func_217376_c((Entity)recruitShieldman);
    }

    private static void createBowmanIronGolem(LivingEntity entity) {
        BowmanEntity bowman = (BowmanEntity)((EntityType)ModEntityTypes.BOWMAN.get()).func_200721_a(entity.field_70170_p);
        IronGolemEntity villager = (IronGolemEntity)entity;
        bowman.func_82149_j((Entity)villager);
        bowman.setEquipment();
        bowman.setDropEquipment();
        bowman.setRandomSpawnBonus();
        bowman.func_110163_bv();
        bowman.func_98053_h(true);
        bowman.reassessWeaponGoal();
        bowman.setGroup(2);
        bowman.getInventory().func_70299_a(5, Items.field_151025_P.func_190903_i());
        villager.func_70106_y();
        villager.field_70170_p.func_217376_c((Entity)bowman);
    }

    static class ItemsForEmeraldsTrade
    implements VillagerTrades.ITrade {
        private final ItemStack itemStack;
        private final int emeraldCost;
        private final int numberOfItems;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public ItemsForEmeraldsTrade(Block p_i50528_1_, int p_i50528_2_, int p_i50528_3_, int p_i50528_4_, int p_i50528_5_) {
            this(new ItemStack((IItemProvider)p_i50528_1_), p_i50528_2_, p_i50528_3_, p_i50528_4_, p_i50528_5_);
        }

        public ItemsForEmeraldsTrade(Item p_i50529_1_, int p_i50529_2_, int p_i50529_3_, int p_i50529_4_) {
            this(new ItemStack((IItemProvider)p_i50529_1_), p_i50529_2_, p_i50529_3_, 12, p_i50529_4_);
        }

        public ItemsForEmeraldsTrade(Item p_i50530_1_, int p_i50530_2_, int p_i50530_3_, int p_i50530_4_, int p_i50530_5_) {
            this(new ItemStack((IItemProvider)p_i50530_1_), p_i50530_2_, p_i50530_3_, p_i50530_4_, p_i50530_5_);
        }

        public ItemsForEmeraldsTrade(ItemStack p_i50531_1_, int p_i50531_2_, int p_i50531_3_, int p_i50531_4_, int p_i50531_5_) {
            this(p_i50531_1_, p_i50531_2_, p_i50531_3_, p_i50531_4_, p_i50531_5_, 0.05f);
        }

        public ItemsForEmeraldsTrade(ItemStack p_i50532_1_, int p_i50532_2_, int p_i50532_3_, int p_i50532_4_, int p_i50532_5_, float p_i50532_6_) {
            this.itemStack = p_i50532_1_;
            this.emeraldCost = p_i50532_2_;
            this.numberOfItems = p_i50532_3_;
            this.maxUses = p_i50532_4_;
            this.villagerXp = p_i50532_5_;
            this.priceMultiplier = p_i50532_6_;
        }

        public MerchantOffer func_221182_a(Entity p_221182_1_, Random p_221182_2_) {
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.emeraldCost), new ItemStack((IItemProvider)this.itemStack.func_77973_b(), this.numberOfItems), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    static class Trade
    implements VillagerTrades.ITrade {
        private final Item buyingItem;
        private final Item sellingItem;
        private final int buyingAmount;
        private final int sellingAmount;
        private final int maxUses;
        private final int givenExp;
        private final float priceMultiplier;

        public Trade(IItemProvider buyingItem, int buyingAmount, IItemProvider sellingItem, int sellingAmount, int maxUses, int givenExp) {
            this.buyingItem = buyingItem.func_199767_j();
            this.buyingAmount = buyingAmount;
            this.sellingItem = sellingItem.func_199767_j();
            this.sellingAmount = sellingAmount;
            this.maxUses = maxUses;
            this.givenExp = givenExp;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer func_221182_a(Entity entity, Random random) {
            return new MerchantOffer(new ItemStack((IItemProvider)this.buyingItem, this.buyingAmount), new ItemStack((IItemProvider)this.sellingItem, this.sellingAmount), this.maxUses, this.givenExp, this.priceMultiplier);
        }
    }

    static class MultiTrade
    implements VillagerTrades.ITrade {
        private final VillagerTrades.ITrade[] trades;

        public MultiTrade(VillagerTrades.ITrade ... trades) {
            this.trades = trades;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity entity, Random random) {
            return this.trades[random.nextInt(this.trades.length)].func_221182_a(entity, random);
        }
    }

    static class EmeraldForItemsTrade
    extends Trade {
        public EmeraldForItemsTrade(IItemProvider buyingItem, int buyingAmount, int maxUses, int givenExp) {
            super(buyingItem, buyingAmount, (IItemProvider)Items.field_151166_bC, 1, maxUses, givenExp);
        }
    }
}

