/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.client.gui.CommandScreen;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.inventory.RecruitInventoryContainer;
import com.talhanation.recruits.network.MessageAggroGui;
import com.talhanation.recruits.network.MessageDisband;
import com.talhanation.recruits.network.MessageFollowGui;
import com.talhanation.recruits.network.MessageGroup;
import com.talhanation.recruits.network.MessageListen;
import de.maxhenkel.recruits.corelib.inventory.ScreenBase;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RecruitInventoryScreen
extends ScreenBase<RecruitInventoryContainer> {
    private static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("recruits", "textures/gui/recruit_gui.png");
    private static final ITextComponent TEXT_HEALTH = new TranslationTextComponent("gui.recruits.health");
    private static final ITextComponent TEXT_LEVEL = new TranslationTextComponent("gui.recruits.level");
    private static final ITextComponent TEXT_GROUP = new TranslationTextComponent("gui.recruits.group");
    private static final ITextComponent TEXT_KILLS = new TranslationTextComponent("gui.recruits.kills");
    private static final int fontColor = 0x404040;
    private final AbstractRecruitEntity recruit;
    private final PlayerInventory playerInventory;
    private int followState;
    private int aggroState;
    private int group;

    public RecruitInventoryScreen(RecruitInventoryContainer recruitContainer, PlayerInventory playerInventory, ITextComponent title) {
        super(RESOURCE_LOCATION, recruitContainer, playerInventory, title);
        this.recruit = recruitContainer.getRecruit();
        this.playerInventory = playerInventory;
        this.field_146999_f = 176;
        this.field_147000_g = 218;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new Button(this.field_147003_i + 77, this.field_147009_r + 74, 8, 12, (ITextComponent)new StringTextComponent("<"), button -> {
            this.followState = this.recruit.getFollowState();
            if (this.followState != 0) {
                --this.followState;
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageFollowGui(this.followState, this.recruit.func_110124_au()));
            }
        }));
        this.func_230480_a_((Widget)new Button(this.field_147003_i + 77 + 85, this.field_147009_r + 74, 8, 12, (ITextComponent)new StringTextComponent(">"), button -> {
            this.followState = this.recruit.getFollowState();
            if (this.followState != 2) {
                ++this.followState;
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageFollowGui(this.followState, this.recruit.func_110124_au()));
            }
        }));
        this.func_230480_a_((Widget)new Button(this.field_147003_i + 77, this.field_147009_r + 87, 8, 12, (ITextComponent)new StringTextComponent("<"), button -> {
            this.aggroState = this.recruit.getState();
            if (this.aggroState != 0) {
                --this.aggroState;
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageAggroGui(this.aggroState, this.recruit.func_110124_au()));
            }
        }));
        this.func_230480_a_((Widget)new Button(this.field_147003_i + 77 + 85, this.field_147009_r + 87, 8, 12, (ITextComponent)new StringTextComponent(">"), button -> {
            this.aggroState = this.recruit.getState();
            if (this.aggroState != 2) {
                ++this.aggroState;
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageAggroGui(this.aggroState, this.recruit.func_110124_au()));
            }
        }));
        this.func_230480_a_((Widget)new Button(this.field_147003_i + 77, this.field_147009_r + 113, 8, 12, (ITextComponent)new StringTextComponent("<"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageListen(!this.recruit.getListen(), this.recruit.func_110124_au()))));
        this.func_230480_a_((Widget)new Button(this.field_147003_i + 77 + 85, this.field_147009_r + 113, 8, 12, (ITextComponent)new StringTextComponent(">"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageListen(!this.recruit.getListen(), this.recruit.func_110124_au()))));
        this.func_230480_a_((Widget)new Button(this.field_147003_i + 77, this.field_147009_r + 100, 8, 12, (ITextComponent)new StringTextComponent("<"), button -> {
            this.group = this.recruit.getGroup();
            if (this.group != 0) {
                --this.group;
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageGroup(this.group, this.recruit.func_110124_au()));
            }
        }));
        this.func_230480_a_((Widget)new Button(this.field_147003_i + 77 + 85, this.field_147009_r + 100, 8, 12, (ITextComponent)new StringTextComponent(">"), button -> {
            this.group = this.recruit.getGroup();
            if (this.group != 9) {
                ++this.group;
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageGroup(this.group, this.recruit.func_110124_au()));
            }
        }));
        this.func_230480_a_((Widget)new Button(this.field_147003_i + 77 + 85, this.field_147009_r + 4, 8, 12, (ITextComponent)new StringTextComponent("x"), button -> {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDisband(this.recruit.func_110124_au()));
            this.func_231175_as__();
        }));
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        String aggro;
        String follow;
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        int health = MathHelper.func_76123_f((float)this.recruit.func_110143_aJ());
        int k = 79;
        int l = 19;
        this.field_230712_o_.func_238422_b_(matrixStack, this.recruit.func_145748_c_().func_241878_f(), 8.0f, 5.0f, 0x404040);
        this.field_230712_o_.func_238422_b_(matrixStack, this.playerInventory.func_145748_c_().func_241878_f(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, "Hp:", (float)k, (float)l, 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, "" + health, (float)(k + 25), (float)l, 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, "Lvl:", (float)k, (float)(l + 10), 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, "" + this.recruit.getXpLevel(), (float)(k + 25), (float)(l + 10), 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, "Exp:", (float)k, (float)(l + 20), 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, "" + this.recruit.getXp(), (float)(k + 25), (float)(l + 20), 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, "Kills:", (float)k, (float)(l + 30), 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, "" + this.recruit.getKills(), (float)(k + 25), (float)(l + 30), 0x404040);
        switch (this.recruit.getFollowState()) {
            default: {
                follow = "Wandering";
                break;
            }
            case 1: {
                follow = "Following";
                break;
            }
            case 2: {
                follow = "Holding Pos.";
            }
        }
        this.field_230712_o_.func_238421_b_(matrixStack, follow, (float)(k + 15), (float)(l + 58 + 0), 0x404040);
        switch (this.recruit.getState()) {
            default: {
                aggro = "Neutral";
                break;
            }
            case 1: {
                aggro = "Aggressive";
                break;
            }
            case 2: {
                aggro = "Raid";
            }
        }
        this.field_230712_o_.func_238421_b_(matrixStack, aggro, (float)(k + 15), (float)(l + 56 + 15), 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, CommandScreen.handleGroupText(this.recruit.getGroup()), (float)(k + 15), (float)(l + 56 + 28), 0x404040);
        String listen = this.recruit.getListen() ? "Listening" : "Ignoring";
        this.field_230712_o_.func_238421_b_(matrixStack, listen, (float)(k + 15), (float)(l + 56 + 41), 0x404040);
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = (this.field_230708_k_ - this.field_146999_f) / 2;
        int j = (this.field_230709_l_ - this.field_147000_g) / 2;
        InventoryScreen.func_228187_a_((int)(i + 50), (int)(j + 82), (int)30, (float)((float)(i + 50) - (float)mouseX), (float)((float)(j + 75 - 50) - (float)mouseY), (LivingEntity)this.recruit);
    }
}

