/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;

public class RecruitsBipedRenderer<E extends CreatureEntity, M extends BipedModel<E>>
extends BipedRenderer<E, M> {
    public static final float PLAYER_SCALE = 0.9375f;
    protected static final float BIPED_SHADOW_SIZE = 0.5f;

    public RecruitsBipedRenderer(EntityRendererManager manager, M model, M leggingsModel, M mainArmorModel, float shadowSize) {
        super(manager, model, shadowSize);
        this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, leggingsModel, mainArmorModel));
    }

    public void render(E entity, float yaw, float partialTicks, MatrixStack matStack, IRenderTypeBuffer buf, int packedLight) {
        this.setArmPoses(entity);
        super.func_225623_a_(entity, yaw, partialTicks, matStack, buf, packedLight);
    }

    private void setArmPoses(E entity) {
        BipedModel.ArmPose mainArmPose = RecruitsBipedRenderer.getArmPose(entity, Hand.MAIN_HAND);
        BipedModel.ArmPose offArmPose = RecruitsBipedRenderer.getArmPose(entity, Hand.OFF_HAND);
        if (mainArmPose.func_241657_a_()) {
            BipedModel.ArmPose armPose = offArmPose = entity.func_184592_cb().func_190926_b() ? BipedModel.ArmPose.EMPTY : BipedModel.ArmPose.ITEM;
        }
        if (entity.func_184591_cq() == HandSide.RIGHT) {
            ((BipedModel)this.field_77045_g).field_187076_m = mainArmPose;
            ((BipedModel)this.field_77045_g).field_187075_l = offArmPose;
        } else {
            ((BipedModel)this.field_77045_g).field_187076_m = offArmPose;
            ((BipedModel)this.field_77045_g).field_187075_l = mainArmPose;
        }
    }

    private static BipedModel.ArmPose getArmPose(LivingEntity entity, Hand hand) {
        ItemStack heldItem = entity.func_184586_b(hand);
        if (heldItem.func_190926_b()) {
            return BipedModel.ArmPose.EMPTY;
        }
        if (entity.func_184600_cs() == hand && entity.func_184612_cw() > 0) {
            UseAction useaction = heldItem.func_77975_n();
            if (useaction == UseAction.BLOCK) {
                return BipedModel.ArmPose.BLOCK;
            }
            if (useaction == UseAction.BOW) {
                return BipedModel.ArmPose.BOW_AND_ARROW;
            }
            if (useaction == UseAction.SPEAR) {
                return BipedModel.ArmPose.THROW_SPEAR;
            }
            if (useaction == UseAction.CROSSBOW && hand == entity.func_184600_cs()) {
                return BipedModel.ArmPose.CROSSBOW_CHARGE;
            }
        } else if (!entity.func_184587_cr() && heldItem.func_77973_b() == Items.field_222114_py && CrossbowItem.func_220012_d((ItemStack)heldItem)) {
            return BipedModel.ArmPose.CROSSBOW_HOLD;
        }
        return BipedModel.ArmPose.ITEM;
    }
}

