/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityEquipmentPacket;
import net.minecraft.network.play.server.SEntityStatusPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class AbstractInventoryEntity
extends TameableEntity {
    public Inventory inventory;
    private LazyOptional<?> itemHandler = null;
    private final NonNullList<ItemStack> lastHandItemStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private final NonNullList<ItemStack> lastArmorItemStacks = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);

    public AbstractInventoryEntity(EntityType<? extends TameableEntity> entityType, World world) {
        super(entityType, world);
        this.createInventory();
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.recDetectEquipmentUpdates();
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        ListNBT listnbt = new ListNBT();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.inventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(compoundnbt);
            listnbt.add((Object)compoundnbt);
        }
        nbt.func_218657_a("Items", (INBT)listnbt);
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        ListNBT listnbt = nbt.func_150295_c("Items", 10);
        this.createInventory();
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            int j = compoundnbt.func_74771_c("Slot") & 0xFF;
            if (j >= this.inventory.func_70302_i_()) continue;
            this.inventory.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)compoundnbt));
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int getInventorySize() {
        return 15;
    }

    public int getInventoryColumns() {
        return 3;
    }

    public boolean func_174820_d(int id, ItemStack itemStack) {
        super.func_174820_d(id, itemStack);
        return true;
    }

    protected void createInventory() {
        Inventory inventory = this.inventory;
        this.inventory = new Inventory(this.getInventorySize());
        if (inventory != null) {
            int i = Math.min(inventory.func_70302_i_(), this.inventory.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventory.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.inventory.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((IInventory)this.inventory));
    }

    public void func_70645_a(DamageSource dmg) {
        super.func_70645_a(dmg);
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            InventoryHelper.func_180173_a((World)this.field_70170_p, (double)this.func_226277_ct_(), (double)this.func_226278_cu_(), (double)this.func_226281_cx_(), (ItemStack)this.inventory.func_70301_a(i));
        }
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        if (this.func_230293_i_(itemstack)) {
            Inventory inventory = this.inventory;
            boolean flag = inventory.func_233541_b_(itemstack);
            if (!flag) {
                return;
            }
            this.checkItemsInInv();
            this.func_233630_a_(itemEntity);
            this.func_71001_a((Entity)itemEntity, itemstack.func_190916_E());
            ItemStack itemstack1 = inventory.func_174894_a(itemstack);
            if (itemstack1.func_190926_b()) {
                itemEntity.func_70106_y();
            } else {
                itemstack.func_190920_e(itemstack1.func_190916_E());
            }
        }
    }

    public abstract void checkItemsInInv();

    public abstract boolean func_230293_i_(ItemStack var1);

    public abstract Predicate<ItemEntity> getAllowedItems();

    public abstract void openGUI(PlayerEntity var1);

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public void recDetectEquipmentUpdates() {
        Map<EquipmentSlotType, ItemStack> map = this.collectEquipmentChanges();
        if (map != null) {
            this.handleHandSwap(map);
            if (!map.isEmpty()) {
                this.handleEquipmentChanges(map);
            }
        }
    }

    private void handleHandSwap(Map<EquipmentSlotType, ItemStack> p_241342_1_) {
        ItemStack itemstack = p_241342_1_.get(EquipmentSlotType.MAINHAND);
        ItemStack itemstack1 = p_241342_1_.get(EquipmentSlotType.OFFHAND);
        if (itemstack != null && itemstack1 != null && ItemStack.func_77989_b((ItemStack)itemstack, (ItemStack)this.getLastHandItem(EquipmentSlotType.OFFHAND)) && ItemStack.func_77989_b((ItemStack)itemstack1, (ItemStack)this.getLastHandItem(EquipmentSlotType.MAINHAND))) {
            ((ServerWorld)this.field_70170_p).func_72863_F().func_217218_b((Entity)this, (IPacket)new SEntityStatusPacket((Entity)this, 55));
            p_241342_1_.remove(EquipmentSlotType.MAINHAND);
            p_241342_1_.remove(EquipmentSlotType.OFFHAND);
            this.setLastHandItem(EquipmentSlotType.MAINHAND, itemstack.func_77946_l());
            this.setLastHandItem(EquipmentSlotType.OFFHAND, itemstack1.func_77946_l());
        }
    }

    @Nullable
    private Map<EquipmentSlotType, ItemStack> collectEquipmentChanges() {
        EnumMap map = null;
        block4: for (EquipmentSlotType equipmentslottype : EquipmentSlotType.values()) {
            ItemStack itemstack;
            switch (equipmentslottype.func_188453_a()) {
                case HAND: {
                    itemstack = this.getLastHandItem(equipmentslottype);
                    break;
                }
                case ARMOR: {
                    itemstack = this.getLastArmorItem(equipmentslottype);
                    break;
                }
                default: {
                    continue block4;
                }
            }
            ItemStack itemstack1 = this.func_184582_a(equipmentslottype);
            if (ItemStack.func_77989_b((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            MinecraftForge.EVENT_BUS.post((Event)new LivingEquipmentChangeEvent((LivingEntity)this, equipmentslottype, itemstack, itemstack1));
            if (map == null) {
                map = Maps.newEnumMap(EquipmentSlotType.class);
            }
            map.put(equipmentslottype, itemstack1);
            if (!itemstack.func_190926_b()) {
                this.func_233645_dx_().func_233785_a_(itemstack.func_111283_C(equipmentslottype));
            }
            if (itemstack1.func_190926_b()) continue;
            this.func_233645_dx_().func_233793_b_(itemstack1.func_111283_C(equipmentslottype));
        }
        return map;
    }

    private void handleEquipmentChanges(Map<EquipmentSlotType, ItemStack> p_241344_1_) {
        ArrayList list = Lists.newArrayListWithCapacity((int)p_241344_1_.size());
        p_241344_1_.forEach((p_241341_2_, p_241341_3_) -> {
            ItemStack itemstack = p_241341_3_.func_77946_l();
            list.add(Pair.of((Object)p_241341_2_, (Object)itemstack));
            switch (p_241341_2_.func_188453_a()) {
                case HAND: {
                    this.setLastHandItem((EquipmentSlotType)p_241341_2_, itemstack);
                    break;
                }
                case ARMOR: {
                    this.setLastArmorItem((EquipmentSlotType)p_241341_2_, itemstack);
                }
            }
        });
        ((ServerWorld)this.field_70170_p).func_72863_F().func_217218_b((Entity)this, (IPacket)new SEntityEquipmentPacket(this.func_145782_y(), (List)list));
    }

    private ItemStack getLastHandItem(EquipmentSlotType p_241347_1_) {
        return (ItemStack)this.lastHandItemStacks.get(p_241347_1_.func_188454_b());
    }

    private void setLastHandItem(EquipmentSlotType p_241345_1_, ItemStack p_241345_2_) {
        this.lastHandItemStacks.set(p_241345_1_.func_188454_b(), (Object)p_241345_2_);
    }

    private ItemStack getLastArmorItem(EquipmentSlotType p_241346_1_) {
        return (ItemStack)this.lastArmorItemStacks.get(p_241346_1_.func_188454_b());
    }

    private void setLastArmorItem(EquipmentSlotType p_241343_1_, ItemStack p_241343_2_) {
        this.lastArmorItemStacks.set(p_241343_1_.func_188454_b(), (Object)p_241343_2_);
    }
}

