/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.config.RecruitsModConfig;
import com.talhanation.recruits.entities.AbstractInventoryEntity;
import com.talhanation.recruits.entities.ai.RecruitAggresiveNearestAttackableTargetGoal;
import com.talhanation.recruits.entities.ai.RecruitDefendVillageGoal;
import com.talhanation.recruits.entities.ai.RecruitEatGoal;
import com.talhanation.recruits.entities.ai.RecruitFleeTNT;
import com.talhanation.recruits.entities.ai.RecruitFollowOwnerGoal;
import com.talhanation.recruits.entities.ai.RecruitHoldPosGoal;
import com.talhanation.recruits.entities.ai.RecruitHurtByTargetGoal;
import com.talhanation.recruits.entities.ai.RecruitMeleeAttackGoal;
import com.talhanation.recruits.entities.ai.RecruitMoveToPosGoal;
import com.talhanation.recruits.entities.ai.RecruitMoveTowardsTargetGoal;
import com.talhanation.recruits.entities.ai.RecruitPickupWantedItemGoal;
import com.talhanation.recruits.entities.ai.RecruitQuaffGoal;
import com.talhanation.recruits.entities.ai.RecruitRaidNearestAttackableTargetGoal;
import com.talhanation.recruits.inventory.RecruitInventoryContainer;
import com.talhanation.recruits.network.MessageRecruitGui;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.PatrolVillageGoal;
import net.minecraft.entity.ai.goal.ReturnToVillageGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShieldItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class AbstractRecruitEntity
extends AbstractInventoryEntity {
    private static final DataParameter<Integer> DATA_REMAINING_ANGER_TIME = EntityDataManager.func_187226_a(AbstractRecruitEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(AbstractRecruitEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FOLLOW_STATE = EntityDataManager.func_187226_a(AbstractRecruitEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SHOULD_FOLLOW = EntityDataManager.func_187226_a(AbstractRecruitEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SHOULD_HOLD_POS = EntityDataManager.func_187226_a(AbstractRecruitEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Optional<BlockPos>> HOLD_POS = EntityDataManager.func_187226_a(AbstractRecruitEntity.class, (IDataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Optional<BlockPos>> MOVE_POS = EntityDataManager.func_187226_a(AbstractRecruitEntity.class, (IDataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Boolean> MOVE = EntityDataManager.func_187226_a(AbstractRecruitEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> LISTEN = EntityDataManager.func_187226_a(AbstractRecruitEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> isFollowing = EntityDataManager.func_187226_a(AbstractRecruitEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Optional<UUID>> MOUNT = EntityDataManager.func_187226_a(AbstractRecruitEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Integer> GROUP = EntityDataManager.func_187226_a(AbstractRecruitEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> XP = EntityDataManager.func_187226_a(AbstractRecruitEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(AbstractRecruitEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> KILLS = EntityDataManager.func_187226_a(AbstractRecruitEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> isEating = EntityDataManager.func_187226_a(AbstractRecruitEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FLEEING = EntityDataManager.func_187226_a(AbstractRecruitEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public ItemStack beforeFoodItem;

    public AbstractRecruitEntity(EntityType<? extends TameableEntity> entityType, World world) {
        super(entityType, world);
        this.setOwned(false);
        this.field_70728_aV = 6;
    }

    public double func_70033_W() {
        return -0.35;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
    }

    private void resetItemInHand() {
        this.func_184611_a(Hand.OFF_HAND, this.beforeFoodItem);
        this.func_174820_d(10, this.beforeFoodItem);
        this.beforeFoodItem = null;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_82168_bl();
        this.func_205343_av();
        if (this.getIsEating() && !this.func_184587_cr()) {
            if (this.beforeFoodItem != null) {
                this.resetItemInHand();
            }
            this.setIsEating(false);
        }
    }

    public void func_70098_U() {
        super.func_70098_U();
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance diff, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT nbt) {
        this.setRandomSpawnBonus();
        return spawnData;
    }

    public void setRandomSpawnBonus() {
        this.func_110148_a(Attributes.field_233818_a_).func_233769_c_(new AttributeModifier("heath_bonus", this.field_70146_Z.nextGaussian() * 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
        this.func_110148_a(Attributes.field_233823_f_).func_233769_c_(new AttributeModifier("attack_bonus", this.field_70146_Z.nextGaussian() * 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
        this.func_110148_a(Attributes.field_233820_c_).func_233769_c_(new AttributeModifier("knockback_bonus", this.field_70146_Z.nextGaussian() * 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
        this.func_110148_a(Attributes.field_233821_d_).func_233769_c_(new AttributeModifier("speed_bonus", this.field_70146_Z.nextGaussian() * 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
    }

    public void setDropEquipment() {
        this.func_213337_cE();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new RecruitQuaffGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new RecruitFleeTNT(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new RecruitEatGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new RecruitMoveToPosGoal(this, 1.2, 32.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new RecruitFollowOwnerGoal(this, 1.2, 9.0f, 3.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new RecruitMeleeAttackGoal(this, 1.15, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new RecruitHoldPosGoal(this, 1.0, 32.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new RecruitMoveTowardsTargetGoal(this, 1.15, 24.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new RecruitPickupWantedItemGoal(this));
        this.field_70714_bg.func_75776_a(9, (Goal)new ReturnToVillageGoal((CreatureEntity)this, 0.6, false));
        this.field_70714_bg.func_75776_a(10, (Goal)new PatrolVillageGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(10, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(12, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, new RecruitRaidNearestAttackableTargetGoal<LivingEntity>(this, LivingEntity.class, false));
        this.field_70715_bh.func_75776_a(2, new RecruitAggresiveNearestAttackableTargetGoal<PlayerEntity>(this, PlayerEntity.class, false));
        this.field_70715_bh.func_75776_a(0, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new RecruitHurtByTargetGoal(this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractIllagerEntity.class, false));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MonsterEntity.class, false));
        this.field_70715_bh.func_75776_a(10, (Goal)new RecruitDefendVillageGoal(this));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_REMAINING_ANGER_TIME, (Object)0);
        this.field_70180_af.func_187214_a(GROUP, (Object)0);
        this.field_70180_af.func_187214_a(SHOULD_FOLLOW, (Object)false);
        this.field_70180_af.func_187214_a(SHOULD_HOLD_POS, (Object)false);
        this.field_70180_af.func_187214_a(FLEEING, (Object)false);
        this.field_70180_af.func_187214_a(STATE, (Object)0);
        this.field_70180_af.func_187214_a(XP, (Object)0);
        this.field_70180_af.func_187214_a(KILLS, (Object)0);
        this.field_70180_af.func_187214_a(LEVEL, (Object)1);
        this.field_70180_af.func_187214_a(FOLLOW_STATE, (Object)0);
        this.field_70180_af.func_187214_a(HOLD_POS, Optional.empty());
        this.field_70180_af.func_187214_a(MOVE_POS, Optional.empty());
        this.field_70180_af.func_187214_a(MOVE, (Object)true);
        this.field_70180_af.func_187214_a(LISTEN, (Object)true);
        this.field_70180_af.func_187214_a(MOUNT, Optional.empty());
        this.field_70180_af.func_187214_a(isFollowing, (Object)false);
        this.field_70180_af.func_187214_a(isEating, (Object)true);
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("AggroState", this.getState());
        nbt.func_74757_a("ShouldFollow", this.getShouldFollow());
        nbt.func_74768_a("Group", this.getGroup());
        nbt.func_74757_a("Listen", this.getListen());
        nbt.func_74757_a("Fleeing", this.getFleeing());
        nbt.func_74757_a("isFollowing", this.isFollowing());
        nbt.func_74757_a("isEating", this.getIsEating());
        nbt.func_74768_a("Xp", this.getXp());
        nbt.func_74768_a("Level", this.getXpLevel());
        nbt.func_74768_a("Kills", this.getKills());
        if (this.getHoldPos() != null) {
            nbt.func_74768_a("HoldPosX", this.getHoldPos().func_177958_n());
            nbt.func_74768_a("HoldPosY", this.getHoldPos().func_177956_o());
            nbt.func_74768_a("HoldPosZ", this.getHoldPos().func_177952_p());
            nbt.func_74757_a("ShouldHoldPos", this.getShouldHoldPos());
        }
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setState(nbt.func_74762_e("AggroState"));
        this.setShouldFollow(nbt.func_74767_n("ShouldFollow"));
        this.setFleeing(nbt.func_74767_n("Fleeing"));
        this.setGroup(nbt.func_74762_e("Group"));
        this.setListen(nbt.func_74767_n("Listen"));
        this.setIsFollowing(nbt.func_74767_n("isFollowing"));
        this.setIsEating(nbt.func_74767_n("isEating"));
        this.setXp(nbt.func_74762_e("Xp"));
        this.setXpLevel(nbt.func_74762_e("XpLevel"));
        this.setKills(nbt.func_74762_e("Kills"));
        if (nbt.func_74764_b("HoldPosX") && nbt.func_74764_b("HoldPosY") && nbt.func_74764_b("HoldPosZ")) {
            this.setShouldHoldPos(nbt.func_74767_n("ShouldHoldPos"));
            this.setHoldPos(new BlockPos(nbt.func_74762_e("HoldPosX"), nbt.func_74762_e("HoldPosY"), nbt.func_74762_e("HoldPosZ")));
        }
    }

    public boolean getFleeing() {
        return (Boolean)this.field_70180_af.func_187225_a(FLEEING);
    }

    public int getKills() {
        return (Integer)this.field_70180_af.func_187225_a(KILLS);
    }

    public int getXpLevel() {
        return (Integer)this.field_70180_af.func_187225_a(LEVEL);
    }

    public int getXp() {
        return (Integer)this.field_70180_af.func_187225_a(XP);
    }

    public boolean getIsEating() {
        return (Boolean)this.field_70180_af.func_187225_a(isEating);
    }

    public boolean getShouldHoldPos() {
        return (Boolean)this.field_70180_af.func_187225_a(SHOULD_HOLD_POS);
    }

    public boolean getShouldFollow() {
        return (Boolean)this.field_70180_af.func_187225_a(SHOULD_FOLLOW);
    }

    public boolean isFollowing() {
        return (Boolean)this.field_70180_af.func_187225_a(isFollowing);
    }

    public int getState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public int getGroup() {
        return (Integer)this.field_70180_af.func_187225_a(GROUP);
    }

    public int getFollowState() {
        return (Integer)this.field_70180_af.func_187225_a(FOLLOW_STATE);
    }

    public SoundEvent func_184601_bQ(DamageSource ds) {
        if (this.func_184585_cz()) {
            return SoundEvents.field_187767_eL;
        }
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected float func_213348_b(Pose pos, EntitySize size) {
        return size.field_220316_b * 0.9f;
    }

    public int func_70646_bf() {
        return this.func_233684_eK_() ? 20 : super.func_70646_bf();
    }

    public int func_70641_bl() {
        return 8;
    }

    public BlockPos getHoldPos() {
        return ((Optional)this.field_70180_af.func_187225_a(HOLD_POS)).orElse(null);
    }

    @Nullable
    public BlockPos getMovePos() {
        return ((Optional)this.field_70180_af.func_187225_a(MOVE_POS)).orElse(null);
    }

    public boolean getMove() {
        return (Boolean)this.field_70180_af.func_187225_a(MOVE);
    }

    public boolean getListen() {
        return (Boolean)this.field_70180_af.func_187225_a(LISTEN);
    }

    @Nullable
    public UUID getMount() {
        return ((Optional)this.field_70180_af.func_187225_a(MOUNT)).orElse(null);
    }

    public void setFleeing(boolean bool) {
        this.field_70180_af.func_187227_b(FLEEING, (Object)bool);
    }

    public void disband() {
        this.func_70902_q().func_145747_a((ITextComponent)new StringTextComponent(this.func_200200_C_().getString() + ": Then this is where we part ways."), this.func_70902_q().func_110124_au());
        this.func_70903_f(false);
        this.func_70624_b(null);
        this.setOwned(false);
        this.func_184754_b(null);
    }

    public void addXpLevel(int level) {
        int currentLevel = this.getXpLevel();
        int newLevel = currentLevel + level;
        this.makelevelUpSound();
        this.field_70180_af.func_187227_b(LEVEL, (Object)newLevel);
    }

    public void setKills(int kills) {
        this.field_70180_af.func_187227_b(KILLS, (Object)kills);
    }

    public void setXpLevel(int XpLevel) {
        this.field_70180_af.func_187227_b(LEVEL, (Object)XpLevel);
    }

    public void setXp(int xp) {
        this.field_70180_af.func_187227_b(XP, (Object)xp);
    }

    public void addXp(int xp) {
        int currentXp = this.getXp();
        int newXp = currentXp + xp;
        this.field_70180_af.func_187227_b(XP, (Object)newXp);
    }

    public void setIsEating(boolean bool) {
        this.field_70180_af.func_187227_b(isEating, (Object)bool);
    }

    public void setShouldHoldPos(boolean bool) {
        this.field_70180_af.func_187227_b(SHOULD_HOLD_POS, (Object)bool);
    }

    public void setShouldFollow(boolean bool) {
        this.field_70180_af.func_187227_b(SHOULD_FOLLOW, (Object)bool);
    }

    public void setIsFollowing(boolean bool) {
        this.field_70180_af.func_187227_b(isFollowing, (Object)bool);
    }

    public void setGroup(int group) {
        this.field_70180_af.func_187227_b(GROUP, (Object)group);
    }

    public void setState(int state) {
        switch (state) {
            case 0: {
                this.func_70624_b(null);
                break;
            }
            case 1: {
                break;
            }
        }
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    public void setFollowState(int state) {
        switch (state) {
            case 0: {
                this.setShouldFollow(false);
                this.setShouldHoldPos(false);
                break;
            }
            case 1: {
                this.setShouldFollow(true);
                this.setShouldHoldPos(false);
                break;
            }
            case 2: {
                this.setShouldFollow(false);
                this.setShouldHoldPos(true);
                this.clearHoldPos();
                this.setHoldPos(this.func_226268_ag_());
                break;
            }
            case 3: {
                this.setShouldFollow(false);
                this.setShouldHoldPos(true);
            }
        }
        this.field_70180_af.func_187227_b(FOLLOW_STATE, (Object)state);
    }

    public void setHoldPos(BlockPos holdPos) {
        this.field_70180_af.func_187227_b(HOLD_POS, Optional.of(holdPos));
    }

    public void clearHoldPos() {
        this.field_70180_af.func_187227_b(HOLD_POS, Optional.empty());
    }

    public void setMovePos(BlockPos holdPos) {
        this.field_70180_af.func_187227_b(MOVE_POS, Optional.of(holdPos));
    }

    public void clearMovePos() {
        this.field_70180_af.func_187227_b(MOVE_POS, Optional.empty());
    }

    public void setMove(boolean bool) {
        this.field_70180_af.func_187227_b(MOVE, (Object)bool);
    }

    public void setListen(boolean bool) {
        this.field_70180_af.func_187227_b(LISTEN, (Object)bool);
    }

    public void setOwned(boolean owned) {
        super.func_70903_f(owned);
    }

    public void setEquipment() {
    }

    public void setMount(UUID uuid) {
        this.field_70180_af.func_187227_b(MOUNT, Optional.of(uuid));
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (this.field_70170_p.field_72995_K) {
            boolean flag = this.func_152114_e((LivingEntity)player) || this.func_70909_n() || this.func_233684_eK_() || item == Items.field_151103_aS && !this.func_70909_n();
            return flag ? ActionResultType.CONSUME : ActionResultType.PASS;
        }
        if (player.func_184812_l_() && player.func_184586_b(Hand.MAIN_HAND).func_77973_b().equals(Items.field_221746_ci)) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.3);
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(1.3);
            this.func_110148_a(Attributes.field_233820_c_).func_111128_a(0.1);
            player.func_145747_a((ITextComponent)new StringTextComponent(this.func_200200_C_().getString() + ": Stats were reseted!"), player.func_110124_au());
            return ActionResultType.SUCCESS;
        }
        if (this.func_70909_n() && player.func_110124_au().equals(this.func_184753_b())) {
            if (player.func_213453_ef()) {
                this.checkItemsInInv();
                this.openGUI(player);
                return ActionResultType.SUCCESS;
            }
            if (!player.func_213453_ef()) {
                int state = this.getFollowState();
                switch (state) {
                    case 0: {
                        this.setFollowState(1);
                        player.func_145747_a((ITextComponent)new StringTextComponent(this.func_200200_C_().getString() + ": I will follow you"), player.func_110124_au());
                        break;
                    }
                    case 1: {
                        this.setFollowState(2);
                        player.func_145747_a((ITextComponent)new StringTextComponent(this.func_200200_C_().getString() + ": I will hold this Position"), player.func_110124_au());
                        break;
                    }
                    case 2: {
                        this.setFollowState(0);
                        player.func_145747_a((ITextComponent)new StringTextComponent(this.func_200200_C_().getString() + ": I will stay here around"), player.func_110124_au());
                    }
                }
                return ActionResultType.SUCCESS;
            }
        } else {
            if (item == Items.field_151166_bC && !this.func_70909_n() && this.playerHasEnoughEmeralds(player)) {
                if (!player.field_71075_bZ.field_75098_d && !player.func_184812_l_()) {
                    itemstack.func_190918_g(this.recruitCosts());
                }
                this.func_193101_c(player);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.func_233687_w_(false);
                this.setFollowState(1);
                this.setState(0);
                return ActionResultType.SUCCESS;
            }
            if (item == Items.field_151166_bC && !this.func_70909_n() && !this.playerHasEnoughEmeralds(player)) {
                player.func_145747_a((ITextComponent)new StringTextComponent(this.func_200200_C_().getString() + ": You need " + this.recruitCosts() + " Emeralds to recruit me!"), player.func_110124_au());
            } else if (!this.func_70909_n() && item != Items.field_151166_bC) {
                int i = this.field_70146_Z.nextInt(5);
                switch (i) {
                    case 0: {
                        player.func_145747_a((ITextComponent)new StringTextComponent(this.func_200200_C_().getString() + ":  Hello my Friend."), player.func_110124_au());
                        break;
                    }
                    case 1: {
                        player.func_145747_a((ITextComponent)new StringTextComponent(this.func_200200_C_().getString() + ": It's a honor for me to protect you."), player.func_110124_au());
                        break;
                    }
                    default: {
                        player.func_145747_a((ITextComponent)new StringTextComponent(this.func_200200_C_().getString() + ": I will defend you from Monsters!"), player.func_110124_au());
                    }
                }
            }
        }
        return super.func_230254_b_(player, hand);
    }

    private boolean playerHasEnoughEmeralds(PlayerEntity player) {
        int recruitCosts = this.recruitCosts();
        int emeraldCount = player.func_184586_b(Hand.MAIN_HAND).func_190916_E();
        if (emeraldCount >= recruitCosts) {
            return true;
        }
        return player.func_184812_l_();
    }

    public boolean func_70097_a(DamageSource dmg, float amt) {
        if (this.func_180431_b(dmg)) {
            return false;
        }
        Entity entity = dmg.func_76346_g();
        this.func_233687_w_(false);
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amt = (amt + 1.0f) / 2.0f;
        }
        this.addXp(1);
        this.checkLevel();
        return super.func_70097_a(dmg, amt);
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_233637_b_(Attributes.field_233823_f_)));
        if (flag) {
            this.func_174815_a((LivingEntity)this, entity);
        }
        this.addXp(2);
        this.checkLevel();
        this.damageMainHandItem();
        return flag;
    }

    public void addLevelBuffs() {
        int level = this.getXpLevel();
        if (level <= 10) {
            this.func_110148_a(Attributes.field_233818_a_).func_233769_c_(new AttributeModifier("heath_bonus_level", 2.0, AttributeModifier.Operation.ADDITION));
            this.func_110148_a(Attributes.field_233823_f_).func_233769_c_(new AttributeModifier("attack_bonus_level", 0.25, AttributeModifier.Operation.ADDITION));
            this.func_110148_a(Attributes.field_233820_c_).func_233769_c_(new AttributeModifier("knockback_bonus_level", 0.01, AttributeModifier.Operation.ADDITION));
            this.func_110148_a(Attributes.field_233821_d_).func_233769_c_(new AttributeModifier("speed_bonus_level", 0.01, AttributeModifier.Operation.ADDITION));
        }
        if (level > 10) {
            this.func_110148_a(Attributes.field_233818_a_).func_233769_c_(new AttributeModifier("heath_bonus_level", 1.0, AttributeModifier.Operation.ADDITION));
        }
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof CreeperEntity) && !(target instanceof GhastEntity)) {
            if (target instanceof AbstractRecruitEntity) {
                AbstractRecruitEntity otherRecruit = (AbstractRecruitEntity)target;
                return otherRecruit.func_70902_q() != owner;
            }
            if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            if (target instanceof AbstractHorseEntity && ((AbstractHorseEntity)target).func_110248_bS()) {
                return false;
            }
            return !(target instanceof TameableEntity) || !((TameableEntity)target).func_70909_n();
        }
        return false;
    }

    @Override
    public void func_70645_a(DamageSource dmg) {
        super.func_70645_a(dmg);
    }

    @Override
    public void checkItemsInInv() {
    }

    public void checkLevel() {
        int currentXp = this.getXp();
        if (currentXp >= (Integer)RecruitsModConfig.RecruitsMaxXpForLevelUp.get()) {
            this.addXpLevel(1);
            this.setXp(0);
            this.addLevelBuffs();
            this.func_70691_i(10.0f);
        }
    }

    public void makelevelUpSound() {
        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_() + 4.0, this.func_226281_cx_(), SoundEvents.field_187915_go, this.func_184176_by(), 15.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat());
        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_() + 4.0, this.func_226281_cx_(), SoundEvents.field_187802_ec, this.func_184176_by(), 15.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat());
    }

    public boolean isOwnedByThisPlayer(AbstractRecruitEntity recruit, PlayerEntity player) {
        return recruit.func_184753_b() == player.func_110124_au();
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public abstract int recruitCosts();

    public abstract String getRecruitName();

    @OnlyIn(value=Dist.CLIENT)
    protected void func_70908_e(boolean p_70908_1_) {
        BasicParticleType iparticledata = ParticleTypes.field_197632_y;
        if (!p_70908_1_) {
            iparticledata = ParticleTypes.field_197601_L;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)iparticledata, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
        }
    }

    protected void func_230294_b_(DamageSource damageSource, float damage) {
        if (damage >= 0.0f) {
            if ((damage /= 4.0f) < 1.0f) {
                damage = 1.0f;
            }
            for (int i = 11; i < 15; ++i) {
                ItemStack itemstack = this.inventory.func_70301_a(i);
                if (damageSource.func_76347_k() && itemstack.func_77973_b().func_234687_u_() || !(itemstack.func_77973_b() instanceof ArmorItem)) continue;
                itemstack.func_196085_b((int)damage);
            }
        }
    }

    protected void damageMainHandItem() {
        ItemStack itemstack = this.inventory.func_70301_a(9);
        if (itemstack.func_77973_b().isDamageable(itemstack)) {
            itemstack.func_196085_b(1);
        }
    }

    public void func_241847_a(ServerWorld p_241847_1_, LivingEntity p_241847_2_) {
        super.func_241847_a(p_241847_1_, p_241847_2_);
        this.addXp(2);
        this.setKills(this.getKills() + 1);
    }

    protected void func_184590_k(float damage) {
        if (this.field_184627_bm.isShield((LivingEntity)this)) {
            ItemStack itemstack;
            int i = 1 + MathHelper.func_76141_d((float)damage);
            Hand hand = this.func_184600_cs();
            this.field_184627_bm.func_222118_a(i, (LivingEntity)this, entity -> entity.func_213334_d(hand));
            if (this.field_184627_bm.func_190926_b()) {
                if (hand == Hand.MAIN_HAND) {
                    this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                    this.func_174820_d(9, ItemStack.field_190927_a);
                } else {
                    this.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
                    this.func_174820_d(10, ItemStack.field_190927_a);
                }
                this.field_184627_bm = ItemStack.field_190927_a;
                this.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
                this.func_174820_d(10, ItemStack.field_190927_a);
                this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
            if ((itemstack = this.inventory.func_70301_a(10)).func_77973_b() instanceof ShieldItem) {
                itemstack.func_196085_b((int)damage);
            }
        }
    }

    public static boolean canDamageTarget(AbstractRecruitEntity recruit, LivingEntity target) {
        if (recruit.func_70909_n() && target instanceof AbstractRecruitEntity) {
            return !Objects.equals(recruit.func_184753_b(), ((AbstractRecruitEntity)target).func_184753_b());
        }
        return true;
    }

    @Override
    public void openGUI(PlayerEntity player) {
        this.field_70699_by.func_75499_g();
        if (player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return AbstractRecruitEntity.this.func_200200_C_();
                }

                @Nullable
                public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                    return new RecruitInventoryContainer(i, AbstractRecruitEntity.this, playerInventory);
                }
            }, packetBuffer -> packetBuffer.func_179252_a(this.func_110124_au()));
        } else {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageRecruitGui(player, this.func_110124_au()));
        }
    }
}

