/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai;

import com.talhanation.recruits.entities.AbstractRecruitEntity;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.world.IWorldReader;

public class RecruitFollowOwnerGoal
extends Goal {
    private final AbstractRecruitEntity recruitEntity;
    private LivingEntity owner;
    private final IWorldReader level;
    private final double speedModifier;
    private final PathNavigator navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;

    public RecruitFollowOwnerGoal(AbstractRecruitEntity abstractRecruitEntity, double v, float startDistance, float stopDistance) {
        this.recruitEntity = abstractRecruitEntity;
        this.level = abstractRecruitEntity.field_70170_p;
        this.speedModifier = v;
        this.navigation = abstractRecruitEntity.func_70661_as();
        this.startDistance = startDistance;
        this.stopDistance = stopDistance;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        LivingEntity owner = this.recruitEntity.func_70902_q();
        if (owner == null) {
            return false;
        }
        if (owner.func_175149_v()) {
            return false;
        }
        if (this.recruitEntity.getFleeing()) {
            return false;
        }
        if (!this.recruitEntity.getShouldFollow()) {
            return false;
        }
        if (this.recruitEntity.func_233685_eM_()) {
            return false;
        }
        if (this.recruitEntity.func_70068_e((Entity)owner) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = owner;
        return this.recruitEntity.getShouldFollow();
    }

    public boolean func_75253_b() {
        if (this.navigation.func_75500_f()) {
            return false;
        }
        if (this.recruitEntity.func_233685_eM_()) {
            return false;
        }
        if (!this.recruitEntity.getShouldFollow()) {
            return false;
        }
        return this.recruitEntity.getShouldFollow() && !(this.recruitEntity.func_70068_e((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.recruitEntity.func_184643_a(PathNodeType.WATER);
        this.recruitEntity.func_184644_a(PathNodeType.WATER, 0.0f);
        this.recruitEntity.setIsFollowing(true);
    }

    public void func_75251_c() {
        this.owner = null;
        this.navigation.func_75499_g();
        this.recruitEntity.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
        this.recruitEntity.setIsFollowing(false);
    }

    public void func_75246_d() {
        this.recruitEntity.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.recruitEntity.func_70646_bf());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.recruitEntity.func_110167_bD() && !this.recruitEntity.func_184218_aH()) {
                this.navigation.func_75497_a((Entity)this.owner, this.speedModifier);
            }
        }
    }
}

