/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai;

import com.talhanation.recruits.entities.AbstractRecruitEntity;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;

public class RecruitHurtByTargetGoal
extends HurtByTargetGoal {
    private static final EntityPredicate HURT_BY_TARGETING = new EntityPredicate().func_221014_c().func_221010_e();
    private boolean alertSameType;
    private int timestamp;
    private final Class<?>[] toIgnoreDamage;
    private Class<?>[] toIgnoreAlert;
    private final AbstractRecruitEntity recruit;

    public RecruitHurtByTargetGoal(AbstractRecruitEntity recruit, Class<?> ... classes) {
        super((CreatureEntity)recruit, (Class[])classes);
        this.recruit = recruit;
        this.toIgnoreDamage = classes;
        this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean func_75250_a() {
        AbstractRecruitEntity targetRecruit;
        int i = this.recruit.func_142015_aE();
        LivingEntity livingentity = this.recruit.func_70643_av();
        if (livingentity instanceof AbstractRecruitEntity && Objects.equals((targetRecruit = (AbstractRecruitEntity)livingentity).func_184753_b(), this.recruit.func_184753_b())) {
            return false;
        }
        if (i != this.timestamp && livingentity != null) {
            if (livingentity.func_200600_R() == EntityType.field_200729_aH && this.recruit.field_70170_p.func_82736_K().func_223586_b(GameRules.field_234896_G_)) {
                return false;
            }
            for (Class<?> oclass : this.toIgnoreDamage) {
                if (!oclass.isAssignableFrom(livingentity.getClass())) continue;
                return false;
            }
            return this.func_220777_a(livingentity, HURT_BY_TARGETING);
        }
        return false;
    }

    public HurtByTargetGoal func_220794_a(Class<?> ... p_220794_1_) {
        this.alertSameType = true;
        this.toIgnoreAlert = p_220794_1_;
        return this;
    }

    public void func_75249_e() {
        this.recruit.func_70624_b(this.recruit.func_70643_av());
        this.field_188509_g = this.recruit.func_70638_az();
        this.timestamp = this.recruit.func_142015_aE();
        this.field_188510_h = 300;
        if (this.alertSameType) {
            this.func_190105_f();
        }
        super.func_75249_e();
    }

    protected void func_190105_f() {
        double d0 = this.func_111175_f();
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_241549_a_((Vector3d)this.recruit.func_213303_ch()).func_72314_b(d0, 10.0, d0);
        List list = this.recruit.field_70170_p.func_225317_b(((Object)((Object)this.recruit)).getClass(), axisalignedbb);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MobEntity mobentity = (MobEntity)iterator.next();
            if (this.recruit == mobentity || mobentity.func_70638_az() != null || this.recruit.func_70902_q() != ((TameableEntity)mobentity).func_70902_q() || mobentity.func_184191_r((Entity)this.recruit.func_70643_av())) continue;
            if (this.toIgnoreAlert != null) {
                boolean flag = false;
                for (Class<?> oclass : this.toIgnoreAlert) {
                    if (mobentity.getClass() != oclass) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
            }
            this.func_220793_a(mobentity, this.recruit.func_70643_av());
        }
        return;
    }

    protected void func_220793_a(MobEntity p_220793_1_, LivingEntity p_220793_2_) {
        p_220793_1_.func_70624_b(p_220793_2_);
    }
}

