/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai;

import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.BowmanEntity;
import java.util.EnumSet;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.math.MathHelper;

public class RecruitRangedBowAttackGoal<T extends BowmanEntity>
extends Goal {
    private final T mob;
    private final double speedModifier;
    private int attackIntervalMin;
    private LivingEntity target;
    private final float attackRadiusSqr;
    private int attackTime = -1;
    private int seeTime;
    private final int attackIntervalMax;
    private final float attackRadius;

    public RecruitRangedBowAttackGoal(T mob, double speedModifier, int attackIntervalMin, int attackIntervalMax, float attackRadius) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.attackIntervalMin = attackIntervalMin;
        this.attackIntervalMax = attackIntervalMax;
        this.attackRadiusSqr = attackRadius * attackRadius;
        this.attackRadius = attackRadius;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void setMinAttackInterval(int min) {
        this.attackIntervalMin = min;
    }

    public boolean func_75250_a() {
        LivingEntity livingentity = this.mob.func_70638_az();
        if (livingentity != null && livingentity.func_70089_S() && this.isHoldingBow()) {
            this.target = livingentity;
            return true;
        }
        return false;
    }

    protected boolean isHoldingBow() {
        return this.mob.func_233634_a_(item -> item instanceof BowItem);
    }

    public boolean func_75253_b() {
        return this.func_75250_a() && this.isHoldingBow();
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.mob.func_213395_q(true);
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.mob.func_213395_q(false);
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
        this.mob.func_184602_cy();
    }

    public void func_75246_d() {
        boolean isClose = (double)this.target.func_70032_d(this.mob) <= 7.0;
        boolean isFar = (double)this.target.func_70032_d(this.mob) >= 21.5;
        boolean inRange = !isFar && (double)this.target.func_70032_d(this.mob) <= 15.0;
        boolean canSee = this.mob.func_70635_at().func_75522_a((Entity)this.target);
        this.seeTime = canSee ? ++this.seeTime : 0;
        if (((AbstractRecruitEntity)((Object)this.mob)).getShouldHoldPos()) {
            if (!((AbstractRecruitEntity)((Object)this.mob)).getHoldPos().func_218137_a((IPosition)this.mob.func_213303_ch(), 5.0)) {
                if (inRange) {
                    this.mob.func_70661_as().func_75499_g();
                }
                if (isFar) {
                    this.mob.func_70661_as().func_75497_a((Entity)this.target, this.speedModifier);
                }
                if (isClose) {
                    ((BowmanEntity)((Object)this.mob)).fleeEntity(this.target);
                }
            }
        } else if (((AbstractRecruitEntity)((Object)this.mob)).getShouldFollow() && this.mob.func_70902_q() != null) {
            boolean playerClose;
            boolean bl = playerClose = (double)this.mob.func_70902_q().func_70032_d(this.mob) <= 15.0;
            if (playerClose) {
                if (inRange) {
                    this.mob.func_70661_as().func_75499_g();
                }
                if (isFar) {
                    this.mob.func_70661_as().func_75497_a((Entity)this.target, this.speedModifier);
                }
                if (isClose) {
                    ((BowmanEntity)((Object)this.mob)).fleeEntity(this.target);
                }
            }
            if (!playerClose) {
                this.mob.func_70661_as().func_75497_a((Entity)this.mob.func_70902_q(), this.speedModifier);
            }
        } else {
            if (inRange) {
                this.mob.func_70661_as().func_75499_g();
            }
            if (isFar) {
                this.mob.func_70661_as().func_75497_a((Entity)this.target, this.speedModifier);
            }
            if (isClose) {
                ((BowmanEntity)((Object)this.mob)).fleeEntity(this.target);
            }
        }
        double d0 = this.mob.func_70092_e(this.target.func_226277_ct_(), this.target.func_226278_cu_(), this.target.func_226281_cx_());
        this.mob.func_70671_ap().func_75651_a((Entity)this.target, 30.0f, 30.0f);
        if (this.mob.func_184587_cr()) {
            int i;
            if (!canSee && this.seeTime < -60) {
                this.mob.func_184602_cy();
            } else if (canSee && (i = this.mob.func_184612_cw()) >= 20) {
                this.mob.func_184602_cy();
                ((BowmanEntity)((Object)this.mob)).func_82196_d(this.target, BowItem.func_185059_b((int)i));
                float f = MathHelper.func_76133_a((double)d0) / this.attackRadius;
                this.attackTime = MathHelper.func_76141_d((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
            }
        } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
            this.mob.func_184598_c(ProjectileHelper.func_221274_a(this.mob, (Item)Items.field_151031_f));
        }
    }
}

