/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai;

import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.RangedInteger;

public class RecruitRangedCrossbowAttackGoal<T extends CreatureEntity & ICrossbowUser>
extends Goal {
    public static final RangedInteger PATHFINDING_DELAY_RANGE = new RangedInteger(20, 40);
    private final T mob;
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;
    private final double speedModifier;
    private final float attackRadiusSqr;
    private int seeTime;
    private int attackDelay;
    private int updatePathDelay;

    public RecruitRangedCrossbowAttackGoal(T recruit, double speedModifier, float attackRadiusSqr) {
        this.mob = recruit;
        this.speedModifier = speedModifier;
        this.attackRadiusSqr = attackRadiusSqr * attackRadiusSqr;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        return this.isValidTarget() && this.isHoldingCrossbow();
    }

    private boolean isHoldingCrossbow() {
        return this.mob.func_233631_a_(Items.field_222114_py);
    }

    public boolean func_75253_b() {
        return this.isValidTarget() && (this.func_75250_a() || !this.mob.func_70661_as().func_75500_f()) && this.isHoldingCrossbow();
    }

    private boolean isValidTarget() {
        return this.mob.func_70638_az() != null && this.mob.func_70638_az().func_70089_S();
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.mob.func_213395_q(false);
        this.mob.func_70624_b((LivingEntity)null);
        this.seeTime = 0;
        if (this.mob.func_184587_cr()) {
            this.mob.func_184602_cy();
            ((ICrossbowUser)this.mob).func_213671_a(false);
            CrossbowItem.func_220011_a((ItemStack)this.mob.func_184607_cu(), (boolean)false);
        }
    }

    public void func_75246_d() {
        LivingEntity livingentity = this.mob.func_70638_az();
        if (livingentity != null) {
            boolean flag2;
            boolean flag1;
            boolean flag = this.mob.func_70635_at().func_75522_a((Entity)livingentity);
            boolean bl = flag1 = this.seeTime > 0;
            if (flag != flag1) {
                this.seeTime = 0;
            }
            this.seeTime = flag ? ++this.seeTime : --this.seeTime;
            double d0 = this.mob.func_70068_e((Entity)livingentity);
            boolean bl2 = flag2 = (d0 > (double)this.attackRadiusSqr || this.seeTime < 5) && this.attackDelay == 0;
            if (flag2) {
                --this.updatePathDelay;
                if (this.updatePathDelay <= 0) {
                    this.mob.func_70661_as().func_75497_a((Entity)livingentity, this.canRun() ? this.speedModifier : this.speedModifier * 0.5);
                    this.updatePathDelay = PATHFINDING_DELAY_RANGE.func_233018_a_(this.mob.func_70681_au());
                }
            } else {
                this.updatePathDelay = 0;
                this.mob.func_70661_as().func_75499_g();
            }
            this.mob.func_70671_ap().func_75651_a((Entity)livingentity, 30.0f, 30.0f);
            if (this.crossbowState == CrossbowState.UNCHARGED) {
                if (!flag2) {
                    this.mob.func_184598_c(ProjectileHelper.func_221274_a(this.mob, (Item)Items.field_222114_py));
                    this.crossbowState = CrossbowState.CHARGING;
                    ((ICrossbowUser)this.mob).func_213671_a(true);
                }
            } else if (this.crossbowState == CrossbowState.CHARGING) {
                ItemStack itemstack;
                int i;
                if (!this.mob.func_184587_cr()) {
                    this.crossbowState = CrossbowState.UNCHARGED;
                }
                if ((i = this.mob.func_184612_cw()) >= CrossbowItem.func_220026_e((ItemStack)(itemstack = this.mob.func_184607_cu()))) {
                    this.mob.func_184597_cx();
                    this.crossbowState = CrossbowState.CHARGED;
                    this.attackDelay = 20 + this.mob.func_70681_au().nextInt(20);
                    ((ICrossbowUser)this.mob).func_213671_a(false);
                }
            } else if (this.crossbowState == CrossbowState.CHARGED) {
                --this.attackDelay;
                if (this.attackDelay == 0) {
                    this.crossbowState = CrossbowState.READY_TO_ATTACK;
                }
            } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && flag) {
                ((IRangedAttackMob)this.mob).func_82196_d(livingentity, 1.0f);
                ItemStack itemstack1 = this.mob.func_184586_b(ProjectileHelper.func_221274_a(this.mob, (Item)Items.field_222114_py));
                CrossbowItem.func_220011_a((ItemStack)itemstack1, (boolean)false);
                this.crossbowState = CrossbowState.UNCHARGED;
            }
        }
    }

    private boolean canRun() {
        return this.crossbowState == CrossbowState.UNCHARGED;
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

