/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.inventory;

import com.mojang.datafixers.util.Pair;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import de.maxhenkel.recruits.corelib.inventory.ContainerBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RecruitInventoryContainer
extends ContainerBase {
    private final IInventory recruitInventory;
    private final AbstractRecruitEntity recruit;
    private static final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{PlayerContainer.field_226619_g_, PlayerContainer.field_226618_f_, PlayerContainer.field_226617_e_, PlayerContainer.field_226616_d_};
    private static final EquipmentSlotType[] SLOT_IDS = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};

    public RecruitInventoryContainer(int id, AbstractRecruitEntity recruit, PlayerInventory playerInventory) {
        super(Main.RECRUIT_CONTAINER_TYPE, id, (IInventory)playerInventory, (IInventory)recruit.getInventory());
        this.recruit = recruit;
        this.recruitInventory = recruit.getInventory();
        this.addRecruitInventorySlots();
        this.addRecruitHandSlots();
        this.addRecruitEquipmentSlots();
        this.addPlayerInventorySlots();
    }

    public AbstractRecruitEntity getRecruit() {
        return this.recruit;
    }

    @Override
    public int getInvOffset() {
        return 56;
    }

    public void addRecruitInventorySlots() {
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 3; ++l) {
                this.func_75146_a(new Slot(this.recruitInventory, 0 + l + k * this.recruit.getInventoryColumns(), 118 + l * 18, 18 + k * 18));
            }
        }
    }

    public void addRecruitEquipmentSlots() {
        for (int k = 0; k < 4; ++k) {
            final EquipmentSlotType equipmentslottype = SLOT_IDS[k];
            this.func_75146_a(new Slot((IInventory)this.recruit.inventory, 11 + k, 8, 18 + k * 18){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(ItemStack itemStack) {
                    return itemStack.canEquip(equipmentslottype, (Entity)RecruitInventoryContainer.this.recruit);
                }

                public void func_75215_d(ItemStack stack) {
                    super.func_75215_d(stack);
                    RecruitInventoryContainer.this.recruit.func_184201_a(equipmentslottype, stack);
                }

                @OnlyIn(value=Dist.CLIENT)
                public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                    return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)TEXTURE_EMPTY_SLOTS[equipmentslottype.func_188454_b()]);
                }
            });
        }
    }

    public void addRecruitHandSlots() {
        this.func_75146_a(new Slot((IInventory)this.recruit.inventory, 9, 26, 90){

            public boolean func_75214_a(ItemStack itemStack) {
                return true;
            }

            public void func_75215_d(ItemStack stack) {
                super.func_75215_d(stack);
                RecruitInventoryContainer.this.recruit.func_184201_a(EquipmentSlotType.MAINHAND, stack);
            }
        });
        this.func_75146_a(new Slot((IInventory)this.recruit.inventory, 10, 44, 90){

            public boolean func_75214_a(ItemStack stack) {
                return stack.isShield(null);
            }

            public void func_75215_d(ItemStack stack) {
                super.func_75215_d(stack);
                RecruitInventoryContainer.this.recruit.func_184201_a(EquipmentSlotType.OFFHAND, stack);
            }

            public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)PlayerContainer.field_226620_h_);
            }
        });
    }

    @Override
    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.recruitInventory.func_70300_a(playerIn) && this.recruit.func_70089_S() && this.recruit.func_70032_d((Entity)playerIn) < 8.0f;
    }

    @Override
    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
    }
}

