/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.aurelj.skyvillages;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.yezon.aurelj.skyvillages.SkyVillages;

public class STStructures {
    public static final DeferredRegister<Structure<?>> DEFERRED_REGISTRY_STRUCTURE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"skyvillages");
    public static final RegistryObject<Structure<NoFeatureConfig>> SKYVILLAGE = DEFERRED_REGISTRY_STRUCTURE.register("skyvillage", () -> new SkyVillages((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    public static void setupStructures() {
        STStructures.setupMapSpacingAndLand((Structure)SKYVILLAGE.get(), new StructureSeparationSettings(40, 9, 1921454193), true);
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
            WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
                Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
                if (structureMap instanceof ImmutableMap) {
                    HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                    tempMap.put(structure, structureSeparationSettings);
                } else {
                    structureMap.put(structure, structureSeparationSettings);
                }
            });
        }
    }
}

