/*
 * Decompiled with CFR 0.152.
 */
package net.witixin.snowballeffect.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.witixin.snowballeffect.Reference;
import net.witixin.snowballeffect.registry.EntityRegistry;
import net.witixin.snowballeffect.registry.ItemRegistry;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityIgloof
extends TamableAnimal
implements NeutralMob,
IAnimatable {
    public static final Tags.IOptionalNamedTag<Block> GLOOF_BREAKABLES_TAG = BlockTags.createOptional((ResourceLocation)Reference.rl("blocks/gloof_breakables"));
    private static final int UNSITTABLE_AGE = 30;
    private static final float GROWTH_CONSTANT = 1.08f;
    private static final int MAX_AGE = 40;
    private static final int MAX_FOLLOW_DIST = 30;
    private static final int MELTING_COOLDOWN_TICKS = 6000;
    private static final int EATING_COOLDOWN_TICKS = 1200;
    public static Map<Block, Float> valueMap = new HashMap<Block, Float>();
    private static final EntityDataAccessor<Integer> SYNCHED_DATA_AGE = SynchedEntityData.m_135353_(EntityIgloof.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ICEY_DATA = SynchedEntityData.m_135353_(EntityIgloof.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> EATING_DATA = SynchedEntityData.m_135353_(EntityIgloof.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ATTACKING_DATA = SynchedEntityData.m_135353_(EntityIgloof.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RENDER_SITTING = SynchedEntityData.m_135353_(EntityIgloof.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> EATING_COOLDOWN = SynchedEntityData.m_135353_(EntityIgloof.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MELTING_COOLDOWN = SynchedEntityData.m_135353_(EntityIgloof.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TICKS_TILL_EATING = SynchedEntityData.m_135353_(EntityIgloof.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> SNOW_COUNTER = SynchedEntityData.m_135353_(EntityIgloof.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SNOW_FEED_COUNTER = SynchedEntityData.m_135353_(EntityIgloof.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> ICE_TICKS = SynchedEntityData.m_135353_(EntityIgloof.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public EntityIgloof(EntityType<? extends EntityIgloof> entityType, Level level) {
        super((EntityType)EntityRegistry.IGLOOF.get(), level);
    }

    public static void setupValueMap() {
        valueMap.put(Blocks.f_50125_, Float.valueOf(0.5f));
        valueMap.put(Blocks.f_50127_, Float.valueOf(4.0f));
        valueMap.put(Blocks.f_152499_, Float.valueOf(8.0f));
    }

    public static EntityIgloof of(Level level, Player id) {
        EntityIgloof toReturn = new EntityIgloof((EntityType<? extends EntityIgloof>)((EntityType)EntityRegistry.IGLOOF.get()), level);
        toReturn.m_21828_(id);
        return toReturn;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && !this.m_21827_()) {
            if (this.getEatingCooldownTicks() > 0) {
                this.setEatingCooldownTicks(this.getEatingCooldownTicks() - 1);
            }
            if (this.getMeltingCooldownTicks() > 0) {
                this.setMeltingCooldownTicks(this.getMeltingCooldownTicks() - 1);
            }
            this.canStartToFeed();
            if (this.isEating()) {
                if (!EntityIgloof.matchesSnow(this.f_19853_.m_8055_(this.m_20097_()).m_60734_())) {
                    this.setEating(false);
                    return;
                }
                if (this.getTicksTillEating() < 100) {
                    this.setEatingTicks(this.getTicksTillEating() + 1);
                }
                if (this.getTicksTillEating() == 100) {
                    this.helpFeedOnBlock(this.m_20097_());
                }
            }
            if (this.getIceTicks() >= 600) {
                this.setIceTicks(0);
                this.setIcey(true);
                this.setEating(false);
            }
        }
    }

    private void helpFeedOnBlock(BlockPos pos) {
        this.setSnowCounter(this.getSnowCounter() + valueMap.get(this.f_19853_.m_8055_(pos).m_60734_()).floatValue());
        this.f_19853_.m_46961_(pos, false);
        this.setEatingCooldownTicks(1200);
        this.updateSnowFeedAmont();
        this.setEating(false);
        if (this.getSnowCounter() >= this.getSnowFeed()) {
            this.feed();
            this.updateSnowFeedAmont();
            this.setSnowCounter(0.0f);
        }
    }

    public void feed() {
        if (this.getGloofAge() == 40) {
            return;
        }
        this.saveAge(this.getGloofAge() + 1);
        this.m_21051_(Attributes.f_22276_).m_22100_((double)(2 * this.getGloofAge() / this.getIceReduction()));
        this.m_21051_(Attributes.f_22281_).m_22100_((double)((this.getGloofAge() % 3 == 0 ? 1 : 0) / this.getIceReduction()));
        this.updateDims();
        this.m_6210_();
        this.setEatingCooldownTicks(1200);
    }

    public void unfeed() {
        this.saveAge(this.getGloofAge() - 1);
        this.m_21051_(Attributes.f_22276_).m_22100_((double)(2 * this.getGloofAge() / this.getIceReduction()));
        this.m_21051_(Attributes.f_22281_).m_22100_((this.m_21133_(Attributes.f_22281_) + (double)(this.getGloofAge() % 3 == 0 ? 1 : 0)) / (double)this.getIceReduction());
        this.updateDims();
        this.m_6210_();
    }

    private int getIceReduction() {
        return this.isIcey() ? 2 : 1;
    }

    private void saveAge(int age) {
        this.f_19804_.m_135381_(SYNCHED_DATA_AGE, (Object)age);
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(this.getSize());
    }

    public float getSize() {
        return (float)Math.pow(1.08f, this.getGloofAge());
    }

    private void updateDims() {
        this.f_19815_ = this.m_6972_(this.m_20089_());
        this.m_20011_(this.f_19815_.m_20384_(1.0, 1.0, 1.0));
    }

    public boolean canStartToFeed() {
        if (this.isIcey()) {
            return false;
        }
        if (this.getEatingCooldownTicks() <= 0 && !this.isEating() && EntityIgloof.matchesSnow(this.f_19853_.m_8055_(this.m_20097_()).m_60734_())) {
            this.setEatingTicks(0);
            this.setEating(true);
            return true;
        }
        return false;
    }

    public boolean canFeedOnBlock() {
        return EntityIgloof.matchesSnow(this.f_19853_.m_8055_(this.m_20097_()).m_60734_());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new GloofFollowOwnerGoal(this, 1.0, 20.0f, 1.0f, false));
        this.f_21345_.m_25352_(1, (Goal)new GloofSitWhenOrderedToGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new GloofMeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new GloofRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new GloofFloatGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
    }

    private int getGloofAge() {
        int ageGloof = (Integer)this.f_19804_.m_135370_(SYNCHED_DATA_AGE);
        return ageGloof;
    }

    public boolean m_6673_(DamageSource source) {
        return super.m_6673_(source) || source == DamageSource.f_146701_ || this.isEntityDamageSourceSnowball(source);
    }

    private boolean isEntityDamageSourceSnowball(DamageSource source) {
        return source instanceof IndirectEntityDamageSource && source.m_7640_() instanceof Snowball;
    }

    public InteractionResult m_6071_(Player p_30412_, InteractionHand p_30413_) {
        if (p_30412_.f_19853_.f_46443_ && p_30413_ == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        if (this.m_21223_() < this.m_21233_() && !this.isIcey() && p_30412_.m_21120_(p_30413_).m_41720_() == ItemRegistry.MAGIC_COAL.get()) {
            this.m_5634_(4.0f);
            p_30412_.m_21120_(p_30413_).m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        if (this.isIcey() && p_30412_.m_21120_(p_30413_).m_41720_() == ItemRegistry.MAGIC_TORCH_ITEM.get()) {
            this.setIcey(false);
            p_30412_.m_21120_(p_30413_).m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        if (!this.isIcey() && this.getEatingCooldownTicks() < 1000 && this.getGloofAge() < 2 && p_30412_.m_21120_(p_30413_).m_41720_() == Items.f_42452_ && p_30412_.m_21120_(p_30413_).m_41613_() >= 8) {
            this.feed();
            p_30412_.m_21120_(p_30413_).m_41774_(8);
            return InteractionResult.SUCCESS;
        }
        if (!this.isIcey() && p_30412_.m_21120_(p_30413_).m_41720_() == ItemRegistry.MAGIC_TORCH_ITEM.get() && this.getMeltingCooldownTicks() == 0 && this.getGloofAge() > 0) {
            this.unfeed();
            p_30412_.m_21120_(p_30413_).m_41774_(1);
            this.setMeltingCooldownTicks(6000);
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && this.getGloofAge() <= 30 && (this.m_21830_((LivingEntity)p_30412_) || super.m_6071_(p_30412_, p_30413_).m_19077_())) {
            if (this.m_21827_()) {
                this.m_21839_(false);
                this.setRenderSitting(false);
                this.m_21837_(false);
                return InteractionResult.SUCCESS;
            }
            if (!this.m_21827_()) {
                this.m_21839_(true);
                this.setRenderSitting(true);
                this.m_21837_(true);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(p_30412_, p_30413_);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return null;
    }

    public int getMaxFollowDist() {
        return 30 + this.getGloofAge() * this.getGloofAge();
    }

    public void m_6763_(BlockState state) {
        if (this.getGloofAge() >= 25 && GLOOF_BREAKABLES_TAG.m_8110_((Object)state.m_60734_())) {
            this.destroyBlockInsideOn(state);
        }
    }

    private void destroyBlockInsideOn(BlockState state) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        AABB aabb = this.m_142469_();
        BlockPos blockpos = new BlockPos(aabb.f_82288_ + 0.001, aabb.f_82289_ + 0.001, aabb.f_82290_ + 0.001);
        BlockPos blockpos1 = new BlockPos(aabb.f_82291_ - 0.001, aabb.f_82292_ - 0.001, aabb.f_82293_ - 0.001);
        for (int i = blockpos.m_123341_(); i <= blockpos1.m_123341_(); ++i) {
            block1: for (int j = blockpos.m_123342_(); j <= blockpos1.m_123342_(); ++j) {
                for (int k = blockpos.m_123343_(); k <= blockpos1.m_123343_(); ++k) {
                    blockpos$mutableblockpos.m_122178_(i, j, k);
                    BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos);
                    if (!state.equals(blockstate)) continue;
                    this.f_19853_.m_46961_((BlockPos)blockpos$mutableblockpos, true);
                    System.out.println("Found a block");
                    continue block1;
                }
            }
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SYNCHED_DATA_AGE, (Object)0);
        this.f_19804_.m_135372_(ICEY_DATA, (Object)false);
        this.f_19804_.m_135372_(EATING_DATA, (Object)false);
        this.f_19804_.m_135372_(ATTACKING_DATA, (Object)false);
        this.f_19804_.m_135372_(EATING_COOLDOWN, (Object)1200);
        this.f_19804_.m_135372_(MELTING_COOLDOWN, (Object)6000);
        this.f_19804_.m_135372_(RENDER_SITTING, (Object)false);
        this.f_19804_.m_135372_(TICKS_TILL_EATING, (Object)0);
        this.f_19804_.m_135372_(SNOW_COUNTER, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SNOW_FEED_COUNTER, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ICE_TICKS, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("GloofAge", this.getGloofAge());
        tag.m_128379_("GloofIcey", this.isIcey());
        tag.m_128379_("GloofEating", this.isEating());
        tag.m_128379_("GloofAttacking", this.isAttackingData());
        tag.m_128405_("GloofEatCooldown", this.getEatingCooldownTicks());
        tag.m_128405_("GloofMeltCooldown", this.getMeltingCooldownTicks());
        tag.m_128405_("GloofTicks", this.getTicksTillEating());
        tag.m_128350_("GloofSnowCounter", this.getSnowCounter());
        tag.m_128350_("GloofSnowFeed", this.getSnowFeed());
        tag.m_128405_("GloofIceTicks", this.getIceTicks());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.saveAge(tag.m_128451_("GloofAge"));
        this.setIcey(tag.m_128471_("GloofIcey"));
        this.setEating(tag.m_128471_("GloofEating"));
        this.setEating(tag.m_128471_("GloofAttacking"));
        this.setEatingCooldownTicks(tag.m_128451_("GloofEatCooldown"));
        this.setMeltingCooldownTicks(tag.m_128451_("GloofMeltCooldown"));
        this.setRenderSitting(tag.m_128471_("Sitting"));
        this.setEatingTicks(tag.m_128451_("GloofTicks"));
        this.setSnowCounter(tag.m_128457_("GloofSnowCounter"));
        this.setSnowFeed(tag.m_128457_("GloofSnowFeed"));
        this.setIceTicks(tag.m_128451_("GloofIceTicks"));
    }

    public boolean isRenderSitting() {
        return (Boolean)this.f_19804_.m_135370_(RENDER_SITTING);
    }

    public void setRenderSitting(boolean value) {
        this.f_19804_.m_135381_(RENDER_SITTING, (Object)value);
    }

    public int getTicksTillEating() {
        return (Integer)this.f_19804_.m_135370_(TICKS_TILL_EATING);
    }

    public void setEatingTicks(int i) {
        this.f_19804_.m_135381_(TICKS_TILL_EATING, (Object)i);
    }

    public float getSnowCounter() {
        return ((Float)this.f_19804_.m_135370_(SNOW_COUNTER)).floatValue();
    }

    public void setSnowCounter(float value) {
        this.f_19804_.m_135381_(SNOW_COUNTER, (Object)Float.valueOf(value));
    }

    public float getSnowFeed() {
        return ((Float)this.f_19804_.m_135370_(SNOW_FEED_COUNTER)).floatValue();
    }

    public void setSnowFeed(float value) {
        this.f_19804_.m_135381_(SNOW_FEED_COUNTER, (Object)Float.valueOf(value));
    }

    public int getIceTicks() {
        return (Integer)this.f_19804_.m_135370_(ICE_TICKS);
    }

    public void setIceTicks(int value) {
        this.f_19804_.m_135381_(ICE_TICKS, (Object)value);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            this.m_21666_((ServerLevel)this.f_19853_, true);
        }
    }

    public boolean m_6573_(Player p_30396_) {
        return !this.m_21660_() && super.m_6573_(p_30396_) && this.getGloofAge() <= 30;
    }

    public boolean m_7848_(Animal animal) {
        return false;
    }

    public boolean m_142668_() {
        return false;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.getAnimatable() instanceof EntityIgloof) {
            EntityIgloof gloof = (EntityIgloof)event.getAnimatable();
            if (gloof.isRenderSitting()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.sit", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
            if (event.isMoving() && !gloof.m_21827_() && !this.isAttackingData()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.walk", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
            if (gloof.isEating()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.chomp", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
            if (gloof.isAttackingData() && gloof.m_5448_() != null && gloof.m_20097_().m_123331_((Vec3i)gloof.m_5448_().m_142538_()) < 3.0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.attack", Boolean.valueOf(false)));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.idle", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean isIcey() {
        return (Boolean)this.f_19804_.m_135370_(ICEY_DATA);
    }

    public void setIcey(boolean bool) {
        this.f_19804_.m_135381_(ICEY_DATA, (Object)bool);
    }

    public boolean isEating() {
        return (Boolean)this.f_19804_.m_135370_(EATING_DATA);
    }

    public void setEating(boolean bool) {
        this.f_19804_.m_135381_(EATING_DATA, (Object)bool);
    }

    public boolean isAttackingData() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING_DATA);
    }

    public void setAttackingData(boolean bool) {
        this.f_19804_.m_135381_(ATTACKING_DATA, (Object)bool);
    }

    public int getEatingCooldownTicks() {
        return (Integer)this.f_19804_.m_135370_(EATING_COOLDOWN);
    }

    public void setEatingCooldownTicks(int i) {
        this.f_19804_.m_135381_(EATING_COOLDOWN, (Object)i);
    }

    public int getMeltingCooldownTicks() {
        return (Integer)this.f_19804_.m_135370_(MELTING_COOLDOWN);
    }

    public void setMeltingCooldownTicks(int i) {
        this.f_19804_.m_135381_(MELTING_COOLDOWN, (Object)i);
    }

    public int m_6784_() {
        return 0;
    }

    public void m_7870_(int p_21673_) {
    }

    private void updateSnowFeedAmont() {
        this.setSnowFeed((float)this.getGloofAge() * 3.0f);
    }

    @Nullable
    public UUID m_6120_() {
        return null;
    }

    public void m_6925_(@Nullable UUID p_21672_) {
    }

    public void m_6825_() {
    }

    public static boolean matchesSnow(Block block) {
        return valueMap.containsKey(block);
    }

    private static class GloofFollowOwnerGoal
    extends FollowOwnerGoal {
        private double speedMod;

        public GloofFollowOwnerGoal(TamableAnimal p_25294_, double p_25295_, float p_25296_, float p_25297_, boolean p_25298_) {
            super(p_25294_, p_25295_, p_25296_, p_25297_, p_25298_);
            this.speedMod = p_25295_;
        }

        public void m_8037_() {
            this.f_25283_.m_21563_().m_24960_((Entity)this.f_25284_, 10.0f, (float)this.f_25283_.m_8132_());
            if (--this.f_25288_ <= 0) {
                this.f_25288_ = this.m_183277_(10);
                if (!this.f_25283_.m_21523_() && !this.f_25283_.m_20159_()) {
                    if (this.f_25283_.m_20280_((Entity)this.f_25284_) >= (double)((EntityIgloof)this.f_25283_).getMaxFollowDist()) {
                        this.m_25313_();
                    } else {
                        this.f_25283_.m_21573_().m_5624_((Entity)this.f_25284_, this.speedMod);
                    }
                }
            }
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.f_25283_.m_142480_();
            if (livingentity == null) {
                return false;
            }
            if (livingentity.m_5833_()) {
                return false;
            }
            if (this.f_25283_.m_21827_()) {
                return false;
            }
            if (this.f_25283_.m_20280_((Entity)livingentity) < Math.pow(((EntityIgloof)this.f_25283_).getMaxFollowDist(), 2.0)) {
                return false;
            }
            this.f_25284_ = livingentity;
            return true;
        }

        public boolean m_8045_() {
            if (this.f_25283_.m_21573_().m_26571_()) {
                return false;
            }
            if (this.f_25283_.m_21827_()) {
                return false;
            }
            return !(this.f_25283_.m_20280_((Entity)this.f_25284_) <= (double)((EntityIgloof)this.f_25283_).getMaxFollowDist());
        }
    }

    private static class GloofSitWhenOrderedToGoal
    extends SitWhenOrderedToGoal {
        private EntityIgloof entity;

        public GloofSitWhenOrderedToGoal(EntityIgloof entity) {
            super((TamableAnimal)entity);
            this.entity = entity;
        }

        public boolean m_8036_() {
            return this.entity.getGloofAge() <= 30 && super.m_8036_();
        }
    }

    private static class GloofMeleeAttackGoal
    extends MeleeAttackGoal {
        public GloofMeleeAttackGoal(PathfinderMob p_25552_, double p_25553_, boolean p_25554_) {
            super(p_25552_, p_25553_, p_25554_);
        }

        public void m_8041_() {
            super.m_8041_();
            ((EntityIgloof)this.f_25540_).setAttackingData(false);
        }

        public void m_8037_() {
            super.m_8037_();
            System.out.println(this.f_25540_.m_20280_((Entity)this.f_25540_.m_5448_()));
        }

        protected void m_6739_(LivingEntity p_25557_, double p_25558_) {
            super.m_6739_(p_25557_, p_25558_);
            ((EntityIgloof)this.f_25540_).setAttackingData(true);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            AABB aabb = this.f_25540_.m_142469_();
            BlockPos blockpos = new BlockPos(aabb.f_82288_ + 0.001, aabb.f_82289_ + 0.001, aabb.f_82290_ + 0.001);
            BlockPos blockpos1 = new BlockPos(aabb.f_82291_ - 0.001, aabb.f_82292_ - 0.001, aabb.f_82293_ - 0.001);
            for (int i = blockpos.m_123341_(); i <= blockpos1.m_123341_() + this.getAtackRange() * this.getXModifier(); ++i) {
                for (int j = blockpos.m_123342_(); j <= blockpos1.m_123342_() + this.getAtackRange(); ++j) {
                    for (int k = blockpos.m_123343_(); k <= blockpos1.m_123343_() + this.getAtackRange() * this.getZModifier(); ++k) {
                        blockpos$mutableblockpos.m_122178_(i, j, k);
                        BlockState blockstate = this.f_25540_.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos);
                        if (!GLOOF_BREAKABLES_TAG.m_8110_((Object)blockstate.m_60734_())) continue;
                        this.f_25540_.f_19853_.m_46961_((BlockPos)blockpos$mutableblockpos, true);
                    }
                }
            }
        }

        private int getAtackRange() {
            return ((EntityIgloof)this.f_25540_).getGloofAge() / 5;
        }

        private Vec3i getModifier() {
            return this.f_25540_.m_6350_().m_122436_();
        }

        private int getXModifier() {
            return this.getModifier().m_123341_();
        }

        private int getZModifier() {
            return this.getModifier().m_123343_();
        }
    }

    private static class GloofRandomStrollGoal
    extends RandomStrollGoal {
        public GloofRandomStrollGoal(PathfinderMob p_25734_, double p_25735_) {
            super(p_25734_, p_25735_);
        }

        public boolean m_8036_() {
            Vec3 vec3;
            if (this.f_25725_.m_20160_()) {
                return false;
            }
            if (!this.f_25731_) {
                if (this.f_25732_ && this.f_25725_.m_21216_() >= 100) {
                    return false;
                }
                if (this.f_25725_.m_21187_().nextInt(GloofRandomStrollGoal.m_186073_((int)this.f_25730_)) != 0) {
                    return false;
                }
            }
            if ((vec3 = this.m_7037_()) == null) {
                return false;
            }
            this.f_25726_ = vec3.f_82479_ + (double)((EntityIgloof)this.f_25725_).getGloofAge() / 1.5;
            this.f_25727_ = vec3.f_82480_;
            this.f_25728_ = vec3.f_82481_ + (double)((EntityIgloof)this.f_25725_).getGloofAge() / 1.5;
            this.f_25731_ = false;
            return true;
        }
    }

    private static class GloofFloatGoal
    extends FloatGoal {
        private EntityIgloof gloof;

        public GloofFloatGoal(EntityIgloof gloof) {
            super((Mob)gloof);
            this.gloof = gloof;
        }

        public boolean m_8036_() {
            return super.m_8036_();
        }

        public void m_8037_() {
            super.m_8037_();
            this.gloof.setIceTicks(this.gloof.getIceTicks() + 1);
        }
    }
}

