/*
 * Decompiled with CFR 0.152.
 */
package net.konwboy.tumbleweed.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import net.konwboy.tumbleweed.Tumbleweed;
import net.konwboy.tumbleweed.common.EntityTumbleweed;
import net.konwboy.tumbleweed.common.TumbleweedConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TumbleweedSpawner {
    private static final int TRY_SPAWN_TICKS = 200;
    private static final int MOB_COUNT_DIV = 289;
    private static final int SEARCH_RADIUS = 2;
    private static final int SPAWN_ATTEMPTS = 10;

    private static void trySpawn(ServerLevel world) {
        HashSet eligibleChunksForSpawning = Sets.newHashSet();
        for (Player entityplayer : world.m_6907_()) {
            if (entityplayer.m_5833_()) continue;
            int playerX = Mth.m_14107_((double)(entityplayer.m_20185_() / 16.0));
            int playerZ = Mth.m_14107_((double)(entityplayer.m_20189_() / 16.0));
            for (int x = 8; x >= -8; --x) {
                for (int z = 8; z >= -8; --z) {
                    Optional biome;
                    boolean corner = x == -8 || x == 8 || z == -8 || z == 8;
                    ChunkPos chunk = new ChunkPos(x + playerX, z + playerZ);
                    if (eligibleChunksForSpawning.contains(chunk) || corner || !world.m_6857_().m_61927_(chunk) || !TumbleweedSpawner.isEntityProcessing(world, chunk.f_45578_ * 16, chunk.f_45579_ * 16) || !(biome = world.m_45837_(new BlockPos(chunk.m_45604_() + 8, 0, chunk.m_45605_() + 8))).isPresent() || !TumbleweedSpawner.isValidBiome((ResourceKey<Biome>)((ResourceKey)biome.get()))) continue;
                    eligibleChunksForSpawning.add(chunk);
                }
            }
        }
        ArrayList chunkList = Lists.newArrayList((Iterable)eligibleChunksForSpawning);
        Collections.shuffle(chunkList);
        BlockPos worldSpawn = new BlockPos(world.m_6106_().m_6789_(), world.m_6106_().m_6527_(), world.m_6106_().m_6526_());
        long current = world.m_143280_(Tumbleweed.TUMBLEWEED, e -> true).size();
        int max = Mth.m_14165_((double)((double)(TumbleweedConfig.maxPerPlayer * eligibleChunksForSpawning.size()) / 289.0));
        block3: for (ChunkPos chunk : chunkList) {
            if (current > (long)max) break;
            if (world.f_46441_.nextDouble() > TumbleweedConfig.spawnChance) continue;
            BlockPos start = TumbleweedSpawner.getRandomSurfacePosition((Level)world, chunk.f_45578_, chunk.f_45579_);
            BlockPos spawner = null;
            block4: for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos check = world.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(start.m_123341_() + x, 0, start.m_123343_() + z));
                    BlockState state = world.m_8055_(check);
                    Block block = state.m_60734_();
                    if (!TumbleweedConfig.spawningBlocks.contains(block.getRegistryName()) || !world.m_46861_(check)) continue;
                    spawner = check;
                    continue block4;
                }
            }
            if (spawner == null) continue;
            int packSize = 1 + (world.f_46441_.nextFloat() < 0.2f ? 1 : 0);
            int packSpawned = 0;
            for (int i = 0; i < 10; ++i) {
                int x = spawner.m_123341_() + world.f_46441_.nextInt(5) - world.f_46441_.nextInt(5);
                int y = spawner.m_123342_() + world.f_46441_.nextInt(2) - world.f_46441_.nextInt(2);
                int z = spawner.m_123343_() + world.f_46441_.nextInt(5) - world.f_46441_.nextInt(5);
                if (!TumbleweedSpawner.isEntityProcessing(world, x, z) || !world.m_8055_(new BlockPos(x, y - 1, z)).m_60815_() || world.m_45914_((double)x, (double)y, (double)z, 32.0)) continue;
                if (worldSpawn.m_123331_(new Vec3i(x, y, z)) < 576.0) continue;
                EntityTumbleweed entity = (EntityTumbleweed)Tumbleweed.TUMBLEWEED.m_20615_((Level)world);
                entity.setSize(world.f_46441_.nextInt(5) - 2);
                entity.m_7678_((double)x + 0.5, (double)y + 0.5 + 0.5 * world.f_46441_.nextDouble(), (double)z + 0.5, 0.0f, 0.0f);
                if (entity.isNotColliding()) {
                    ++current;
                    ++packSpawned;
                    world.m_7967_((Entity)entity);
                }
                if (packSpawned == packSize) continue block3;
            }
        }
    }

    private static boolean isValidBiome(ResourceKey<Biome> biome) {
        boolean rightType = BiomeDictionary.hasType(biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY) || BiomeDictionary.hasType(biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY);
        return TumbleweedConfig.biomeWhitelist.isEmpty() && rightType || TumbleweedConfig.biomeWhitelist.contains(biome.m_135782_());
    }

    private static BlockPos getRandomSurfacePosition(Level world, int chunkX, int chunkZ) {
        LevelChunk chunk = world.m_6325_(chunkX, chunkZ);
        int x = chunkX * 16 + world.f_46441_.nextInt(14) + 2;
        int z = chunkZ * 16 + world.f_46441_.nextInt(14) + 2;
        int y = chunk.m_5885_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
        return new BlockPos(x, y, z);
    }

    private static boolean isEntityProcessing(ServerLevel world, double posX, double posZ) {
        return world.m_143275_(new ChunkPos(Mth.m_14107_((double)posX) >> 4, Mth.m_14107_((double)posZ) >> 4));
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent event) {
        ServerLevel world = (ServerLevel)event.world;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (world.m_46467_() % 200L == 7L && world.m_46469_().m_46207_(GameRules.f_46134_)) {
            world.m_46473_().m_6180_("spawn_tumbleweed");
            TumbleweedSpawner.trySpawn(world);
            world.m_46473_().m_7238_();
        }
        world.m_143280_(Tumbleweed.TUMBLEWEED, t -> !t.shouldPersist() && t.f_19797_ > 0 && !TumbleweedSpawner.isEntityProcessing(world, t.m_20185_(), t.m_20189_())).forEach(t -> t.m_142687_(Entity.RemovalReason.DISCARDED));
    }
}

