/*
 * Decompiled with CFR 0.152.
 */
package net.konwboy.tumbleweed.common;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import net.konwboy.tumbleweed.Tumbleweed;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.Registry;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class DropList {
    private static List<WeightedItem> weightedItems = Lists.newArrayList();
    private static int totalWeight;

    public static void load(List<String> drops) {
        totalWeight = 0;
        weightedItems.clear();
        for (String s : drops) {
            String[] itemData = s.split(" ");
            if (itemData.length < 2) continue;
            double weight = Double.parseDouble(itemData[0]);
            String item = itemData[1];
            try {
                new ItemParser(new StringReader(item), true).m_121032_();
            }
            catch (CommandSyntaxException e) {
                Tumbleweed.logger.warn("Error parsing drop list entry {}: {}", (Object)item, (Object)e.getMessage());
                continue;
            }
            int amount = 1;
            if (itemData.length >= 3) {
                try {
                    amount = Integer.parseInt(itemData[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            weightedItems.add(new WeightedItem(item, amount, weight));
            totalWeight = (int)((double)totalWeight + weight);
        }
    }

    public static ItemStack getRandomItem(Level level) {
        double randomWeight = (double)totalWeight * Math.random();
        double countedWeight = 0.0;
        for (WeightedItem weightedItem : weightedItems) {
            if ((countedWeight += weightedItem.weight) < randomWeight) continue;
            try {
                return weightedItem.getStack(level);
            }
            catch (CommandSyntaxException e) {
                Tumbleweed.logger.warn("Error parsing drop list entry {}: {}", (Object)weightedItem.item, (Object)e.getMessage());
                return null;
            }
        }
        return null;
    }

    private record WeightedItem(String item, int amount, double weight) {
        public ItemStack getStack(Level level) throws CommandSyntaxException {
            ItemParser parser = new ItemParser(new StringReader(this.item), true).m_121032_();
            Item item = parser.m_121014_();
            if (item == null) {
                Tag tag = level.m_142572_().m_129895_().m_144452_(Registry.f_122904_).m_13404_(parser.m_121022_());
                if (tag == null) {
                    Tumbleweed.logger.warn("Couldn't find item tag {}", (Object)parser.m_121022_());
                    return null;
                }
                if (tag.m_6497_().size() == 0) {
                    return null;
                }
                item = (Item)tag.m_13288_(level.f_46441_);
            }
            ItemStack stack = new ItemStack((ItemLike)item, this.amount);
            if (parser.m_121018_() != null) {
                stack.m_41751_(parser.m_121018_());
            }
            return stack;
        }
    }
}

