/*
 * Decompiled with CFR 0.152.
 */
package net.konwboy.tumbleweed.client;

import com.mojang.blaze3d.platform.GlStateManager;
import net.konwboy.tumbleweed.client.ModelTumbleweed;
import net.konwboy.tumbleweed.common.EntityTumbleweed;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderTumbleweed
extends EntityRenderer<EntityTumbleweed> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("tumbleweed", "textures/entity/tumbleweed.png");
    private ModelTumbleweed tumbleweed;
    private int lastV = 0;

    public RenderTumbleweed(EntityRendererManager manager) {
        super(manager);
        this.field_76989_e = 0.4f;
        this.field_76987_f = 0.8f;
        this.tumbleweed = new ModelTumbleweed(0.0f);
        this.lastV = this.tumbleweed.getV();
    }

    public void doRender(EntityTumbleweed entity, double x, double y, double z, float yaw, float partialTicks) {
        if (this.lastV != this.tumbleweed.getV()) {
            this.tumbleweed = new ModelTumbleweed(0.0f);
            this.lastV = this.tumbleweed.getV();
        }
        this.field_76989_e = entity.func_213311_cf() * 0.5f;
        GlStateManager.pushMatrix();
        GlStateManager.disableLighting();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        float alpha = 1.0f - (float)entity.fadeProgress / 80.0f;
        this.field_76987_f = alpha *= 0.7f;
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GlStateManager.translated((double)x, (double)(y + (double)(entity.func_213302_cg() * 0.3f)), (double)z);
        float size = 1.0f + (float)entity.getSize() / 8.0f;
        GlStateManager.scaled((double)size, (double)size, (double)size);
        float stretch = MathHelper.func_219799_g((float)partialTicks, (float)entity.prevStretch, (float)entity.stretch);
        GlStateManager.scaled((double)1.0, (double)stretch, (double)1.0);
        GlStateManager.multMatrix((Matrix4f)new Matrix4f(RenderTumbleweed.lerp(entity.prevQuat, entity.quat, partialTicks)));
        GlStateManager.rotated((double)entity.rot1, (double)1.0, (double)0.0, (double)0.0);
        GlStateManager.rotated((double)entity.rot2, (double)0.0, (double)1.0, (double)0.0);
        GlStateManager.rotated((double)entity.rot3, (double)0.0, (double)0.0, (double)1.0);
        this.func_110776_a(TEXTURE);
        this.tumbleweed.render(0.0625f);
        GlStateManager.disableBlend();
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
        super.func_76986_a((Entity)entity, x, y, z, yaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(EntityTumbleweed entity) {
        return TEXTURE;
    }

    public static Quaternion lerp(Quaternion start, Quaternion end, float alpha) {
        float d = start.func_195889_a() * end.func_195889_a() + start.func_195891_b() * end.func_195891_b() + start.func_195893_c() * end.func_195893_c() + start.func_195894_d() * end.func_195894_d();
        float absDot = d < 0.0f ? -d : d;
        float scale0 = 1.0f - alpha;
        float scale1 = alpha;
        if ((double)(1.0f - absDot) > 0.1) {
            float angle = (float)Math.acos(absDot);
            float invSinTheta = 1.0f / (float)Math.sin(angle);
            scale0 = (float)Math.sin((1.0f - alpha) * angle) * invSinTheta;
            scale1 = (float)Math.sin(alpha * angle) * invSinTheta;
        }
        if (d < 0.0f) {
            scale1 = -scale1;
        }
        return new Quaternion(scale0 * start.func_195889_a() + scale1 * end.func_195889_a(), scale0 * start.func_195891_b() + scale1 * end.func_195891_b(), scale0 * start.func_195893_c() + scale1 * end.func_195893_c(), scale0 * start.func_195894_d() + scale1 * end.func_195894_d());
    }

    public static class Factory
    implements IRenderFactory<EntityTumbleweed> {
        public EntityRenderer<EntityTumbleweed> createRenderFor(EntityRendererManager manager) {
            return new RenderTumbleweed(manager);
        }
    }
}

