/*
 * Decompiled with CFR 0.152.
 */
package tumbleweed.common;

import com.google.common.collect.Sets;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import tumbleweed.Tumbleweed;
import tumbleweed.common.Config;
import tumbleweed.common.EntityTumbleweed;
import tumbleweed.common.MessageWind;

public class CommonEventHandler {
    private static final int MOB_COUNT_DIV = (int)Math.pow(17.0, 2.0);
    private int ticks;

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        WorldServer world = (WorldServer)event.world;
        if (event.phase == TickEvent.Phase.END && world.field_73011_w.field_76574_g == 0) {
            if (this.ticks % 200 == 0) {
                HashSet eligibleChunksForSpawning = Sets.newHashSet();
                int i = 0;
                for (EntityPlayer entityplayer : world.field_73010_i) {
                    int j = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
                    int k = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
                    int l = 8;
                    for (int i1 = -l; i1 <= l; ++i1) {
                        for (int j1 = -l; j1 <= l; ++j1) {
                            boolean flag = i1 == -l || i1 == l || j1 == -l || j1 == l;
                            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i1 + j, j1 + k);
                            if (eligibleChunksForSpawning.contains(chunkcoordintpair)) continue;
                            ++i;
                            if (flag) continue;
                            eligibleChunksForSpawning.add(chunkcoordintpair);
                        }
                    }
                }
                ChunkCoordinates chunkcoordinates = world.func_72861_E();
                int j4 = world.func_72907_a(EntityTumbleweed.class);
                int k4 = 25 * i / MOB_COUNT_DIV;
                for (ChunkCoordIntPair chunkcoordintpair1 : eligibleChunksForSpawning) {
                    int z;
                    int y;
                    int x;
                    if (j4 > k4) break;
                    if (!(world.field_73012_v.nextFloat() < 0.4f)) continue;
                    ChunkCoordinates blockpos = CommonEventHandler.getRandomChunkPosition((World)world, chunkcoordintpair1.field_77276_a, chunkcoordintpair1.field_77275_b);
                    ChunkCoordinates deadBush = null;
                    int r = 4;
                    for (x = -r; x < r; ++x) {
                        block5: for (y = -r; y < r; ++y) {
                            for (z = -r; z < r; ++z) {
                                ChunkCoordinates check = new ChunkCoordinates(blockpos.field_71574_a + x, blockpos.field_71572_b + y, blockpos.field_71573_c + z);
                                Block block = world.func_147439_a(check.field_71574_a, check.field_71572_b, check.field_71573_c);
                                if (block != Blocks.field_150330_I || world.func_72883_k(check.field_71574_a, check.field_71572_b, check.field_71573_c) <= 8) continue;
                                deadBush = check;
                                continue block5;
                            }
                        }
                    }
                    if (deadBush == null) continue;
                    x = deadBush.field_71574_a;
                    y = deadBush.field_71572_b;
                    z = deadBush.field_71573_c;
                    float f3 = (float)x - (float)chunkcoordinates.field_71574_a;
                    float f4 = (float)y - (float)chunkcoordinates.field_71572_b;
                    float f5 = (float)z - (float)chunkcoordinates.field_71573_c;
                    float f6 = f3 * f3 + f4 * f4 + f5 * f5;
                    if (world.func_72977_a((double)x, (double)y, (double)z, 24.0) != null || !((double)f6 >= 576.0)) continue;
                    BiomeGenBase biome = world.func_72807_a(deadBush.field_71574_a, deadBush.field_71573_c);
                    if (!(biome.field_76750_F > 1.8f) || biome.field_76751_G != 0.0f) continue;
                    EntityTumbleweed entity = new EntityTumbleweed((World)world);
                    entity.func_70012_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 0.0f, 0.0f);
                    if (!entity.isNotColliding()) continue;
                    ++j4;
                    world.func_72838_d((Entity)entity);
                }
            }
            if (this.ticks % 2400 == 0) {
                if (world.field_73012_v.nextBoolean()) {
                    Tumbleweed.windX *= -1.0f;
                }
                if (world.field_73012_v.nextBoolean()) {
                    Tumbleweed.windZ *= -1.0f;
                }
                Tumbleweed.network.sendToAll((IMessage)new MessageWind(Tumbleweed.windX, Tumbleweed.windZ));
            }
            ++this.ticks;
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Tumbleweed.network.sendTo((IMessage)new MessageWind(Tumbleweed.windX, Tumbleweed.windZ), (EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("tumbleweed")) {
            Config.load();
        }
    }

    private static ChunkCoordinates getRandomChunkPosition(World worldIn, int x, int z) {
        Chunk chunk = worldIn.func_72964_e(x, z);
        int chunkX = worldIn.field_73012_v.nextInt(16);
        int chunkZ = worldIn.field_73012_v.nextInt(16);
        int i = x * 16 + chunkX;
        int j = z * 16 + chunkZ;
        int k = chunk.func_76611_b(chunkX, chunkZ) + 1;
        return new ChunkCoordinates(i, k, j);
    }
}

