/*
 * Decompiled with CFR 0.152.
 */
package tumbleweed.common;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ReportedException;
import net.minecraft.world.World;
import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.Vector4f;
import tumbleweed.Tumbleweed;
import tumbleweed.common.Config;
import tumbleweed.common.MessageFade;

public class EntityTumbleweed
extends Entity
implements IEntityAdditionalSpawnData {
    private static final float BASE_SIZE = 0.75f;
    private int age;
    public int fadeAge;
    public float field_70140_Q;
    public float field_82151_R;
    private int nextStepDistance;
    private int currentSize;
    private boolean canDespawn;
    @SideOnly(value=Side.CLIENT)
    public Quaternion quat;
    @SideOnly(value=Side.CLIENT)
    public Quaternion prevQuat;
    @SideOnly(value=Side.CLIENT)
    private Quaternion current;

    public EntityTumbleweed(World world) {
        super(world);
        this.func_70105_a(0.75f, 0.75f);
        this.field_70144_Y = 0.95f;
        this.field_70156_m = true;
        this.canDespawn = true;
        this.field_70155_l = 3.0;
        if (this.field_70170_p.field_72995_K) {
            this.quat = new Quaternion();
            this.prevQuat = new Quaternion();
            this.current = new Quaternion();
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(5, (Object)(1 - (3 - this.field_70170_p.field_73012_v.nextInt(5))));
        this.field_70180_af.func_75682_a(6, (Object)Float.valueOf(1.0f + (0.2f - 0.4f * this.field_70170_p.field_73012_v.nextFloat())));
        this.field_70180_af.func_75682_a(7, (Object)Float.valueOf(1.0f + (0.2f - 0.4f * this.field_70170_p.field_73012_v.nextFloat())));
    }

    protected void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("Size", this.getSize());
        tagCompound.func_74776_a("WindModX", this.getWindModX());
        tagCompound.func_74776_a("WindModZ", this.getWindModZ());
        tagCompound.func_74757_a("CanDespawn", this.canDespawn);
    }

    protected void func_70037_a(NBTTagCompound tagCompound) {
        if (tagCompound.func_74764_b("Size")) {
            this.field_70180_af.func_75692_b(5, (Object)tagCompound.func_74762_e("Size"));
        }
        if (tagCompound.func_74764_b("WindModX")) {
            this.field_70180_af.func_75692_b(6, (Object)Float.valueOf(tagCompound.func_74760_g("WindModX")));
        }
        if (tagCompound.func_74764_b("WindModZ")) {
            this.field_70180_af.func_75692_b(7, (Object)Float.valueOf(tagCompound.func_74760_g("WindModZ")));
        }
        if (tagCompound.func_74764_b("CanDespawn")) {
            this.canDespawn = tagCompound.func_74767_n("CanDespawn");
        }
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return null;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        float size = 0.75f + (float)this.currentSize * 0.125f;
        if (this.currentSize != this.getSize()) {
            this.currentSize = this.getSize();
            this.func_70105_a(size, size);
        }
        if (this.field_70154_o != null) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        } else {
            if (!this.func_70090_H()) {
                this.field_70181_x -= 0.012;
            }
            double x = this.field_70159_w;
            double y = this.field_70181_x;
            double z = this.field_70179_y;
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (this.func_70090_H()) {
                this.field_70181_x += 0.01;
                this.field_70159_w *= 0.95;
                this.field_70179_y *= 0.95;
            } else {
                float windX = this.getWindX();
                float windZ = this.getWindZ();
                if (windX != 0.0f || windZ != 0.0f) {
                    this.field_70159_w = windX;
                    this.field_70179_y = windZ;
                }
            }
            if (this.field_70170_p.field_72995_K) {
                double rotX = 360.0 * (-this.field_70179_y / (double)(5.0f * size));
                double rotZ = 360.0 * (this.field_70159_w / (double)(5.0f * size));
                this.prevQuat = this.quat;
                this.current.setFromAxisAngle(new Vector4f(1.0f, 0.0f, 0.0f, (float)Math.toRadians(rotX)));
                Quaternion.mul((Quaternion)this.quat, (Quaternion)this.current, (Quaternion)this.quat);
                this.current.setFromAxisAngle(new Vector4f(0.0f, 0.0f, 1.0f, (float)Math.toRadians(rotZ)));
                Quaternion.mul((Quaternion)this.quat, (Quaternion)this.current, (Quaternion)this.quat);
            }
            if (this.field_70122_E) {
                this.field_70181_x = (double)Math.abs(this.getWindX()) >= 0.05 || (double)Math.abs(this.getWindZ()) >= 0.05 ? Math.max(-y * 0.7, 0.24 - (double)this.getSize() * 0.02) : -y * 0.7;
            }
            if (this.field_70123_F) {
                this.field_70159_w = -x * 0.4;
                this.field_70179_y = -z * 0.4;
            }
            this.field_70159_w *= 0.98;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.98;
            if (Math.abs(this.field_70159_w) < 0.005) {
                this.field_70159_w = 0.0;
            }
            if (Math.abs(this.field_70181_x) < 0.005) {
                this.field_70181_x = 0.0;
            }
            if (Math.abs(this.field_70179_y) < 0.005) {
                this.field_70179_y = 0.0;
            }
            this.collideWithNearbyEntities();
            if (!this.field_70170_p.field_72995_K) {
                ++this.age;
                this.despawnEntity();
            }
            if (this.fadeAge > 0) {
                ++this.fadeAge;
                if (this.fadeAge > 80) {
                    this.func_70106_y();
                }
            }
        }
    }

    private void despawnEntity() {
        if (!this.canDespawn) {
            this.age = 0;
        } else {
            double d2;
            double d1;
            double d0;
            double d3;
            EntityPlayer entity = this.field_70170_p.func_72890_a((Entity)this, -1.0);
            if (entity != null && (d3 = (d0 = entity.field_70165_t - this.field_70165_t) * d0 + (d1 = entity.field_70163_u - this.field_70163_u) * d1 + (d2 = entity.field_70161_v - this.field_70161_v) * d2) > 12100.0) {
                this.func_70106_y();
            }
            if (this.age > 2400 && this.fadeAge == 0) {
                this.startFading();
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            Block.SoundType sound = Block.field_149779_h;
            this.func_85030_a(sound.func_150495_a(), (sound.func_150497_c() + 1.0f) / 2.0f, sound.func_150494_d() * 0.8f);
            EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, Config.getRandomItem());
            entityitem.field_70159_w = 0.0;
            entityitem.field_70181_x = 0.2;
            entityitem.field_70179_y = 0.0;
            entityitem.field_145804_b = 10;
            this.field_70170_p.func_72838_d((Entity)entityitem);
            this.func_70076_C();
            return true;
        }
        return false;
    }

    public void func_70091_d(double x, double y, double z) {
        if (this.field_70145_X) {
            this.func_70046_E().func_72317_d(x, y, z);
            this.resetPositionToBB();
        } else {
            double d0 = this.field_70165_t;
            double d1 = this.field_70163_u;
            double d2 = this.field_70161_v;
            if (this.field_70134_J) {
                this.field_70134_J = false;
                x *= 0.25;
                y *= 0.05;
                z *= 0.25;
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            double d3 = x;
            double d4 = y;
            double d5 = z;
            List list1 = this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D.func_72321_a(x, y, z));
            for (AxisAlignedBB axisalignedbb1 : list1) {
                y = axisalignedbb1.func_72323_b(this.field_70121_D, y);
            }
            this.field_70121_D.func_72317_d(0.0, y, 0.0);
            for (AxisAlignedBB axisalignedbb2 : list1) {
                x = axisalignedbb2.func_72316_a(this.field_70121_D, x);
            }
            this.field_70121_D.func_72317_d(x, 0.0, 0.0);
            for (AxisAlignedBB axisalignedbb13 : list1) {
                z = axisalignedbb13.func_72322_c(this.field_70121_D, z);
            }
            this.field_70121_D.func_72317_d(0.0, 0.0, z);
            this.field_70170_p.field_72984_F.func_76319_b();
            this.field_70170_p.field_72984_F.func_76320_a("rest");
            this.resetPositionToBB();
            this.field_70123_F = d3 != x || d5 != z;
            this.field_70124_G = d4 != y;
            this.field_70122_E = this.field_70124_G && d4 < 0.0;
            this.field_70132_H = this.field_70123_F || this.field_70124_G;
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)(this.field_70163_u - 0.2));
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            Block block = this.field_70170_p.func_147439_a(i, j, k);
            int i1 = this.field_70170_p.func_147439_a(i, j - 1, k).func_149645_b();
            if (i1 == 11 || i1 == 32 || i1 == 21) {
                block = this.field_70170_p.func_147439_a(i, j - 1, k);
            }
            this.func_70064_a(y, this.field_70122_E);
            if (d3 != x) {
                this.field_70159_w = 0.0;
            }
            if (d5 != z) {
                this.field_70179_y = 0.0;
            }
            if (d4 != y) {
                this.field_70181_x = 0.0;
                if (block == Blocks.field_150458_ak && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73012_v.nextFloat() < 0.7f) {
                    if (!this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                        return;
                    }
                    this.field_70170_p.func_147449_b(i, j, k, Blocks.field_150346_d);
                }
            }
            double d15 = this.field_70165_t - d0;
            double d16 = this.field_70163_u - d1;
            double d17 = this.field_70161_v - d2;
            if (block != Blocks.field_150468_ap) {
                d16 = 0.0;
            }
            if (this.field_70122_E) {
                block.func_149670_a(this.field_70170_p, i, j, k, (Entity)this);
            }
            this.field_70140_Q = (float)((double)this.field_70140_Q + (double)MathHelper.func_76133_a((double)(d15 * d15 + d17 * d17)) * 0.6);
            this.field_82151_R = (float)((double)this.field_82151_R + (double)MathHelper.func_76133_a((double)(d15 * d15 + d16 * d16 + d17 * d17)) * 0.6);
            if (this.field_82151_R > (float)this.nextStepDistance && block.func_149688_o() != Material.field_151579_a) {
                this.nextStepDistance = (int)this.field_82151_R + 1;
                if (this.func_70090_H()) {
                    float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w * 0.2 + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y * 0.2)) * 0.35f;
                    if (f > 1.0f) {
                        f = 1.0f;
                    }
                    this.func_85030_a(this.func_145776_H(), f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                }
                if (!block.func_149688_o().func_76224_d()) {
                    Block.SoundType sound = Block.field_149779_h;
                    this.func_85030_a(sound.func_150498_e(), sound.func_150497_c() * 0.15f, sound.func_150494_d());
                }
            }
            try {
                this.func_145775_I();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Checking entity block collision");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being checked for collision");
                this.func_85029_a(crashreportcategory);
                throw new ReportedException(crashreport);
            }
            this.field_70170_p.field_72984_F.func_76319_b();
        }
    }

    private void resetPositionToBB() {
        this.field_70165_t = (this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d) / 2.0;
        this.field_70163_u = this.field_70121_D.field_72338_b + (double)this.field_70129_M;
        this.field_70161_v = (this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f) / 2.0;
    }

    private void collideWithNearbyEntities() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(0.2, 0.0, 0.2));
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                this.collision(entity);
            }
        }
    }

    private void collision(Entity entity) {
        if (this.field_70153_n != entity && this.field_70154_o != entity && !this.field_70145_X && !entity.field_70145_X) {
            if (!this.field_70170_p.field_72995_K && entity instanceof EntityMinecart && ((EntityMinecart)entity).func_94087_l() == 0 && entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y > 0.01 && entity.field_70153_n == null && this.field_70154_o == null) {
                this.func_70078_a(entity);
                this.field_70181_x += 0.25;
                this.field_70133_I = true;
            } else {
                double d0 = this.field_70165_t - entity.field_70165_t;
                double d1 = this.field_70161_v - entity.field_70161_v;
                double d2 = MathHelper.func_76132_a((double)d0, (double)d1);
                if (d2 >= 0.01) {
                    d2 = MathHelper.func_76133_a((double)d2);
                    d0 /= d2;
                    d1 /= d2;
                    double d3 = 1.0 / d2;
                    if (d3 > 1.0) {
                        d3 = 1.0;
                    }
                    d0 *= d3;
                    d1 *= d3;
                    d0 *= 0.05;
                    d1 *= 0.05;
                    d0 *= (double)(1.0f - entity.field_70144_Y);
                    d1 *= (double)(1.0f - entity.field_70144_Y);
                    if (entity.field_70153_n == null) {
                        entity.field_70159_w += -d0;
                        entity.field_70179_y += -d1;
                    }
                    if (this.field_70153_n == null) {
                        this.field_70159_w += d0;
                        this.field_70179_y += d1;
                    }
                }
            }
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeDouble(this.field_70165_t);
        buffer.writeDouble(this.field_70163_u);
        buffer.writeDouble(this.field_70161_v);
        buffer.writeDouble(this.field_70159_w);
        buffer.writeDouble(this.field_70181_x);
        buffer.writeDouble(this.field_70179_y);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.func_70107_b(additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble());
        this.func_70016_h(additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble());
    }

    public void startFading() {
        this.fadeAge = 1;
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            for (EntityPlayer other : this.field_70170_p.field_73010_i) {
                double d2;
                double d1;
                double d0;
                if (other == null || other.field_70170_p != this.field_70170_p || !((d0 = this.field_70165_t - other.field_70165_t) * d0 + (d1 = this.field_70163_u - other.field_70163_u) * d1 + (d2 = this.field_70161_v - other.field_70161_v) * d2 < 4096.0)) continue;
                Tumbleweed.network.sendTo((IMessage)new MessageFade(this.func_145782_y()), (EntityPlayerMP)other);
            }
        }
    }

    public boolean isNotColliding() {
        return this.field_70170_p.func_72917_a(this.field_70121_D, (Entity)this) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D);
    }

    public float getWindX() {
        return Tumbleweed.windX * this.getWindModX();
    }

    public float getWindZ() {
        return Tumbleweed.windZ * this.getWindModZ();
    }

    public int getSize() {
        return this.field_70180_af.func_75679_c(5);
    }

    public float getWindModX() {
        return this.field_70180_af.func_111145_d(6);
    }

    public float getWindModZ() {
        return this.field_70180_af.func_111145_d(7);
    }
}

