/*
 * Decompiled with CFR 0.152.
 */
package tumbleweed.client;

import java.nio.FloatBuffer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import org.lwjgl.BufferUtils;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Quaternion;
import tumbleweed.client.ModelTumbleweed;
import tumbleweed.common.EntityTumbleweed;

public class RenderTumbleweed
extends Render<EntityTumbleweed> {
    private static final ResourceLocation texture = new ResourceLocation("tumbleweed", "textures/entity/tumbleweed.png");
    private ModelTumbleweed tumbleweed = new ModelTumbleweed();
    private int lastV = this.tumbleweed.getV();

    public RenderTumbleweed(RenderManager manager) {
        super(manager);
    }

    public void doRender(EntityTumbleweed entity, double x, double y, double z, float p_76986_8_, float partialTicks) {
        if (this.lastV != this.tumbleweed.getV()) {
            this.tumbleweed = new ModelTumbleweed();
            this.lastV = this.tumbleweed.getV();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        float alpha = 0.7f;
        float ageFade = 80.0f;
        if (entity.fadeAge > 1) {
            alpha -= (float)entity.fadeAge / ageFade;
        }
        if ((double)alpha < 0.0) {
            alpha = 0.0f;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 0.25f), (float)((float)z));
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)16);
        RenderTumbleweed.toMatrix(RenderTumbleweed.slerp(entity.prevQuat, entity.quat, partialTicks)).store(buffer);
        buffer.flip();
        GlStateManager.func_179110_a((FloatBuffer)buffer);
        float size = 1.0f + (float)entity.getSize() * 0.125f;
        GlStateManager.func_179152_a((float)size, (float)size, (float)size);
        this.func_110776_a(texture);
        this.tumbleweed.func_78088_a(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        super.func_76986_a((Entity)entity, x, y, z, p_76986_8_, partialTicks);
    }

    protected ResourceLocation getEntityTexture(EntityTumbleweed entity) {
        return texture;
    }

    private static Matrix4f toMatrix(Quaternion quat) {
        Matrix4f matrix = new Matrix4f();
        float xx = quat.x * quat.x;
        float xy = quat.x * quat.y;
        float xz = quat.x * quat.z;
        float xw = quat.x * quat.w;
        float yy = quat.y * quat.y;
        float yz = quat.y * quat.z;
        float yw = quat.y * quat.w;
        float zz = quat.z * quat.z;
        float zw = quat.z * quat.w;
        matrix.m00 = 1.0f - 2.0f * (yy + zz);
        matrix.m10 = 2.0f * (xy - zw);
        matrix.m20 = 2.0f * (xz + yw);
        matrix.m30 = 0.0f;
        matrix.m01 = 2.0f * (xy + zw);
        matrix.m11 = 1.0f - 2.0f * (xx + zz);
        matrix.m21 = 2.0f * (yz - xw);
        matrix.m31 = 0.0f;
        matrix.m02 = 2.0f * (xz - yw);
        matrix.m12 = 2.0f * (yz + xw);
        matrix.m22 = 1.0f - 2.0f * (xx + yy);
        matrix.m32 = 0.0f;
        matrix.m03 = 0.0f;
        matrix.m13 = 0.0f;
        matrix.m23 = 0.0f;
        matrix.m33 = 1.0f;
        matrix.transpose();
        return matrix;
    }

    private static Quaternion slerp(Quaternion start, Quaternion end, float alpha) {
        Quaternion result = new Quaternion();
        float d = start.x * end.x + start.y * end.y + start.z * end.z + start.w * end.w;
        float absDot = d < 0.0f ? -d : d;
        float scale0 = 1.0f - alpha;
        float scale1 = alpha;
        if ((double)(1.0f - absDot) > 0.1) {
            float angle = (float)Math.acos(absDot);
            float invSinTheta = 1.0f / (float)Math.sin(angle);
            scale0 = (float)Math.sin((1.0f - alpha) * angle) * invSinTheta;
            scale1 = (float)Math.sin(alpha * angle) * invSinTheta;
        }
        if (d < 0.0f) {
            scale1 = -scale1;
        }
        result.x = scale0 * start.x + scale1 * end.x;
        result.y = scale0 * start.y + scale1 * end.y;
        result.z = scale0 * start.z + scale1 * end.z;
        result.w = scale0 * start.w + scale1 * end.w;
        return result;
    }

    public static class Factory
    implements IRenderFactory<EntityTumbleweed> {
        public Render<? super EntityTumbleweed> createRenderFor(RenderManager manager) {
            return new RenderTumbleweed(manager);
        }
    }
}

