/*
 * Decompiled with CFR 0.152.
 */
package tumbleweed.common;

import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import tumbleweed.Tumbleweed;
import tumbleweed.common.Config;
import tumbleweed.common.EntityTumbleweed;
import tumbleweed.common.MessageWind;

public class CommonEventHandler {
    private static final int MOB_COUNT_DIV = (int)Math.pow(17.0, 2.0);
    private int ticks;

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        WorldServer world = (WorldServer)event.world;
        if (event.phase == TickEvent.Phase.END && world.field_73011_w.func_177502_q() == 0) {
            if (this.ticks % 200 == 0) {
                HashSet eligibleChunksForSpawning = Sets.newHashSet();
                int i = 0;
                for (EntityPlayer entityplayer : world.field_73010_i) {
                    if (entityplayer.func_175149_v()) continue;
                    int j = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
                    int k = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
                    int l = 8;
                    for (int i1 = -l; i1 <= l; ++i1) {
                        for (int j1 = -l; j1 <= l; ++j1) {
                            boolean flag = i1 == -l || i1 == l || j1 == -l || j1 == l;
                            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i1 + j, j1 + k);
                            if (eligibleChunksForSpawning.contains(chunkcoordintpair)) continue;
                            ++i;
                            if (flag || !world.func_175723_af().func_177730_a(chunkcoordintpair)) continue;
                            eligibleChunksForSpawning.add(chunkcoordintpair);
                        }
                    }
                }
                BlockPos spawnPoint = world.func_175694_M();
                int j4 = world.func_72907_a(EntityTumbleweed.class);
                int k4 = 35 * i / MOB_COUNT_DIV;
                for (ChunkCoordIntPair chunkcoordintpair : eligibleChunksForSpawning) {
                    int z;
                    int y;
                    int x;
                    if (j4 > k4) break;
                    if (!(world.field_73012_v.nextFloat() < 0.4f)) continue;
                    BlockPos blockpos = CommonEventHandler.getRandomChunkPosition((World)world, chunkcoordintpair.field_77276_a, chunkcoordintpair.field_77275_b);
                    BlockPos deadBush = null;
                    int r = 4;
                    for (x = -r; x < r; ++x) {
                        block5: for (y = -r; y < r; ++y) {
                            for (z = -r; z < r; ++z) {
                                BlockPos check = new BlockPos(blockpos.func_177958_n() + x, blockpos.func_177956_o() + y, blockpos.func_177952_p() + z);
                                Block block = world.func_180495_p(check).func_177230_c();
                                if (block != Blocks.field_150330_I || world.func_175699_k(check) <= 8) continue;
                                deadBush = check;
                                continue block5;
                            }
                        }
                    }
                    if (deadBush == null || world.func_175636_b((double)(x = deadBush.func_177958_n()), (double)(y = deadBush.func_177956_o()), (double)(z = deadBush.func_177952_p()), 24.0) || !(spawnPoint.func_177954_c((double)x, (double)y, (double)z) >= 576.0)) continue;
                    BiomeGenBase biome = world.func_180494_b(deadBush);
                    if (!(biome.field_76750_F > 1.8f) || biome.field_76751_G != 0.0f) continue;
                    EntityTumbleweed entity = new EntityTumbleweed((World)world);
                    entity.func_70012_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 0.0f, 0.0f);
                    if (!entity.isNotColliding()) continue;
                    ++j4;
                    world.func_72838_d((Entity)entity);
                }
            }
            if (this.ticks % 2400 == 0) {
                if (world.field_73012_v.nextBoolean()) {
                    Tumbleweed.windX *= -1.0f;
                }
                if (world.field_73012_v.nextBoolean()) {
                    Tumbleweed.windZ *= -1.0f;
                }
                Tumbleweed.network.sendToAll((IMessage)new MessageWind(Tumbleweed.windX, Tumbleweed.windZ));
            }
            ++this.ticks;
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Tumbleweed.network.sendTo((IMessage)new MessageWind(Tumbleweed.windX, Tumbleweed.windZ), (EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("tumbleweed")) {
            Config.load();
        }
    }

    private static BlockPos getRandomChunkPosition(World worldIn, int x, int z) {
        Chunk chunk = worldIn.func_72964_e(x, z);
        int i = x * 16 + worldIn.field_73012_v.nextInt(16);
        int j = z * 16 + worldIn.field_73012_v.nextInt(16);
        int k = chunk.func_177433_f(new BlockPos(i, 0, j)) + 1;
        return new BlockPos(i, k, j);
    }
}

