/*
 * Decompiled with CFR 0.152.
 */
package net.konwboy.tumbleweed.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.konwboy.tumbleweed.Tumbleweed;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;

public class Config {
    public static Configuration config;
    private static List<WeightedItem> weightedItems;
    private static int totalWeight;
    private static double spawnChance;
    private static Set<ResourceLocation> biomeWhitelist;
    private static Set<Metadata> spawningBlocks;
    private static final double DEFAULT_CHANCE = 0.4;
    private static final String[] DEFAULT_DROPS;
    private static final String[] DEFAULT_BLOCKS;

    public static void init(File file) {
        if (config == null) {
            config = new Configuration(file);
            Config.load();
        }
    }

    public static void load() {
        Metadata meta;
        weightedItems.clear();
        biomeWhitelist.clear();
        spawningBlocks.clear();
        totalWeight = 0;
        Property itemConfig = config.get("general", "Drops", DEFAULT_DROPS);
        itemConfig.setComment("These items will drop from tumbleweed upon destroying.\n<weight> <mod>:<item>:[metadata] [amount]");
        if (itemConfig.isList()) {
            for (String s : itemConfig.getStringList()) {
                String[] itemData = s.split(" ");
                if (itemData.length < 2) continue;
                double weight = Double.parseDouble(itemData[0]);
                meta = Config.getMetadata(itemData[1]);
                if (meta == null || !Item.field_150901_e.func_148741_d((Object)meta.id)) {
                    Tumbleweed.logger.log(Level.WARN, "Item {} is invalid.", new Object[]{itemData[1]});
                    continue;
                }
                int amount = 1;
                if (itemData.length >= 3) {
                    try {
                        amount = Integer.parseInt(itemData[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                weightedItems.add(new WeightedItem(Config.getMetadata(itemData[1]), amount, weight));
                totalWeight = (int)((double)totalWeight + weight);
            }
        }
        Property chanceConfig = config.get("general", "Chance", 0.4);
        chanceConfig.setComment("The chance of a tumbleweed spawning in a chunk.");
        spawnChance = chanceConfig.getDouble();
        Property biomesConfig = config.get("general", "Biome Whitelist", new String[0]);
        biomesConfig.setComment("If not empty, tumbleweeds spawn ONLY in the specified biomes. Else they appear in all hot, dry biomes.\nExample entry: minecraft:desert");
        if (biomesConfig.isList()) {
            for (String entry : biomesConfig.getStringList()) {
                ResourceLocation id = new ResourceLocation(entry);
                if (Biome.field_185377_q.func_148741_d((Object)id)) {
                    biomeWhitelist.add(id);
                    continue;
                }
                Tumbleweed.logger.log(Level.WARN, "Biome {} doesn't exist.", new Object[]{id});
            }
        }
        Property blockConfig = config.get("general", "Spawning Blocks", DEFAULT_BLOCKS);
        blockConfig.setComment("The blocks in which tumbleweeds can spawn in.\n<mod>:<block>:[metadata]");
        if (blockConfig.isList()) {
            for (String entry : blockConfig.getStringList()) {
                meta = Config.getMetadata(entry);
                if (meta == null || !Block.field_149771_c.func_148741_d((Object)meta.id)) {
                    Tumbleweed.logger.log(Level.WARN, "Block {} is invalid.", new Object[]{entry});
                    continue;
                }
                spawningBlocks.add(meta);
            }
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static ItemStack getRandomItem() {
        double randomWeight = (double)totalWeight * Math.random();
        double countedWeight = 0.0;
        for (WeightedItem weightedItem : weightedItems) {
            Item item;
            if (!((countedWeight += weightedItem.getWeight()) >= randomWeight) || (item = (Item)Item.field_150901_e.func_82594_a((Object)weightedItem.meta.id)) == null) continue;
            return new ItemStack(item, weightedItem.amount, weightedItem.meta.meta);
        }
        return null;
    }

    public static double getSpawnChance() {
        return spawnChance;
    }

    public static Set<ResourceLocation> getBiomeWhitelist() {
        return biomeWhitelist;
    }

    public static Set<Metadata> getSpawningBlocks() {
        return spawningBlocks;
    }

    @Nullable
    private static Metadata getMetadata(String id) {
        String[] split = id.split(":");
        if (split.length < 2) {
            return null;
        }
        int meta = 0;
        if (split.length >= 3) {
            try {
                meta = Integer.parseInt(split[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Metadata(new ResourceLocation(split[0], split[1]), meta);
    }

    static {
        weightedItems = Lists.newArrayList();
        biomeWhitelist = Sets.newHashSet();
        spawningBlocks = Sets.newHashSet();
        DEFAULT_DROPS = new String[]{"3 minecraft:bone", "3 minecraft:deadbush", "3 minecraft:string", "3 minecraft:feather", "3 minecraft:wheat", "3 minecraft:stick", "3 minecraft:reeds", "2 minecraft:melon_seeds", "2 minecraft:pumpkin_seeds", "2 minecraft:gold_nugget", "1 minecraft:name_tag", "1 minecraft:saddle", "1 minecraft:emerald", "1 minecraft:diamond", "1 minecraft:iron_ingot", "1 minecraft:gold_ingot"};
        DEFAULT_BLOCKS = new String[]{"minecraft:deadbush"};
    }

    private static class WeightedItem {
        private final Metadata meta;
        private final int amount;
        private final double weight;

        @ConstructorProperties(value={"meta", "amount", "weight"})
        public WeightedItem(Metadata meta, int amount, double weight) {
            this.meta = meta;
            this.amount = amount;
            this.weight = weight;
        }

        public Metadata getMeta() {
            return this.meta;
        }

        public int getAmount() {
            return this.amount;
        }

        public double getWeight() {
            return this.weight;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WeightedItem)) {
                return false;
            }
            WeightedItem other = (WeightedItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Metadata this$meta = this.getMeta();
            Metadata other$meta = other.getMeta();
            if (this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta)) {
                return false;
            }
            if (this.getAmount() != other.getAmount()) {
                return false;
            }
            return Double.compare(this.getWeight(), other.getWeight()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof WeightedItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Metadata $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            result = result * 59 + this.getAmount();
            long $weight = Double.doubleToLongBits(this.getWeight());
            result = result * 59 + (int)($weight >>> 32 ^ $weight);
            return result;
        }

        public String toString() {
            return "Config.WeightedItem(meta=" + this.getMeta() + ", amount=" + this.getAmount() + ", weight=" + this.getWeight() + ")";
        }
    }

    public static class Metadata {
        private final ResourceLocation id;
        private final int meta;

        @ConstructorProperties(value={"id", "meta"})
        public Metadata(ResourceLocation id, int meta) {
            this.id = id;
            this.meta = meta;
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public int getMeta() {
            return this.meta;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metadata)) {
                return false;
            }
            Metadata other = (Metadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ResourceLocation this$id = this.getId();
            ResourceLocation other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            return this.getMeta() == other.getMeta();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Metadata;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ResourceLocation $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            result = result * 59 + this.getMeta();
            return result;
        }

        public String toString() {
            return "Config.Metadata(id=" + this.getId() + ", meta=" + this.getMeta() + ")";
        }
    }
}

