/*
 * Decompiled with CFR 0.152.
 */
package net.konwboy.tumbleweed.common;

import com.google.common.base.Predicate;
import java.util.List;
import net.konwboy.tumbleweed.Tumbleweed;
import net.konwboy.tumbleweed.client.RenderTumbleweed;
import net.konwboy.tumbleweed.common.Config;
import net.konwboy.tumbleweed.common.MessageFade;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockWall;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.Vector4f;

public class EntityTumbleweed
extends Entity {
    private static final int FADE_AFTER = 2400;
    public static final int MAX_FADE = 80;
    private static final int DESPAWN_RANGE = 110;
    private static final float BASE_SIZE = 0.75f;
    private static final DataParameter<Integer> SIZE = EntityDataManager.func_187226_a(EntityTumbleweed.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> CUSTOM_WIND_ENABLED = EntityDataManager.func_187226_a(EntityTumbleweed.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> CUSTOM_WIND_X = EntityDataManager.func_187226_a(EntityTumbleweed.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> CUSTOM_WIND_Z = EntityDataManager.func_187226_a(EntityTumbleweed.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> CAN_DESPAWN = EntityDataManager.func_187226_a(EntityTumbleweed.class, (DataSerializer)DataSerializers.field_187198_h);
    private int age;
    public int fadeAge;
    public float field_70140_Q;
    public float field_82151_R;
    private int nextStepDistance;
    private int currentSize;
    private int groundTicks;
    public float rot1;
    public float rot2;
    public float rot3;
    private float windModX;
    private float windModZ;
    @SideOnly(value=Side.CLIENT)
    public Quaternion quat;
    @SideOnly(value=Side.CLIENT)
    public Quaternion prevQuat;

    public EntityTumbleweed(World world) {
        super(world);
        this.func_70105_a(0.75f, 0.75f);
        this.field_70144_Y = 0.95f;
        this.field_70156_m = true;
        this.windModX = 1.2f - 0.4f * this.field_70170_p.field_73012_v.nextFloat();
        this.windModZ = 1.2f - 0.4f * this.field_70170_p.field_73012_v.nextFloat();
        if (this.field_70170_p.field_72995_K) {
            this.rot1 = 360.0f * this.field_70170_p.field_73012_v.nextFloat();
            this.rot2 = 360.0f * this.field_70170_p.field_73012_v.nextFloat();
            this.rot3 = 360.0f * this.field_70170_p.field_73012_v.nextFloat();
            this.quat = new Quaternion();
            this.prevQuat = new Quaternion();
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SIZE, (Object)(-2 + this.field_70170_p.field_73012_v.nextInt(5)));
        this.field_70180_af.func_187214_a(CUSTOM_WIND_ENABLED, (Object)false);
        this.field_70180_af.func_187214_a(CUSTOM_WIND_X, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(CUSTOM_WIND_Z, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(CAN_DESPAWN, (Object)true);
    }

    protected void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("Size", this.getSize());
        tagCompound.func_74757_a("CustomWindEnabled", this.getCustomWindEnabled());
        tagCompound.func_74776_a("CustomWindX", this.getCustomWindX());
        tagCompound.func_74776_a("CustomWindZ", this.getCustomWindZ());
        tagCompound.func_74757_a("CanDespawn", this.getCanDespawn());
    }

    protected void func_70037_a(NBTTagCompound tagCompound) {
        if (tagCompound.func_74764_b("Size")) {
            this.field_70180_af.func_187227_b(SIZE, (Object)tagCompound.func_74762_e("Size"));
        }
        if (tagCompound.func_74764_b("CustomWindEnabled")) {
            this.field_70180_af.func_187227_b(CUSTOM_WIND_ENABLED, (Object)tagCompound.func_74767_n("CustomWindEnabled"));
        }
        if (tagCompound.func_74764_b("CustomWindX")) {
            this.field_70180_af.func_187227_b(CUSTOM_WIND_X, (Object)Float.valueOf(tagCompound.func_74760_g("CustomWindX")));
        }
        if (tagCompound.func_74764_b("CustomWindZ")) {
            this.field_70180_af.func_187227_b(CUSTOM_WIND_Z, (Object)Float.valueOf(tagCompound.func_74760_g("CustomWindZ")));
        }
        if (tagCompound.func_74764_b("CanDespawn")) {
            this.field_70180_af.func_187227_b(CAN_DESPAWN, (Object)tagCompound.func_74767_n("CanDespawn"));
        }
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return null;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    public void func_70071_h_() {
        float windZ;
        super.func_70071_h_();
        float size = 0.75f + (float)this.getSize() * 0.125f;
        if (this.currentSize != this.getSize()) {
            this.currentSize = this.getSize();
            this.func_70105_a(size, size);
        }
        if (this.func_184187_bx() != null) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            return;
        }
        if (!this.func_70090_H()) {
            this.field_70181_x -= 0.012;
        }
        double x = this.field_70159_w;
        double y = this.field_70181_x;
        double z = this.field_70179_y;
        boolean ground = this.field_70122_E;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        float windX = this.getCustomWindEnabled() ? this.getCustomWindX() : Tumbleweed.windX * this.windModX;
        float f = windZ = this.getCustomWindEnabled() ? this.getCustomWindZ() : Tumbleweed.windZ * this.windModZ;
        if (this.func_70090_H()) {
            this.field_70181_x += 0.02;
            this.field_70159_w *= 0.95;
            this.field_70179_y *= 0.95;
        } else if (windX != 0.0f || windZ != 0.0f) {
            this.field_70159_w = windX;
            this.field_70179_y = windZ;
        }
        if (this.field_70170_p.field_72995_K) {
            --this.groundTicks;
            if (!ground && this.field_70122_E || this.func_70090_H()) {
                this.groundTicks = 10;
            } else if (this.getCustomWindEnabled()) {
                this.groundTicks = 5;
            }
            double div = 5.0 * (double)size - (double)this.groundTicks / 5.0;
            double rotX = Math.PI * 2 * this.field_70159_w / div;
            double rotZ = Math.PI * -2 * this.field_70179_y / div;
            this.prevQuat = this.quat;
            RenderTumbleweed.CURRENT.setFromAxisAngle(new Vector4f(1.0f, 0.0f, 0.0f, (float)rotZ));
            Quaternion.mul((Quaternion)this.quat, (Quaternion)RenderTumbleweed.CURRENT, (Quaternion)this.quat);
            RenderTumbleweed.CURRENT.setFromAxisAngle(new Vector4f(0.0f, 0.0f, 1.0f, (float)rotX));
            Quaternion.mul((Quaternion)this.quat, (Quaternion)RenderTumbleweed.CURRENT, (Quaternion)this.quat);
        }
        if (this.field_70122_E) {
            this.field_70181_x = (double)Math.abs(windX) >= 0.05 || (double)Math.abs(windZ) >= 0.05 ? Math.max(-y * 0.7, 0.24 - (double)this.getSize() * 0.02) : -y * 0.7;
        }
        if (this.field_70123_F) {
            this.field_70159_w = -x * 0.4;
            this.field_70179_y = -z * 0.4;
        }
        this.field_70159_w *= 0.98;
        this.field_70181_x *= 0.98;
        this.field_70179_y *= 0.98;
        if (Math.abs(this.field_70159_w) < 0.005) {
            this.field_70159_w = 0.0;
        }
        if (Math.abs(this.field_70181_x) < 0.005) {
            this.field_70181_x = 0.0;
        }
        if (Math.abs(this.field_70179_y) < 0.005) {
            this.field_70179_y = 0.0;
        }
        this.collideWithNearbyEntities();
        if (!this.field_70170_p.field_72995_K) {
            ++this.age;
            this.despawnEntity();
        }
        if (this.fadeAge > 0) {
            ++this.fadeAge;
            if (this.fadeAge > 80) {
                this.func_70106_y();
            }
        }
    }

    private void despawnEntity() {
        if (!this.getCanDespawn()) {
            this.age = 0;
            return;
        }
        EntityPlayer entity = this.field_70170_p.func_72890_a((Entity)this, 110.0);
        if (entity == null) {
            this.func_70106_y();
        }
        if (this.age > 2400) {
            this.startFading();
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            this.func_70018_K();
            SoundType sound = SoundType.field_185850_c;
            this.func_184185_a(sound.func_185845_c(), (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
            ItemStack item = Config.getRandomItem();
            if (item != null) {
                EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, item);
                entityitem.field_70159_w = 0.0;
                entityitem.field_70181_x = 0.2;
                entityitem.field_70179_y = 0.0;
                entityitem.func_174869_p();
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
        }
        return true;
    }

    public boolean func_85031_j(Entity entityIn) {
        return entityIn instanceof EntityPlayer && this.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)entityIn)), 0.0f);
    }

    public void func_70091_d(double x, double y, double z) {
        if (this.field_70145_X) {
            this.func_174826_a(this.func_174813_aQ().func_72317_d(x, y, z));
            this.func_174829_m();
        } else {
            IBlockState state1;
            Block block1;
            double d0 = this.field_70165_t;
            double d1 = this.field_70163_u;
            double d2 = this.field_70161_v;
            if (this.field_70134_J) {
                this.field_70134_J = false;
                x *= 0.25;
                y *= 0.05;
                z *= 0.25;
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            double d3 = x;
            double d4 = y;
            double d5 = z;
            List list1 = this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_72321_a(x, y, z));
            for (AxisAlignedBB axisalignedbb1 : list1) {
                y = axisalignedbb1.func_72323_b(this.func_174813_aQ(), y);
            }
            this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, y, 0.0));
            for (AxisAlignedBB axisalignedbb2 : list1) {
                x = axisalignedbb2.func_72316_a(this.func_174813_aQ(), x);
            }
            this.func_174826_a(this.func_174813_aQ().func_72317_d(x, 0.0, 0.0));
            for (AxisAlignedBB axisalignedbb13 : list1) {
                z = axisalignedbb13.func_72322_c(this.func_174813_aQ(), z);
            }
            this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, 0.0, z));
            this.func_174829_m();
            this.field_70123_F = d3 != x || d5 != z;
            this.field_70124_G = d4 != y;
            this.field_70122_E = this.field_70124_G && d4 < 0.0;
            this.field_70132_H = this.field_70123_F || this.field_70124_G;
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)(this.field_70163_u - 0.2));
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            BlockPos blockpos = new BlockPos(i, j, k);
            IBlockState state = this.field_70170_p.func_180495_p(blockpos);
            Block block = state.func_177230_c();
            if (state.func_177230_c() == Blocks.field_150350_a && ((block1 = (state1 = this.field_70170_p.func_180495_p(blockpos.func_177977_b())).func_177230_c()) instanceof BlockFence || block1 instanceof BlockWall || block1 instanceof BlockFenceGate)) {
                state = state1;
                blockpos = blockpos.func_177977_b();
            }
            this.func_184231_a(y, this.field_70122_E, state, blockpos);
            if (d3 != x) {
                this.field_70159_w = 0.0;
            }
            if (d5 != z) {
                this.field_70179_y = 0.0;
            }
            if (d4 != y) {
                block.func_176216_a(this.field_70170_p, (Entity)this);
                if (block == Blocks.field_150458_ak && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73012_v.nextFloat() < 0.7f) {
                    if (!this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                        return;
                    }
                    this.field_70170_p.func_175656_a(blockpos, Blocks.field_150346_d.func_176223_P());
                }
            }
            double d15 = this.field_70165_t - d0;
            double d16 = this.field_70163_u - d1;
            double d17 = this.field_70161_v - d2;
            if (block != Blocks.field_150468_ap) {
                d16 = 0.0;
            }
            if (this.field_70122_E) {
                block.func_176199_a(this.field_70170_p, blockpos, (Entity)this);
            }
            this.field_70140_Q = (float)((double)this.field_70140_Q + (double)MathHelper.func_76133_a((double)(d15 * d15 + d17 * d17)) * 0.6);
            this.field_82151_R = (float)((double)this.field_82151_R + (double)MathHelper.func_76133_a((double)(d15 * d15 + d16 * d16 + d17 * d17)) * 0.6);
            if (this.field_82151_R > (float)this.nextStepDistance && state.func_185904_a() != Material.field_151579_a) {
                this.nextStepDistance = (int)this.field_82151_R + 1;
                if (this.func_70090_H()) {
                    float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w * 0.2 + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y * 0.2)) * 0.35f;
                    if (f > 1.0f) {
                        f = 1.0f;
                    }
                    this.func_184185_a(this.func_184184_Z(), f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                }
                if (!state.func_185904_a().func_76224_d()) {
                    SoundType sound = SoundType.field_185850_c;
                    this.func_184185_a(sound.func_185844_d(), sound.func_185843_a() * 0.15f, sound.func_185847_b());
                }
            }
            try {
                this.func_145775_I();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Checking entity block collision");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being checked for collision");
                this.func_85029_a(crashreportcategory);
                throw new ReportedException(crashreport);
            }
        }
    }

    private void collideWithNearbyEntities() {
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b(0.2, 0.0, 0.2), (Predicate)new Predicate<Entity>(){

            public boolean apply(Entity p_apply_1_) {
                return p_apply_1_.func_70104_M();
            }
        });
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                this.collision(entity);
            }
        }
    }

    private void collision(Entity entity) {
        if (!(this.func_184196_w(entity) || this.func_184187_bx() == entity || this.field_70145_X || entity.field_70145_X)) {
            if (!this.field_70170_p.field_72995_K && entity instanceof EntityMinecart && ((EntityMinecart)entity).func_184264_v() == EntityMinecart.Type.RIDEABLE && entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y > 0.01 && entity.func_184188_bt().isEmpty() && this.func_184187_bx() == null) {
                this.func_184220_m(entity);
                this.field_70181_x += 0.25;
                this.field_70133_I = true;
            } else {
                double dx = this.field_70165_t - entity.field_70165_t;
                double dz = this.field_70161_v - entity.field_70161_v;
                double dmax = MathHelper.func_76132_a((double)dx, (double)dz);
                if (dmax >= 0.01) {
                    dmax = MathHelper.func_76133_a((double)dmax);
                    dx /= dmax;
                    dz /= dmax;
                    double d3 = 1.0 / dmax;
                    if (d3 > 1.0) {
                        d3 = 1.0;
                    }
                    dx *= d3;
                    dz *= d3;
                    dx *= 0.05;
                    dz *= 0.05;
                    dx *= (double)(1.0f - entity.field_70144_Y);
                    dz *= (double)(1.0f - entity.field_70144_Y);
                    if (entity.func_184188_bt().isEmpty()) {
                        entity.field_70159_w += -dx;
                        entity.field_70179_y += -dz;
                    }
                    if (this.func_184188_bt().isEmpty()) {
                        this.field_70159_w += dx;
                        this.field_70179_y += dz;
                    }
                }
            }
        }
    }

    public void startFading() {
        if (this.fadeAge > 0) {
            return;
        }
        this.fadeAge = 1;
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            for (EntityPlayer other : this.field_70170_p.field_73010_i) {
                double dz;
                double dy;
                double dx;
                double distance;
                if (other == null || other.field_70170_p != this.field_70170_p || !((distance = (dx = this.field_70165_t - other.field_70165_t) * dx + (dy = this.field_70163_u - other.field_70163_u) * dy + (dz = this.field_70161_v - other.field_70161_v) * dz) < 4096.0)) continue;
                Tumbleweed.network.sendTo((IMessage)new MessageFade(this.func_145782_y()), (EntityPlayerMP)other);
            }
        }
    }

    public boolean isNotColliding() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
    }

    public int getSize() {
        return (Integer)this.field_70180_af.func_187225_a(SIZE);
    }

    public float getCustomWindX() {
        return ((Float)this.field_70180_af.func_187225_a(CUSTOM_WIND_X)).floatValue();
    }

    public float getCustomWindZ() {
        return ((Float)this.field_70180_af.func_187225_a(CUSTOM_WIND_Z)).floatValue();
    }

    public boolean getCanDespawn() {
        return (Boolean)this.field_70180_af.func_187225_a(CAN_DESPAWN);
    }

    public boolean getCustomWindEnabled() {
        return (Boolean)this.field_70180_af.func_187225_a(CUSTOM_WIND_ENABLED);
    }
}

