/*
 * Decompiled with CFR 0.152.
 */
package net.stardustlabs.cavetweaks.config;

import com.google.common.collect.ImmutableList;
import com.oroarmor.config.Config;
import com.oroarmor.config.ConfigItem;
import com.oroarmor.config.ConfigItemGroup;
import java.io.File;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

public class CaveTweaksConfig
extends Config {
    public static final ConfigItemGroup mainGroup = new CaveConfig();
    public static final List<ConfigItemGroup> configs = ImmutableList.of((Object)mainGroup);

    public CaveTweaksConfig() {
        super(configs, new File(FabricLoader.getInstance().getConfigDir().toFile(), "cave_tweaks.json"), "cave_tweaks");
    }

    public static class CaveConfig
    extends ConfigItemGroup {
        public CaveConfig() {
            super((List)ImmutableList.of((Object)((Object)new GlobalToggleConfig()), (Object)((Object)new CaveEntranceConfig()), (Object)((Object)new SpaghettiSurfaceConfig()), (Object)((Object)new SpaghettiTwistConfig())), "Cave Tweaks");
        }

        public static class GlobalToggleConfig
        extends ConfigItemGroup {
            public static final ConfigItem<Boolean> ENABLE_SPAGHETTI_2D = new ConfigItem("enable_spaghetti_2d", (Object)true, "Enable Spaghetti2D");
            public static final ConfigItem<Boolean> ENABLE_SPAGHETTI_3D = new ConfigItem("enable_spaghetti_3d", (Object)true, "Enable Spaghetti3D");
            public static final ConfigItem<Boolean> ENABLE_CHEESE = new ConfigItem("enable_cheese", (Object)true, "Enable Cheese Caves");
            public static final ConfigItem<Boolean> ENABLE_BIG_ENTRANCE = new ConfigItem("enable_big_entrance", (Object)true, "Enable Big Cave Entrances");

            public GlobalToggleConfig() {
                super((List)ImmutableList.of(ENABLE_SPAGHETTI_2D, ENABLE_SPAGHETTI_3D, ENABLE_CHEESE, ENABLE_BIG_ENTRANCE), "Global Toggles");
            }
        }

        public static class CaveEntranceConfig
        extends ConfigItemGroup {
            public static final ConfigItem<Double> ENTRANCE_BONUS_FACTOR = new ConfigItem("bonus_factor", (Object)0.105, "Bonus Factor (for layered entrances)");
            public static final ConfigItem<Double> ENTRANCE_LIMITING_FACTOR = new ConfigItem("limiting_factor", (Object)0.3325, "Limiting Factor");
            public static final ConfigItem<Double> ENTRANCE_NOISE_FACTOR = new ConfigItem("noise_factor", (Object)1.875, "Noise Factor");
            public static final ConfigItem<Double> ENTRANCE_LAYER_FACTOR = new ConfigItem("layer_factor", (Object)1.0, "Layer Power");
            public static final ConfigItem<Boolean> ENTRANCE_REDUCE_PILLARS = new ConfigItem("reduce_pillars", (Object)true, "Reduce pillars in cave entrances");
            public static final ConfigItem<Double> ENTRANCE_PILLAR_THRESHOLD = new ConfigItem("pillar_threshold", (Object)0.075, "Pillar Reduction Threshold");
            public static final ConfigItem<Double> ENTRANCE_PILLAR_REDUCTION_FACTOR = new ConfigItem("pillar_reduction_factor", (Object)5.0, "Pillar Reduction Factor");
            public static final ConfigItem<Double> ENTRANCE_MAX_PILLAR_REDUCTION = new ConfigItem("max_pillar_reduction", (Object)0.6, "Max Pillar Reduction");

            public CaveEntranceConfig() {
                super((List)ImmutableList.of(ENTRANCE_BONUS_FACTOR, ENTRANCE_LIMITING_FACTOR, ENTRANCE_NOISE_FACTOR, ENTRANCE_LAYER_FACTOR, ENTRANCE_REDUCE_PILLARS, ENTRANCE_PILLAR_THRESHOLD, ENTRANCE_PILLAR_REDUCTION_FACTOR, ENTRANCE_MAX_PILLAR_REDUCTION), "Cave Entrances");
            }
        }

        public static class SpaghettiSurfaceConfig
        extends ConfigItemGroup {
            public static final ConfigItem<Double> SPAGHETTI_SURFACE_EXPAND_FACTOR = new ConfigItem("expand_factor", (Object)-0.6125, "Expansion Factor");
            public static final ConfigItem<Double> SPAGHETTI_SURFACE_CONTRACT_FACTOR = new ConfigItem("contract_factor", (Object)1.525, "Contraction Factor");
            public static final ConfigItem<Double> SPAGHETTI_SURFACE_PRIMARY_OFFSET = new ConfigItem("primary_offset", (Object)0.265, "Clamp Bias");
            public static final ConfigItem<Double> SPAGHETTI_SURFACE_SECONDARY_OFFSET = new ConfigItem("secondary_offset", (Object)0.1725, "Secondary Clamp Bias (applied after x^2)");
            public static final ConfigItem<Double> SPAGHETTI_SURFACE_SAUCE_AMOUNT = new ConfigItem("per_block_factor", (Object)0.005, "Per Block Factor");
            public static final ConfigItem<Integer> SPAGHETTI_SURFACE_START_DEPTH = new ConfigItem("start_depth", (Object)32, "Start Depth");

            public SpaghettiSurfaceConfig() {
                super((List)ImmutableList.of(SPAGHETTI_SURFACE_EXPAND_FACTOR, SPAGHETTI_SURFACE_CONTRACT_FACTOR, SPAGHETTI_SURFACE_PRIMARY_OFFSET, SPAGHETTI_SURFACE_SECONDARY_OFFSET, SPAGHETTI_SURFACE_SAUCE_AMOUNT, SPAGHETTI_SURFACE_START_DEPTH), "Spaghetti Surface Behavior");
            }
        }

        public static class SpaghettiTwistConfig
        extends ConfigItemGroup {
            public static final ConfigItem<Double> SPAGHETTI_TWIST_VANILLA_BIAS = new ConfigItem("vanilla_bias", (Object)0.2, "Vanilla Bias");
            public static final ConfigItem<Double> SPAGHETTI_TWIST_BIAS_POWER = new ConfigItem("bias_power", (Object)0.65, "Bias Power");
            public static final ConfigItem<Double> SPAGHETTI_TWIST_MODULATOR_SCALE = new ConfigItem("modulator_scale", (Object)2.0, "Modulator Scale");
            public static final ConfigItem<Double> SPAGHETTI_TWIST_LIMITER = new ConfigItem("limiter", (Object)0.7225, "Distortion Factor");
            public static final ConfigItem<Double> SPAGHETTI_TWIST_BONUS_FACTOR = new ConfigItem("bonus_factor", (Object)1.65, "Bonus Factor (compensates for distortion)");

            public SpaghettiTwistConfig() {
                super((List)ImmutableList.of(SPAGHETTI_TWIST_VANILLA_BIAS, SPAGHETTI_TWIST_BIAS_POWER, SPAGHETTI_TWIST_MODULATOR_SCALE, SPAGHETTI_TWIST_LIMITER, SPAGHETTI_TWIST_BONUS_FACTOR), "Spaghetti Twist");
            }
        }
    }
}

