/*
 * Decompiled with CFR 0.152.
 */
package com.oroarmor.config;

import com.google.gson.JsonElement;
import com.oroarmor.config.ConfigItem;
import com.oroarmor.config.ConfigItemGroup;
import java.util.Arrays;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class ArrayConfigItem<T>
extends ConfigItem<T[]> {
    public ArrayConfigItem(String name, T[] defaultValue, String details) {
        this(name, defaultValue, details, (Consumer<ConfigItem<T[]>>)null);
    }

    public ArrayConfigItem(String name, T[] defaultValue, String details, @Nullable Consumer<ConfigItem<T[]>> onChange) {
        super(name, defaultValue, details, onChange);
        if (defaultValue[0] instanceof ArrayConfigItem) {
            throw new UnsupportedOperationException("ArrayConfigItems cannot be nested");
        }
        this.value = Arrays.copyOf(defaultValue, defaultValue.length);
    }

    @Override
    public void fromJson(JsonElement element) {
        for (int i = 0; i < element.getAsJsonArray().size(); ++i) {
            Object newValue;
            JsonElement arrayElement = element.getAsJsonArray().get(i);
            switch (this.type) {
                case BOOLEAN: {
                    newValue = arrayElement.getAsBoolean();
                    break;
                }
                case INTEGER: {
                    newValue = arrayElement.getAsInt();
                    break;
                }
                case DOUBLE: {
                    newValue = arrayElement.getAsDouble();
                    break;
                }
                case STRING: {
                    newValue = arrayElement.getAsString();
                    break;
                }
                case ENUM: {
                    newValue = Arrays.stream(((Object[])this.defaultValue)[i].getClass().getEnumConstants()).filter(val -> val.toString().equals(arrayElement.getAsString())).findFirst().get();
                    break;
                }
                case GROUP: {
                    ((ConfigItemGroup)((Object[])this.defaultValue)[i]).fromJson((JsonElement)arrayElement.getAsJsonObject());
                }
                default: {
                    return;
                }
            }
            ((Object[])this.value)[i] = newValue;
        }
        if (this.value != null) {
            this.setValue((Object[])this.value);
        }
    }

    public T getDefaultValue(int position) {
        return (T)((Object[])this.defaultValue)[position];
    }

    public T getValue(int position) {
        return (T)((Object[])this.value)[position];
    }

    public void setValue(T value, int position) {
        ((Object[])this.value)[position] = value;
    }
}

