/*
 * Decompiled with CFR 0.152.
 */
package com.oroarmor.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.oroarmor.config.ConfigItem;
import com.oroarmor.config.ConfigItemGroup;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final List<ConfigItemGroup> configs;
    private final File configFile;
    private final String id;

    public Config(List<ConfigItemGroup> configs, File configFile, String id) {
        this.configs = configs;
        this.configFile = configFile;
        this.id = id;
    }

    public List<ConfigItemGroup> getConfigs() {
        return this.configs;
    }

    public void readConfigFromFile() {
        try (FileInputStream stream = new FileInputStream(this.configFile);){
            byte[] bytes = new byte[stream.available()];
            stream.read(bytes);
            String file = new String(bytes);
            JsonObject parsed = new JsonParser().parse(file).getAsJsonObject();
            for (ConfigItemGroup cig : this.configs) {
                cig.fromJson(parsed.get(cig.getName()));
            }
        }
        catch (FileNotFoundException e) {
            this.saveConfigToFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public <T> T getValue(String path, Class<T> clazz) {
        String[] splitPath = path.split("\\.");
        ConfigItem selectedItem = this.getConfigs().stream().filter(cig -> cig.name.equals(splitPath[0])).findFirst().get();
        try {
            LinkedList<String> paths = new LinkedList<String>(Arrays.asList(splitPath));
            while (selectedItem instanceof ConfigItemGroup) {
                paths.removeFirst();
                selectedItem = ((ConfigItemGroup)selectedItem).getConfigs().stream().filter(ci -> ci.name.equals(paths.getFirst())).findFirst().get();
            }
        }
        catch (NoSuchElementException e) {
            System.err.printf("Path: %s does not exist\n", path);
            return null;
        }
        boolean validType = false;
        switch (selectedItem.getType()) {
            case BOOLEAN: {
                validType = clazz == Boolean.class;
                break;
            }
            case DOUBLE: {
                validType = clazz == Double.class;
                break;
            }
            case GROUP: {
                validType = clazz == ConfigItemGroup.class;
                break;
            }
            case INTEGER: {
                validType = clazz == Integer.class;
                break;
            }
            case ENUM: {
                validType = clazz.isEnum();
                break;
            }
            case STRING: {
                validType = clazz == String.class;
                break;
            }
        }
        if (!validType) {
            throw new IllegalArgumentException("Incorrect type " + clazz.getName() + " for " + path + ". Correct type is " + (Object)((Object)selectedItem.getType()));
        }
        return selectedItem.getValue();
    }

    public void saveConfigToFile() {
        JsonObject object = new JsonObject();
        for (ConfigItemGroup c : this.configs) {
            object.add(c.getName(), (JsonElement)c.toJson());
        }
        try (FileOutputStream stream = new FileOutputStream(this.configFile);){
            stream.write(GSON.toJson((JsonElement)object).getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return this.configFile.getName() + ": [" + this.configs.stream().map(Object::toString).collect(Collectors.joining(", ")) + "]";
    }

    public String getID() {
        return this.id;
    }
}

