/*
 * Decompiled with CFR 0.152.
 */
package com.oroarmor.config;

import com.google.gson.JsonElement;
import com.oroarmor.config.ConfigItemGroup;
import java.util.Arrays;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class ConfigItem<T> {
    protected final String name;
    protected final String details;
    protected final T defaultValue;
    protected final Type type;
    @Nullable
    protected final Consumer<ConfigItem<T>> onChange;
    protected T value;

    public ConfigItem(String name, T defaultValue, String details) {
        this(name, defaultValue, details, null);
    }

    public ConfigItem(String name, T defaultValue, String details, @Nullable Consumer<ConfigItem<T>> onChange) {
        this.name = name;
        this.details = details;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.type = Type.getTypeFrom(defaultValue);
        this.onChange = onChange;
    }

    public void fromJson(JsonElement element) {
        Object newValue;
        switch (this.type) {
            case BOOLEAN: {
                newValue = element.getAsBoolean();
                break;
            }
            case INTEGER: {
                newValue = element.getAsInt();
                break;
            }
            case DOUBLE: {
                newValue = element.getAsDouble();
                break;
            }
            case STRING: {
                newValue = element.getAsString();
                break;
            }
            case ENUM: {
                newValue = Arrays.stream(this.defaultValue.getClass().getEnumConstants()).filter(val -> val.toString().equals(element.getAsString())).findFirst().get();
                break;
            }
            case GROUP: {
                ((ConfigItemGroup)this.defaultValue).fromJson((JsonElement)element.getAsJsonObject());
            }
            default: {
                return;
            }
        }
        if (newValue != null) {
            this.setValue(newValue);
        }
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public String getDetails() {
        return this.details;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
        if (this.onChange != null) {
            this.onChange.accept(this);
        }
    }

    public String toString() {
        return this.name + ":" + this.value;
    }

    public static enum Type {
        BOOLEAN,
        INTEGER,
        DOUBLE,
        STRING,
        GROUP,
        ENUM;


        public static Type getTypeFrom(Object value) {
            if (value instanceof Boolean) {
                return BOOLEAN;
            }
            if (value instanceof Integer) {
                return INTEGER;
            }
            if (value instanceof Double) {
                return DOUBLE;
            }
            if (value instanceof String) {
                return STRING;
            }
            if (value instanceof ConfigItemGroup) {
                return GROUP;
            }
            if (value instanceof Enum) {
                return ENUM;
            }
            if (value != null && value.getClass().isArray()) {
                return Type.getTypeFrom(((Object[])value)[0]);
            }
            return null;
        }
    }
}

