/*
 * Decompiled with CFR 0.152.
 */
package com.oroarmor.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.oroarmor.config.ArrayConfigItem;
import com.oroarmor.config.ConfigItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class ConfigItemGroup
extends ConfigItem<ConfigItemGroup> {
    private final List<ConfigItem<?>> configs;

    private ConfigItemGroup() {
        super(null, null, null);
        this.configs = new ArrayList();
    }

    public ConfigItemGroup(List<ConfigItem<?>> configs, String name) {
        super(name, new ConfigItemGroup(), "");
        this.configs = configs;
    }

    @Override
    public void fromJson(JsonElement jsonConfigs) {
        JsonObject object = jsonConfigs.getAsJsonObject();
        for (Map.Entry entry : object.entrySet()) {
            for (ConfigItem<?> c : this.configs) {
                if (!c.getName().equals(entry.getKey())) continue;
                c.fromJson((JsonElement)entry.getValue());
            }
        }
    }

    public List<ConfigItem<?>> getConfigs() {
        return this.configs;
    }

    private void parseConfig(ConfigItem<?> c, JsonObject object) {
        switch (c.getType()) {
            case BOOLEAN: {
                object.addProperty(c.getName(), (Boolean)c.getValue());
                break;
            }
            case DOUBLE: 
            case INTEGER: {
                object.addProperty(c.getName(), (Number)c.getValue());
                break;
            }
            case STRING: {
                object.addProperty(c.getName(), (String)c.getValue());
                break;
            }
            case ENUM: {
                object.addProperty(c.getName(), c.getValue().toString());
                break;
            }
            case GROUP: {
                object.add(c.getName(), (JsonElement)((ConfigItemGroup)c).toJson());
            }
        }
    }

    private void parseArrayConfig(ArrayConfigItem<?> c, JsonObject object) {
        JsonArray array = new JsonArray();
        block7: for (int i = 0; i < ((Object[])c.getValue()).length; ++i) {
            switch (c.getType()) {
                case BOOLEAN: {
                    array.add((Boolean)c.getValue(i));
                    continue block7;
                }
                case DOUBLE: 
                case INTEGER: {
                    array.add((Number)c.getValue(i));
                    continue block7;
                }
                case STRING: {
                    array.add((String)c.getValue(i));
                    continue block7;
                }
                case ENUM: {
                    array.add(c.getValue(i).toString());
                    continue block7;
                }
                case GROUP: {
                    array.add((JsonElement)((ConfigItemGroup)c.getValue(i)).toJson());
                }
            }
        }
        object.add(c.getName(), (JsonElement)array);
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        for (ConfigItem<?> c : this.configs) {
            if (!(c instanceof ArrayConfigItem)) {
                this.parseConfig(c, object);
                continue;
            }
            this.parseArrayConfig((ArrayConfigItem)c, object);
        }
        return object;
    }

    @Override
    public String toString() {
        String string = this.getName() + ": [";
        StringJoiner joiner = new StringJoiner(", ");
        for (ConfigItem<?> config : this.configs) {
            String toString = config.toString();
            joiner.add(toString);
        }
        string = string + joiner.toString();
        return string + "]";
    }
}

