/*
 * Decompiled with CFR 0.152.
 */
package com.oroarmor.config.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.oroarmor.config.ArrayConfigItem;
import com.oroarmor.config.Config;
import com.oroarmor.config.ConfigItem;
import com.oroarmor.config.ConfigItemGroup;
import java.io.Serializable;
import java.util.Arrays;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class ConfigCommand {
    protected final Config config;

    public ConfigCommand(Config config) {
        this.config = config;
    }

    protected IFormattableTextComponent createItemText(ConfigItem<?> item, ConfigItemGroup group) {
        StringTextComponent configListText = new StringTextComponent("");
        boolean atDefault = item.getDefaultValue().equals(item.getValue());
        configListText.func_230529_a_((ITextComponent)new StringTextComponent("[" + I18n.func_135052_a((String)item.getDetails(), (Object[])new Object[0]) + "]"));
        configListText.func_240702_b_(" : ");
        configListText.func_230529_a_((ITextComponent)new StringTextComponent("[" + item.getValue() + "]").func_240699_a_(atDefault ? TextFormatting.GREEN : TextFormatting.DARK_GREEN).func_240700_a_(s -> s.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent((atDefault ? "At Default " : "") + "Value: " + (atDefault ? item.getDefaultValue() + ". Click to change value." : item.getValue() + ". Click to reset value.")))).func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/" + this.config.getID() + " " + group.getName() + " " + item.getName() + " " + (atDefault ? "value" : item.getDefaultValue())))));
        return configListText;
    }

    protected IFormattableTextComponent createArrayItemText(ArrayConfigItem<?> item, ConfigItemGroup group) {
        StringTextComponent configListText = new StringTextComponent("");
        boolean atDefault = Arrays.equals((Object[])item.getDefaultValue(), (Object[])item.getValue());
        configListText.func_230529_a_((ITextComponent)new StringTextComponent("[" + I18n.func_135052_a((String)item.getDetails(), (Object[])new Object[0]) + "]"));
        configListText.func_240702_b_(" : ");
        StringBuilder array = new StringBuilder();
        for (int i = 0; i < ((Object[])item.getValue()).length; ++i) {
            if (i != 0) {
                array.append(", ");
            }
            array.append(item.getValue(i));
        }
        StringBuilder defaultArray = new StringBuilder();
        for (int i = 0; i < ((Object[])item.getDefaultValue()).length; ++i) {
            if (i != 0) {
                defaultArray.append(", ");
            }
            defaultArray.append(item.getDefaultValue(i));
        }
        configListText.func_230529_a_((ITextComponent)new StringTextComponent("[" + array.toString() + "]").func_240699_a_(atDefault ? TextFormatting.GREEN : TextFormatting.DARK_GREEN).func_240700_a_(s -> s.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent((atDefault ? "At Default " : "") + "Value: " + (atDefault ? defaultArray.toString() + ". Click to change value." : array.toString() + ". Click to reset value.")))).func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/" + this.config.getID() + " " + group.getName() + " " + item.getName() + " " + (atDefault ? "value" : (Serializable)item.getDefaultValue())))));
        return configListText;
    }

    private int listConfigGroup(CommandContext<CommandSource> c, ConfigItemGroup group) {
        StringTextComponent configList = new StringTextComponent("");
        configList.func_230529_a_((ITextComponent)new StringTextComponent(group.getName() + "\n").func_240699_a_(TextFormatting.BOLD));
        for (ConfigItem<?> item : group.getConfigs()) {
            this.parseConfigItemText((IFormattableTextComponent)configList, group, item, "  ");
        }
        configList.func_240702_b_("/");
        try {
            ((CommandSource)c.getSource()).func_197035_h().func_145747_a((ITextComponent)configList, Util.field_240973_b_);
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return 1;
    }

    private int listConfigGroups(CommandContext<CommandSource> c) {
        StringTextComponent configList = new StringTextComponent("");
        for (ConfigItemGroup group : this.config.getConfigs()) {
            configList.func_230529_a_((ITextComponent)new StringTextComponent(group.getName() + "\n").func_240699_a_(TextFormatting.BOLD));
            for (ConfigItem<?> item : group.getConfigs()) {
                this.parseConfigItemText((IFormattableTextComponent)configList, group, item, "  ");
            }
            configList.func_240702_b_("/");
        }
        try {
            ((CommandSource)c.getSource()).func_197035_h().func_145747_a((ITextComponent)configList, Util.field_240973_b_);
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return 1;
    }

    protected void parseConfigItemText(IFormattableTextComponent configList, ConfigItemGroup group, ConfigItem<?> item, String padding) {
        configList.func_240702_b_(padding);
        configList.func_240702_b_("|--> ");
        if (item.getType() == ConfigItem.Type.GROUP) {
            configList.func_230529_a_((ITextComponent)new StringTextComponent(item.getName() + "\n").func_240699_a_(TextFormatting.BOLD));
            for (ConfigItem<?> item2 : ((ConfigItemGroup)item).getConfigs()) {
                this.parseConfigItemText(configList, (ConfigItemGroup)item, item2, padding + "| ");
            }
            configList.func_240702_b_(padding + "/\n");
        } else {
            configList.func_230529_a_((ITextComponent)(item instanceof ArrayConfigItem ? this.createArrayItemText((ArrayConfigItem)item, group) : this.createItemText(item, group)));
            configList.func_240702_b_("\n");
        }
    }

    protected int listItem(CommandContext<CommandSource> c, ConfigItem<?> item, ConfigItemGroup group) {
        try {
            ((CommandSource)c.getSource()).func_197035_h().func_145747_a((ITextComponent)this.createItemText(item, group), Util.field_240973_b_);
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return 1;
    }

    public void register(CommandDispatcher<CommandSource> dispatcher, boolean dedicated) {
        LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)this.config.getID()).requires(p -> p.func_197034_c(2))).executes(this::listConfigGroups);
        for (ConfigItemGroup group : this.config.getConfigs()) {
            this.parseConfigItemGroupCommand((LiteralArgumentBuilder<CommandSource>)literalArgumentBuilder, group);
        }
        dispatcher.register(literalArgumentBuilder);
    }

    protected void parseConfigItemGroupCommand(LiteralArgumentBuilder<CommandSource> literalArgumentBuilder, ConfigItemGroup group) {
        LiteralArgumentBuilder configGroupCommand = (LiteralArgumentBuilder)Commands.func_197057_a((String)group.getName()).executes(c -> this.listConfigGroup((CommandContext<CommandSource>)c, group));
        for (ConfigItem<?> item : group.getConfigs()) {
            if (item.getType() == ConfigItem.Type.GROUP) {
                this.parseConfigItemGroupCommand((LiteralArgumentBuilder<CommandSource>)configGroupCommand, (ConfigItemGroup)item);
                continue;
            }
            LiteralArgumentBuilder configItemCommand = (LiteralArgumentBuilder)Commands.func_197057_a((String)item.getName()).executes(c -> this.listItem((CommandContext<CommandSource>)c, item, group));
            if (item instanceof ArrayConfigItem) {
                RequiredArgumentBuilder arrayIndex = Commands.func_197056_a((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0, (int)((Object[])((ArrayConfigItem)item).getValue()).length));
                switch (item.getType()) {
                    case BOOLEAN: {
                        arrayIndex.then(Commands.func_197056_a((String)"boolean", (ArgumentType)BoolArgumentType.bool()).executes(c -> this.setArrayItemBoolean((CommandContext<CommandSource>)c, (ArrayConfigItem)item, group)));
                        break;
                    }
                    case DOUBLE: {
                        arrayIndex.then(Commands.func_197056_a((String)"double", (ArgumentType)DoubleArgumentType.doubleArg()).executes(c -> this.setArrayItemDouble((CommandContext<CommandSource>)c, (ArrayConfigItem)item, group)));
                        break;
                    }
                    case INTEGER: {
                        arrayIndex.then(Commands.func_197056_a((String)"int", (ArgumentType)IntegerArgumentType.integer()).executes(c -> this.setArrayItemInteger((CommandContext<CommandSource>)c, (ArrayConfigItem)item, group)));
                        break;
                    }
                    case STRING: {
                        arrayIndex.then(Commands.func_197056_a((String)"string", (ArgumentType)StringArgumentType.string()).executes(c -> this.setArrayItemString((CommandContext<CommandSource>)c, (ArrayConfigItem)item, group)));
                        break;
                    }
                    case ENUM: {
                        Enum[] enums;
                        Enum[] enumArray = enums = (Enum[])((Enum)item.getValue()).getClass().getEnumConstants();
                        int n = enumArray.length;
                        for (int i = 0; i < n; ++i) {
                            Enum _enum = enumArray[i];
                            arrayIndex.then(Commands.func_197057_a((String)_enum.toString()).executes(c -> this.setArrayItemEnum((CommandContext<CommandSource>)c, _enum, (ArrayConfigItem)item, group)));
                        }
                        break;
                    }
                }
                configItemCommand.then((ArgumentBuilder)arrayIndex);
            } else {
                switch (item.getType()) {
                    case BOOLEAN: {
                        configItemCommand.then(Commands.func_197056_a((String)"boolean", (ArgumentType)BoolArgumentType.bool()).executes(c -> this.setItemBoolean((CommandContext<CommandSource>)c, item, group)));
                        break;
                    }
                    case DOUBLE: {
                        configItemCommand.then(Commands.func_197056_a((String)"double", (ArgumentType)DoubleArgumentType.doubleArg()).executes(c -> this.setItemDouble((CommandContext<CommandSource>)c, item, group)));
                        break;
                    }
                    case INTEGER: {
                        configItemCommand.then(Commands.func_197056_a((String)"int", (ArgumentType)IntegerArgumentType.integer()).executes(c -> this.setItemInteger((CommandContext<CommandSource>)c, item, group)));
                        break;
                    }
                    case STRING: {
                        configItemCommand.then(Commands.func_197056_a((String)"string", (ArgumentType)StringArgumentType.string()).executes(c -> this.setItemString((CommandContext<CommandSource>)c, item, group)));
                        break;
                    }
                    case ENUM: {
                        Enum[] enums;
                        for (Enum _enum : enums = (Enum[])((Enum)item.getValue()).getClass().getEnumConstants()) {
                            configItemCommand.then(Commands.func_197057_a((String)_enum.toString()).executes(c -> this.setItemEnum((CommandContext<CommandSource>)c, _enum, item, group)));
                        }
                        break;
                    }
                }
            }
            configGroupCommand.then((ArgumentBuilder)configItemCommand);
        }
        literalArgumentBuilder.then((ArgumentBuilder)configGroupCommand);
    }

    protected int setItemBoolean(CommandContext<CommandSource> c, ConfigItem<Boolean> item, ConfigItemGroup group) {
        boolean result = BoolArgumentType.getBool(c, (String)"boolean");
        return this.setAndSaveConfig(c, item, result);
    }

    protected int setItemDouble(CommandContext<CommandSource> c, ConfigItem<Double> item, ConfigItemGroup group) {
        double result = DoubleArgumentType.getDouble(c, (String)"double");
        return this.setAndSaveConfig(c, item, result);
    }

    protected int setItemInteger(CommandContext<CommandSource> c, ConfigItem<Integer> item, ConfigItemGroup group) {
        int result = IntegerArgumentType.getInteger(c, (String)"int");
        return this.setAndSaveConfig(c, item, result);
    }

    private int setItemString(CommandContext<CommandSource> c, ConfigItem<String> item, ConfigItemGroup group) {
        String result = StringArgumentType.getString(c, (String)"string");
        return this.setAndSaveConfig(c, item, result);
    }

    private int setItemEnum(CommandContext<CommandSource> c, Enum<?> _enum, ConfigItem<Enum<?>> item, ConfigItemGroup group) {
        return this.setAndSaveConfig(c, item, _enum);
    }

    protected <T> int setAndSaveConfig(CommandContext<CommandSource> c, ConfigItem<T> item, T result) {
        item.setValue(result);
        this.config.saveConfigToFile();
        return 1;
    }

    protected int setArrayItemBoolean(CommandContext<CommandSource> c, ArrayConfigItem<Boolean> item, ConfigItemGroup group) {
        int index = IntegerArgumentType.getInteger(c, (String)"index");
        boolean result = BoolArgumentType.getBool(c, (String)"boolean");
        return this.setArrayAndSaveConfig(c, item, result, index);
    }

    protected int setArrayItemDouble(CommandContext<CommandSource> c, ArrayConfigItem<Double> item, ConfigItemGroup group) {
        int index = IntegerArgumentType.getInteger(c, (String)"index");
        double result = DoubleArgumentType.getDouble(c, (String)"double");
        return this.setArrayAndSaveConfig(c, item, result, index);
    }

    protected int setArrayItemInteger(CommandContext<CommandSource> c, ArrayConfigItem<Integer> item, ConfigItemGroup group) {
        int index = IntegerArgumentType.getInteger(c, (String)"index");
        int result = IntegerArgumentType.getInteger(c, (String)"int");
        return this.setArrayAndSaveConfig(c, item, result, index);
    }

    private int setArrayItemString(CommandContext<CommandSource> c, ArrayConfigItem<String> item, ConfigItemGroup group) {
        int index = IntegerArgumentType.getInteger(c, (String)"index");
        String result = StringArgumentType.getString(c, (String)"string");
        return this.setArrayAndSaveConfig(c, item, result, index);
    }

    private int setArrayItemEnum(CommandContext<CommandSource> c, Enum<?> _enum, ArrayConfigItem<Enum<?>> item, ConfigItemGroup group) {
        int index = IntegerArgumentType.getInteger(c, (String)"index");
        return this.setArrayAndSaveConfig(c, item, _enum, index);
    }

    protected <T> int setArrayAndSaveConfig(CommandContext<CommandSource> c, ArrayConfigItem<T> item, T result, int index) {
        item.setValue(result, index);
        this.config.saveConfigToFile();
        return 1;
    }
}

