/*
 * Decompiled with CFR 0.152.
 */
package com.oroarmor.config.screen;

import com.oroarmor.config.ArrayConfigItem;
import com.oroarmor.config.Config;
import com.oroarmor.config.ConfigItem;
import com.oroarmor.config.ConfigItemGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.DoubleListEntry;
import me.shedaniel.clothconfig2.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerListEntry;
import me.shedaniel.clothconfig2.gui.entries.StringListEntry;
import me.shedaniel.clothconfig2.gui.entries.SubCategoryListEntry;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class ConfigScreen {
    protected final Config config;

    public ConfigScreen(Config config) {
        this.config = config;
    }

    protected ConfigCategory createCategory(ConfigBuilder builder, String categoryName) {
        return builder.getOrCreateCategory((ITextComponent)new TranslationTextComponent(categoryName));
    }

    private void setupBooleanConfigItem(ConfigItem<Boolean> ci, ConfigCategory category, ConfigEntryBuilder entryBuilder) {
        category.addEntry(this.createBooleanConfigItem(ci, entryBuilder));
    }

    private void setupDoubleConfigItem(ConfigItem<Double> ci, ConfigCategory category, ConfigEntryBuilder entryBuilder) {
        category.addEntry(this.createDoubleConfigItem(ci, entryBuilder));
    }

    private void setupIntegerConfigItem(ConfigItem<Integer> ci, ConfigCategory category, ConfigEntryBuilder entryBuilder) {
        category.addEntry(this.createIntegerConfigItem(ci, entryBuilder));
    }

    private void setupStringConfigItem(ConfigItem<String> ci, ConfigCategory category, ConfigEntryBuilder entryBuilder) {
        category.addEntry(this.createStringConfigItem(ci, entryBuilder));
    }

    protected void setupEnumConfigItem(ConfigItem<Enum<?>> ci, ConfigCategory category, ConfigEntryBuilder entryBuilder) {
        category.addEntry(this.createEnumConfigItem(ci, entryBuilder));
    }

    private AbstractConfigListEntry<?> createBooleanConfigItem(ConfigItem<Boolean> ci, ConfigEntryBuilder entryBuilder) {
        return entryBuilder.startBooleanToggle((ITextComponent)new TranslationTextComponent(ci.getDetails()), ci.getValue().booleanValue()).setSaveConsumer(ci::setValue).setDefaultValue(ci::getDefaultValue).build();
    }

    private AbstractConfigListEntry<?> createDoubleConfigItem(ConfigItem<Double> ci, ConfigEntryBuilder entryBuilder) {
        return entryBuilder.startDoubleField((ITextComponent)new TranslationTextComponent(ci.getDetails()), ci.getValue().doubleValue()).setSaveConsumer(ci::setValue).setDefaultValue(ci::getDefaultValue).build();
    }

    private AbstractConfigListEntry<?> createIntegerConfigItem(ConfigItem<Integer> ci, ConfigEntryBuilder entryBuilder) {
        return entryBuilder.startIntField((ITextComponent)new TranslationTextComponent(ci.getDetails()), ci.getValue().intValue()).setSaveConsumer(ci::setValue).setDefaultValue(ci::getDefaultValue).build();
    }

    private AbstractConfigListEntry<?> createStringConfigItem(ConfigItem<String> ci, ConfigEntryBuilder entryBuilder) {
        return entryBuilder.startStrField((ITextComponent)new TranslationTextComponent(ci.getDetails()), ci.getValue()).setSaveConsumer(ci::setValue).setDefaultValue(ci::getDefaultValue).build();
    }

    private void setupBooleanArrayConfigItem(ArrayConfigItem<Boolean> ci, ConfigCategory category, ConfigEntryBuilder entryBuilder) {
        category.addEntry(this.createBooleanArrayConfigItem(ci, entryBuilder));
    }

    private void setupDoubleArrayConfigItem(ArrayConfigItem<Double> ci, ConfigCategory category, ConfigEntryBuilder entryBuilder) {
        category.addEntry(this.createDoubleArrayConfigItem(ci, entryBuilder));
    }

    private void setupIntegerArrayConfigItem(ArrayConfigItem<Integer> ci, ConfigCategory category, ConfigEntryBuilder entryBuilder) {
        category.addEntry(this.createIntegerArrayConfigItem(ci, entryBuilder));
    }

    private void setupStringArrayConfigItem(ArrayConfigItem<String> ci, ConfigCategory category, ConfigEntryBuilder entryBuilder) {
        category.addEntry(this.createStringArrayConfigItem(ci, entryBuilder));
    }

    protected void setupEnumArrayConfigItem(ArrayConfigItem<Enum<?>> ci, ConfigCategory category, ConfigEntryBuilder entryBuilder) {
        category.addEntry(this.createEnumArrayConfigItem(ci, entryBuilder));
    }

    private AbstractConfigListEntry<?> createBooleanArrayConfigItem(ArrayConfigItem<Boolean> ci, ConfigEntryBuilder entryBuilder) {
        ArrayList<BooleanListEntry> configs = new ArrayList<BooleanListEntry>();
        for (int i = 0; i < ((Boolean[])ci.getValue()).length; ++i) {
            int finalI = i;
            BooleanListEntry entry = entryBuilder.startBooleanToggle((ITextComponent)new TranslationTextComponent(ci.getDetails()).func_240702_b_(": " + i), ci.getValue(i).booleanValue()).setSaveConsumer(val -> ci.setValue((Boolean)val, finalI)).setDefaultValue(() -> (Boolean)ci.getDefaultValue(finalI)).build();
            configs.add(entry);
        }
        return entryBuilder.startSubCategory((ITextComponent)new TranslationTextComponent(ci.getDetails()), configs).build();
    }

    private AbstractConfigListEntry<?> createDoubleArrayConfigItem(ArrayConfigItem<Double> ci, ConfigEntryBuilder entryBuilder) {
        ArrayList<DoubleListEntry> configs = new ArrayList<DoubleListEntry>();
        for (int i = 0; i < ((Double[])ci.getValue()).length; ++i) {
            int finalI = i;
            DoubleListEntry entry = entryBuilder.startDoubleField((ITextComponent)new TranslationTextComponent(ci.getDetails()).func_240702_b_(": " + i), ci.getValue(i).doubleValue()).setSaveConsumer(val -> ci.setValue((Double)val, finalI)).setDefaultValue(() -> (Double)ci.getDefaultValue(finalI)).build();
            configs.add(entry);
        }
        return entryBuilder.startSubCategory((ITextComponent)new TranslationTextComponent(ci.getDetails()), configs).build();
    }

    private AbstractConfigListEntry<?> createIntegerArrayConfigItem(ArrayConfigItem<Integer> ci, ConfigEntryBuilder entryBuilder) {
        ArrayList<IntegerListEntry> configs = new ArrayList<IntegerListEntry>();
        for (int i = 0; i < ((Integer[])ci.getValue()).length; ++i) {
            int finalI = i;
            IntegerListEntry entry = entryBuilder.startIntField((ITextComponent)new TranslationTextComponent(ci.getDetails()).func_240702_b_(": " + i), ci.getValue(i).intValue()).setSaveConsumer(val -> ci.setValue((Integer)val, finalI)).setDefaultValue(() -> (Integer)ci.getDefaultValue(finalI)).build();
            configs.add(entry);
        }
        return entryBuilder.startSubCategory((ITextComponent)new TranslationTextComponent(ci.getDetails()), configs).build();
    }

    private AbstractConfigListEntry<?> createStringArrayConfigItem(ArrayConfigItem<String> ci, ConfigEntryBuilder entryBuilder) {
        ArrayList<StringListEntry> configs = new ArrayList<StringListEntry>();
        for (int i = 0; i < ((String[])ci.getValue()).length; ++i) {
            int finalI = i;
            StringListEntry entry = entryBuilder.startStrField((ITextComponent)new TranslationTextComponent(ci.getDetails()).func_240702_b_(": " + i), ci.getValue(i)).setSaveConsumer(val -> ci.setValue((String)val, finalI)).setDefaultValue(() -> (String)ci.getDefaultValue(finalI)).build();
            configs.add(entry);
        }
        return entryBuilder.startSubCategory((ITextComponent)new TranslationTextComponent(ci.getDetails()), configs).build();
    }

    private <T extends Enum<T>> AbstractConfigListEntry<?> createEnumConfigItem(ConfigItem<Enum<?>> ci, ConfigEntryBuilder entryBuilder) {
        return entryBuilder.startEnumSelector((ITextComponent)new TranslationTextComponent(ci.getDetails()), ((Enum[])ci.getValue().getClass().getEnumConstants())[0].getClass(), ci.getValue()).setSaveConsumer(ci::setValue).setDefaultValue(() -> (Enum)ci.getValue()).build();
    }

    private <T extends Enum<T>> AbstractConfigListEntry<?> createEnumArrayConfigItem(ArrayConfigItem<Enum<?>> ci, ConfigEntryBuilder entryBuilder) {
        ArrayList<EnumListEntry> configs = new ArrayList<EnumListEntry>();
        for (int i = 0; i < ((Enum[])ci.getValue()).length; ++i) {
            int finalI = i;
            EnumListEntry entry = entryBuilder.startEnumSelector((ITextComponent)new TranslationTextComponent(ci.getDetails()).func_240702_b_(": " + i), ((Enum[])ci.getValue(i).getClass().getEnumConstants())[0].getClass(), ci.getValue(i)).setSaveConsumer(val -> ci.setValue((Enum<?>)val, finalI)).setDefaultValue(() -> (Enum)ci.getDefaultValue(finalI)).build();
            configs.add(entry);
        }
        return entryBuilder.startSubCategory((ITextComponent)new TranslationTextComponent(ci.getDetails()), configs).build();
    }

    protected void setupConfigItem(ConfigItem<?> ci, ConfigCategory category, ConfigEntryBuilder entryBuilder) {
        if (!(ci instanceof ArrayConfigItem)) {
            switch (ci.getType()) {
                case BOOLEAN: {
                    this.setupBooleanConfigItem(ci, category, entryBuilder);
                    break;
                }
                case DOUBLE: {
                    this.setupDoubleConfigItem(ci, category, entryBuilder);
                    break;
                }
                case GROUP: {
                    List entryList = ((ConfigItemGroup)ci).getConfigs().stream().map(configItem -> this.createConfigItem((ConfigItem<?>)configItem, entryBuilder, category.getCategoryKey().getString() + "." + ci.getName())).collect(Collectors.toList());
                    SubCategoryBuilder groupCategory = entryBuilder.startSubCategory((ITextComponent)new TranslationTextComponent(category.getCategoryKey().getString() + "." + ci.getName()), entryList);
                    category.addEntry((AbstractConfigListEntry)groupCategory.build());
                    break;
                }
                case INTEGER: {
                    this.setupIntegerConfigItem(ci, category, entryBuilder);
                    break;
                }
                case STRING: {
                    this.setupStringConfigItem(ci, category, entryBuilder);
                    break;
                }
                case ENUM: {
                    this.setupEnumConfigItem(ci, category, entryBuilder);
                }
            }
        } else {
            switch (ci.getType()) {
                case BOOLEAN: {
                    this.setupBooleanArrayConfigItem((ArrayConfigItem)ci, category, entryBuilder);
                    break;
                }
                case DOUBLE: {
                    this.setupDoubleArrayConfigItem((ArrayConfigItem)ci, category, entryBuilder);
                    break;
                }
                case GROUP: {
                    ArrayList<SubCategoryListEntry> subList = new ArrayList<SubCategoryListEntry>();
                    for (int i = 0; i < ((ConfigItemGroup[])((ArrayConfigItem)ci).getValue()).length; ++i) {
                        int finalI = i;
                        List entryList = ((ConfigItemGroup)((ArrayConfigItem)ci).getValue(i)).getConfigs().stream().map(configItem -> this.createConfigItem((ConfigItem<?>)configItem, entryBuilder, category.getCategoryKey().getString() + "." + ((ConfigItemGroup)((ArrayConfigItem)ci).getValue(finalI)).getName())).collect(Collectors.toList());
                        SubCategoryBuilder groupCategory = entryBuilder.startSubCategory((ITextComponent)new TranslationTextComponent(category.getCategoryKey().getString() + "." + ((ConfigItemGroup)((ArrayConfigItem)ci).getValue(finalI)).getName()), entryList);
                        subList.add(groupCategory.build());
                    }
                    category.addEntry((AbstractConfigListEntry)entryBuilder.startSubCategory((ITextComponent)new TranslationTextComponent(category.getCategoryKey().getString() + "." + ci.getName()), subList).build());
                    break;
                }
                case INTEGER: {
                    this.setupIntegerArrayConfigItem((ArrayConfigItem)ci, category, entryBuilder);
                    break;
                }
                case STRING: {
                    this.setupStringArrayConfigItem((ArrayConfigItem)ci, category, entryBuilder);
                    break;
                }
                case ENUM: {
                    this.setupEnumArrayConfigItem((ArrayConfigItem)ci, category, entryBuilder);
                }
            }
        }
    }

    private AbstractConfigListEntry<?> createConfigItem(ConfigItem<?> ci, ConfigEntryBuilder entryBuilder, String superGroupName) {
        if (!(ci instanceof ArrayConfigItem)) {
            switch (ci.getType()) {
                case BOOLEAN: {
                    return this.createBooleanConfigItem(ci, entryBuilder);
                }
                case DOUBLE: {
                    return this.createDoubleConfigItem(ci, entryBuilder);
                }
                case INTEGER: {
                    return this.createIntegerConfigItem(ci, entryBuilder);
                }
                case STRING: {
                    return this.createStringConfigItem(ci, entryBuilder);
                }
                case ENUM: {
                    return this.createEnumConfigItem(ci, entryBuilder);
                }
                case GROUP: {
                    List subItems = ((ConfigItemGroup)ci).getConfigs().stream().map(configItem -> this.createConfigItem((ConfigItem<?>)configItem, entryBuilder, superGroupName + "." + ci.getName())).collect(Collectors.toList());
                    SubCategoryBuilder groupCategory = entryBuilder.startSubCategory((ITextComponent)new TranslationTextComponent(superGroupName + "." + ci.getName()), subItems);
                    return groupCategory.build();
                }
            }
            return null;
        }
        switch (ci.getType()) {
            case BOOLEAN: {
                return this.createBooleanArrayConfigItem((ArrayConfigItem)ci, entryBuilder);
            }
            case DOUBLE: {
                return this.createDoubleArrayConfigItem((ArrayConfigItem)ci, entryBuilder);
            }
            case INTEGER: {
                return this.createIntegerArrayConfigItem((ArrayConfigItem)ci, entryBuilder);
            }
            case STRING: {
                return this.createStringArrayConfigItem((ArrayConfigItem)ci, entryBuilder);
            }
            case ENUM: {
                return this.createEnumArrayConfigItem((ArrayConfigItem)ci, entryBuilder);
            }
            case GROUP: {
                ArrayList<SubCategoryListEntry> subList = new ArrayList<SubCategoryListEntry>();
                for (int i = 0; i < ((ConfigItemGroup[])((ArrayConfigItem)ci).getValue()).length; ++i) {
                    int finalI = i;
                    List entryList = ((ConfigItemGroup)((ArrayConfigItem)ci).getValue(i)).getConfigs().stream().map(configItem -> this.createConfigItem((ConfigItem<?>)configItem, entryBuilder, superGroupName + "." + ((ConfigItemGroup)((ArrayConfigItem)ci).getValue(finalI)).getName())).collect(Collectors.toList());
                    SubCategoryBuilder groupCategory = entryBuilder.startSubCategory((ITextComponent)new TranslationTextComponent(superGroupName + "." + ((ConfigItemGroup)((ArrayConfigItem)ci).getValue(finalI)).getName()), entryList);
                    subList.add(groupCategory.build());
                }
                return entryBuilder.startSubCategory((ITextComponent)new TranslationTextComponent(superGroupName + "." + ci.getName()), subList).build();
            }
        }
        return null;
    }
}

