/*
 * Decompiled with CFR 0.152.
 */
package net.stardustlabs.zcavetweaksforge.config;

import com.google.common.collect.ImmutableList;
import com.oroarmor.config.Config;
import com.oroarmor.config.ConfigItem;
import com.oroarmor.config.ConfigItemGroup;
import java.io.File;
import java.util.List;
import net.minecraftforge.fml.loading.FMLLoader;

public class CaveTweaksConfig
extends Config {
    public static final ConfigItemGroup mainGroup = new CaveConfig();
    public static final List<ConfigItemGroup> configs = ImmutableList.of((Object)mainGroup);

    public CaveTweaksConfig() {
        super(configs, new File(FMLLoader.getGamePath().resolve("config").toFile(), "cave_tweaks.json"), "cave_tweaks");
    }

    public static class CaveConfig
    extends ConfigItemGroup {
        public CaveConfig() {
            super((List<ConfigItem<?>>)ImmutableList.of((Object)new GlobalToggleConfig(), (Object)new CaveEntranceConfig(), (Object)new SpaghettiSurfaceConfig(), (Object)new SpaghettiTwistConfig()), "Cave Tweaks");
        }

        public static class GlobalToggleConfig
        extends ConfigItemGroup {
            public static final ConfigItem<Boolean> ENABLE_SPAGHETTI_2D = new ConfigItem<Boolean>("enable_spaghetti_2d", true, "Enable Spaghetti2D");
            public static final ConfigItem<Boolean> ENABLE_SPAGHETTI_3D = new ConfigItem<Boolean>("enable_spaghetti_3d", true, "Enable Spaghetti3D");
            public static final ConfigItem<Boolean> ENABLE_CHEESE = new ConfigItem<Boolean>("enable_cheese", true, "Enable Cheese Caves");
            public static final ConfigItem<Boolean> ENABLE_BIG_ENTRANCE = new ConfigItem<Boolean>("enable_big_entrance", true, "Enable Big Cave Entrances");

            public GlobalToggleConfig() {
                super((List<ConfigItem<?>>)ImmutableList.of(ENABLE_SPAGHETTI_2D, ENABLE_SPAGHETTI_3D, ENABLE_CHEESE, ENABLE_BIG_ENTRANCE), "Global Toggles");
            }
        }

        public static class CaveEntranceConfig
        extends ConfigItemGroup {
            public static final ConfigItem<Double> ENTRANCE_BONUS_FACTOR = new ConfigItem<Double>("bonus_factor", 0.105, "Bonus Factor (for layered entrances)");
            public static final ConfigItem<Double> ENTRANCE_LIMITING_FACTOR = new ConfigItem<Double>("limiting_factor", 0.3325, "Limiting Factor");
            public static final ConfigItem<Double> ENTRANCE_NOISE_FACTOR = new ConfigItem<Double>("noise_factor", 1.875, "Noise Factor");
            public static final ConfigItem<Double> ENTRANCE_LAYER_FACTOR = new ConfigItem<Double>("layer_factor", 1.0, "Layer Power");
            public static final ConfigItem<Boolean> ENTRANCE_REDUCE_PILLARS = new ConfigItem<Boolean>("reduce_pillars", true, "Reduce pillars in cave entrances");
            public static final ConfigItem<Double> ENTRANCE_PILLAR_THRESHOLD = new ConfigItem<Double>("pillar_threshold", 0.075, "Pillar Reduction Threshold");
            public static final ConfigItem<Double> ENTRANCE_PILLAR_REDUCTION_FACTOR = new ConfigItem<Double>("pillar_reduction_factor", 5.0, "Pillar Reduction Factor");
            public static final ConfigItem<Double> ENTRANCE_MAX_PILLAR_REDUCTION = new ConfigItem<Double>("max_pillar_reduction", 0.6, "Max Pillar Reduction");

            public CaveEntranceConfig() {
                super((List<ConfigItem<?>>)ImmutableList.of(ENTRANCE_BONUS_FACTOR, ENTRANCE_LIMITING_FACTOR, ENTRANCE_NOISE_FACTOR, ENTRANCE_LAYER_FACTOR, ENTRANCE_REDUCE_PILLARS, ENTRANCE_PILLAR_THRESHOLD, ENTRANCE_PILLAR_REDUCTION_FACTOR, ENTRANCE_MAX_PILLAR_REDUCTION), "Cave Entrances");
            }
        }

        public static class SpaghettiSurfaceConfig
        extends ConfigItemGroup {
            public static final ConfigItem<Double> SPAGHETTI_SURFACE_EXPAND_FACTOR = new ConfigItem<Double>("expand_factor", -0.6125, "Expansion Factor");
            public static final ConfigItem<Double> SPAGHETTI_SURFACE_CONTRACT_FACTOR = new ConfigItem<Double>("contract_factor", 1.525, "Contraction Factor");
            public static final ConfigItem<Double> SPAGHETTI_SURFACE_PRIMARY_OFFSET = new ConfigItem<Double>("primary_offset", 0.265, "Clamp Bias");
            public static final ConfigItem<Double> SPAGHETTI_SURFACE_SECONDARY_OFFSET = new ConfigItem<Double>("secondary_offset", 0.1725, "Secondary Clamp Bias (applied after x^2)");
            public static final ConfigItem<Double> SPAGHETTI_SURFACE_SAUCE_AMOUNT = new ConfigItem<Double>("per_block_factor", 0.005, "Per Block Factor");
            public static final ConfigItem<Integer> SPAGHETTI_SURFACE_START_DEPTH = new ConfigItem<Integer>("start_depth", 32, "Start Depth");

            public SpaghettiSurfaceConfig() {
                super((List<ConfigItem<?>>)ImmutableList.of(SPAGHETTI_SURFACE_EXPAND_FACTOR, SPAGHETTI_SURFACE_CONTRACT_FACTOR, SPAGHETTI_SURFACE_PRIMARY_OFFSET, SPAGHETTI_SURFACE_SECONDARY_OFFSET, SPAGHETTI_SURFACE_SAUCE_AMOUNT, SPAGHETTI_SURFACE_START_DEPTH), "Spaghetti Surface Behavior");
            }
        }

        public static class SpaghettiTwistConfig
        extends ConfigItemGroup {
            public static final ConfigItem<Double> SPAGHETTI_TWIST_VANILLA_BIAS = new ConfigItem<Double>("vanilla_bias", 0.2, "Vanilla Bias");
            public static final ConfigItem<Double> SPAGHETTI_TWIST_BIAS_POWER = new ConfigItem<Double>("bias_power", 0.65, "Bias Power");
            public static final ConfigItem<Double> SPAGHETTI_TWIST_MODULATOR_SCALE = new ConfigItem<Double>("modulator_scale", 2.0, "Modulator Scale");
            public static final ConfigItem<Double> SPAGHETTI_TWIST_LIMITER = new ConfigItem<Double>("limiter", 0.7225, "Distortion Factor");
            public static final ConfigItem<Double> SPAGHETTI_TWIST_BONUS_FACTOR = new ConfigItem<Double>("bonus_factor", 1.65, "Bonus Factor (compensates for distortion)");

            public SpaghettiTwistConfig() {
                super((List<ConfigItem<?>>)ImmutableList.of(SPAGHETTI_TWIST_VANILLA_BIAS, SPAGHETTI_TWIST_BIAS_POWER, SPAGHETTI_TWIST_MODULATOR_SCALE, SPAGHETTI_TWIST_LIMITER, SPAGHETTI_TWIST_BONUS_FACTOR), "Spaghetti Twist");
            }
        }
    }
}

